/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.persistence.OrganizationActionableDynamicQuery;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;

public class OrganizationIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{Organization.class.getName()};
    public static final String PORTLET_ID = "125";

    public OrganizationIndexer() {
        this.setIndexerEnabled(PropsValues.ORGANIZATIONS_INDEXER_ENABLED);
        this.setPermissionAware(true);
        this.setStagingAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        List organizationsTree;
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params == null) {
            return;
        }
        List excludedOrganizationIds = (List)params.get("excludedOrganizationIds");
        if (excludedOrganizationIds != null && !excludedOrganizationIds.isEmpty()) {
            BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            Iterator iterator = excludedOrganizationIds.iterator();
            while (iterator.hasNext()) {
                long excludedOrganizationId = (Long)iterator.next();
                booleanQuery.addTerm("organizationId", String.valueOf(excludedOrganizationId));
            }
            contextQuery.add((Query)booleanQuery, BooleanClauseOccur.MUST_NOT);
        }
        if ((organizationsTree = (List)params.get("organizationsTree")) != null && !organizationsTree.isEmpty()) {
            BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            for (Organization organization : organizationsTree) {
                String treePath = organization.buildTreePath();
                booleanQuery.addTerm("treePath", treePath, true);
            }
            contextQuery.add((Query)booleanQuery, BooleanClauseOccur.MUST);
        } else {
            long parentOrganizationId = GetterUtil.getLong((Object)searchContext.getAttribute("parentOrganizationId"));
            if (parentOrganizationId != -1L) {
                contextQuery.addRequiredTerm("parentOrganizationId", parentOrganizationId);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        Organization organization = (Organization)obj;
        this.deleteDocument(organization.getCompanyId(), organization.getOrganizationId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        Organization organization = (Organization)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)organization);
        document.addKeyword("companyId", organization.getCompanyId());
        document.addText("name", organization.getName());
        document.addKeyword("organizationId", organization.getOrganizationId());
        document.addKeyword("type", organization.getType());
        document.addKeyword("parentOrganizationId", organization.getParentOrganizationId());
        String treePath = organization.buildTreePath();
        document.addKeyword("treePath", treePath);
        this.populateAddresses(document, organization.getAddresses(), organization.getRegionId(), organization.getCountryId());
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("name")) {
            return "name";
        }
        if (orderByCol.equals("type")) {
            return "type";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("name");
        String content = null;
        String organizationId = document.get("organizationId");
        portletURL.setParameter("struts_action", "/users_admin/edit_organization");
        portletURL.setParameter("organizationId", organizationId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        if (obj instanceof List) {
            List organizations = (List)obj;
            for (Organization organization : organizations) {
                this.doReindex(organization);
            }
        } else if (obj instanceof Long) {
            long organizationId = (Long)obj;
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            this.doReindex(organization);
        } else if (obj instanceof long[]) {
            long[] organizationIds = (long[])obj;
            HashMap<Long, ArrayList<Document>> documentsMap = new HashMap<Long, ArrayList<Document>>();
            long[] lArray = organizationIds;
            int n = organizationIds.length;
            int n2 = 0;
            while (n2 < n) {
                long organizationId = lArray[n2];
                Organization organization = OrganizationLocalServiceUtil.fetchOrganization((long)organizationId);
                if (organization != null) {
                    Document document = this.getDocument(organization);
                    long companyId = organization.getCompanyId();
                    ArrayList<Document> documents = (ArrayList<Document>)documentsMap.get(companyId);
                    if (documents == null) {
                        documents = new ArrayList<Document>();
                        documentsMap.put(companyId, documents);
                    }
                    documents.add(document);
                }
                ++n2;
            }
            for (Map.Entry entry : documentsMap.entrySet()) {
                long companyId = (Long)entry.getKey();
                Collection documents = (Collection)entry.getValue();
                SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, (Collection)documents);
            }
        } else if (obj instanceof Organization) {
            Organization organization = (Organization)obj;
            Document document = this.getDocument(organization);
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)organization.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Organization organization = OrganizationLocalServiceUtil.getOrganization((long)classPK);
        this.doReindex(organization);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexOrganizations(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexOrganizations(long companyId) throws Exception {
        final ArrayList documents = new ArrayList();
        OrganizationActionableDynamicQuery actionableDynamicQuery = new OrganizationActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException {
                Organization organization = (Organization)object;
                Document document = OrganizationIndexer.this.getDocument(organization);
                documents.add(document);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

