/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.action;

import com.liferay.portal.NoSuchOrganizationException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Organization;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserGroupServiceUtil;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.usersadmin.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditOrganizationAssignmentsAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("organization_user_groups")) {
                this.updateOrganizationUserGroups(actionRequest);
            } else if (cmd.equals("organization_users")) {
                this.updateOrganizationUsers(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"assignmentsRedirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof MembershipPolicyException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            if (e2 instanceof NoSuchOrganizationException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.users_admin.error");
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getOrganization((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchOrganizationException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.users_admin.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.users_admin.edit_organization_assignments"));
    }

    protected void updateOrganizationUserGroups(ActionRequest actionRequest) throws Exception {
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
        long groupId = organization.getGroup().getGroupId();
        long[] addUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserGroupIds"), (long)0L);
        long[] removeUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserGroupIds"), (long)0L);
        UserGroupServiceUtil.addGroupUserGroups((long)groupId, (long[])addUserGroupIds);
        UserGroupServiceUtil.unsetGroupUserGroups((long)groupId, (long[])removeUserGroupIds);
    }

    protected void updateOrganizationUsers(ActionRequest actionRequest) throws Exception {
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        long[] addUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserIds"), (long)0L);
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        UserServiceUtil.addOrganizationUsers((long)organizationId, (long[])addUserIds);
        UserServiceUtil.unsetOrganizationUsers((long)organizationId, (long[])removeUserIds);
    }
}

