/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.persistence.GroupActionableDynamicQuery;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.service.base.TrashEntryLocalServiceBaseImpl;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class TrashEntryLocalServiceImpl
extends TrashEntryLocalServiceBaseImpl {
    public TrashEntry addTrashEntry(long userId, long groupId, String className, long classPK, int status, List<ObjectValuePair<Long, Integer>> statusOVPs, UnicodeProperties typeSettingsProperties) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        long entryId = this.counterLocalService.increment();
        TrashEntry trashEntry = this.trashEntryPersistence.create(entryId);
        trashEntry.setGroupId(groupId);
        trashEntry.setCompanyId(user.getCompanyId());
        trashEntry.setUserId(user.getUserId());
        trashEntry.setUserName(user.getFullName());
        trashEntry.setCreateDate(new Date());
        trashEntry.setClassNameId(classNameId);
        trashEntry.setClassPK(classPK);
        if (typeSettingsProperties != null) {
            trashEntry.setTypeSettingsProperties(typeSettingsProperties);
        }
        trashEntry.setStatus(status);
        this.trashEntryPersistence.update((BaseModel)trashEntry);
        if (statusOVPs != null) {
            for (ObjectValuePair<Long, Integer> statusOVP : statusOVPs) {
                long versionId = this.counterLocalService.increment();
                TrashVersion trashVersion = this.trashVersionPersistence.create(versionId);
                trashVersion.setEntryId(entryId);
                trashVersion.setClassNameId(classNameId);
                trashVersion.setClassPK(((Long)statusOVP.getKey()).longValue());
                trashVersion.setStatus(((Integer)statusOVP.getValue()).intValue());
                this.trashVersionPersistence.update((BaseModel)trashVersion);
            }
        }
        return trashEntry;
    }

    public void checkEntries() throws PortalException, SystemException {
        GroupActionableDynamicQuery actionableDynamicQuery = new GroupActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                Group group = (Group)object;
                Date date = TrashEntryLocalServiceImpl.this.getMaxAge(group);
                List entries = TrashEntryLocalServiceImpl.this.trashEntryPersistence.findByG_LtCD(group.getGroupId(), date);
                for (TrashEntry entry : entries) {
                    TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName());
                    trashHandler.deleteTrashEntry(entry.getClassPK());
                }
            }
        };
        actionableDynamicQuery.performActions();
    }

    public TrashEntry deleteEntry(long entryId) throws PortalException, SystemException {
        TrashEntry entry = this.trashEntryPersistence.fetchByPrimaryKey(entryId);
        return this.deleteEntry(entry);
    }

    public TrashEntry deleteEntry(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        TrashEntry entry = this.trashEntryPersistence.fetchByC_C(classNameId, classPK);
        return this.deleteEntry(entry);
    }

    @Indexable(type=IndexableType.DELETE)
    public TrashEntry deleteEntry(TrashEntry trashEntry) throws SystemException {
        if (trashEntry != null) {
            this.trashVersionPersistence.removeByEntryId(trashEntry.getEntryId());
            trashEntry = (TrashEntry)this.trashEntryPersistence.remove((BaseModel)trashEntry);
        }
        return trashEntry;
    }

    public TrashEntry fetchEntry(long entryId) throws SystemException {
        return this.trashEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public TrashEntry fetchEntry(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.trashEntryPersistence.fetchByC_C(classNameId, classPK);
    }

    public List<TrashEntry> getEntries(long groupId) throws SystemException {
        return this.trashEntryPersistence.findByGroupId(groupId);
    }

    public List<TrashEntry> getEntries(long groupId, int start, int end) throws SystemException {
        return this.trashEntryPersistence.findByGroupId(groupId, start, end);
    }

    public List<TrashEntry> getEntries(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.trashEntryPersistence.findByGroupId(groupId, start, end, obc);
    }

    public int getEntriesCount(long groupId) throws SystemException {
        return this.trashEntryPersistence.countByGroupId(groupId);
    }

    public TrashEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.trashEntryPersistence.findByPrimaryKey(entryId);
    }

    public TrashEntry getEntry(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.trashEntryPersistence.findByC_C(classNameId, classPK);
    }

    public List<TrashVersion> getVersions(long entryId) throws SystemException {
        return this.trashVersionPersistence.findByEntryId(entryId);
    }

    public List<TrashVersion> getVersions(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.trashVersionPersistence.findByC_C(classNameId, classPK);
    }

    public Hits search(long companyId, long groupId, long userId, String keywords, int start, int end, Sort sort) throws SystemException {
        try {
            SearchContext searchContext = new SearchContext();
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setKeywords(keywords);
            searchContext.setGroupIds(new long[]{groupId});
            if (sort != null) {
                searchContext.setSorts(new Sort[]{sort});
            }
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(TrashEntry.class);
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    protected Date getMaxAge(Group group) throws PortalException, SystemException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int maxAge = TrashUtil.getMaxAge((Group)group);
        calendar.add(12, -maxAge);
        return calendar.getTime();
    }
}

