/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.action;

import com.liferay.portal.TrashPermissionException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.trash.action.ActionUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.service.TrashEntryServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        block17: {
            String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
            try {
                List<ObjectValuePair<String, Long>> entryOVPs = null;
                if (cmd.equals("check")) {
                    JSONObject jsonObject = ActionUtil.checkEntry(actionRequest);
                    this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
                    return;
                }
                if (cmd.equals("delete")) {
                    this.deleteEntries(actionRequest);
                } else if (cmd.equals("empty_trash")) {
                    this.emptyTrash(actionRequest);
                } else if (cmd.equals("move")) {
                    entryOVPs = this.moveEntry(actionRequest);
                } else if (cmd.equals("rename")) {
                    entryOVPs = this.restoreRename(actionRequest);
                } else if (cmd.equals("restore")) {
                    entryOVPs = this.restoreEntries(actionRequest);
                } else if (cmd.equals("override")) {
                    entryOVPs = this.restoreOverride(actionRequest);
                }
                if (cmd.equals("rename") || cmd.equals("restore") || cmd.equals("override") || cmd.equals("move")) {
                    this.addRestoreData((LiferayPortletConfig)portletConfig, actionRequest, entryOVPs);
                }
                this.sendRedirect(actionRequest, actionResponse);
            }
            catch (Exception e2) {
                if (e2 instanceof TrashPermissionException) {
                    TrashPermissionException tpe = (TrashPermissionException)e2;
                    SessionErrors.add((PortletRequest)actionRequest, tpe.getClass(), (Object)tpe);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                }
                WindowState windowState = actionRequest.getWindowState();
                if (!windowState.equals((Object)LiferayWindowState.EXCLUSIVE) && !windowState.equals((Object)LiferayWindowState.POP_UP)) break block17;
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.trash.view"));
    }

    protected void addRestoreData(LiferayPortletConfig liferayPortletConfig, ActionRequest actionRequest, List<ObjectValuePair<String, Long>> entryOVPs) throws Exception {
        if (entryOVPs == null || entryOVPs.size() <= 0) {
            return;
        }
        ArrayList<String> restoreLinks = new ArrayList<String>();
        ArrayList<String> restoreMessages = new ArrayList<String>();
        int i2 = 0;
        while (i2 < entryOVPs.size()) {
            ObjectValuePair<String, Long> entryOVP = entryOVPs.get(i2);
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)((String)entryOVP.getKey()));
            String restoreLink = trashHandler.getRestoreLink((PortletRequest)actionRequest, ((Long)entryOVP.getValue()).longValue());
            String restoreMessage = trashHandler.getRestoreMessage((PortletRequest)actionRequest, ((Long)entryOVP.getValue()).longValue());
            if (!Validator.isNull((String)restoreLink) && !Validator.isNull((String)restoreMessage)) {
                restoreLinks.add(restoreLink);
                restoreMessages.add(restoreMessage);
            }
            ++i2;
        }
        HashMap<String, ArrayList<String>> data = new HashMap<String, ArrayList<String>>();
        data.put("restoreLinks", restoreLinks);
        data.put("restoreMessages", restoreMessages);
        SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".deleteSuccessData"), data);
        SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".hideDefaultSuccessMessage"));
    }

    protected void deleteEntries(ActionRequest actionRequest) throws Exception {
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        if (trashEntryId > 0L) {
            TrashEntryServiceUtil.deleteEntry((long)trashEntryId);
            return;
        }
        long[] deleteEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteThrashEntryIds"), (long)0L);
        if (deleteEntryIds.length > 0) {
            int i2 = 0;
            while (i2 < deleteEntryIds.length) {
                TrashEntryServiceUtil.deleteEntry((long)deleteEntryIds[i2]);
                ++i2;
            }
            return;
        }
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        if (Validator.isNotNull((String)className) && classPK > 0L) {
            TrashEntryServiceUtil.deleteEntry((String)className, (long)classPK);
        }
    }

    protected void emptyTrash(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TrashEntryServiceUtil.deleteEntries((long)themeDisplay.getScopeGroupId());
    }

    protected List<ObjectValuePair<String, Long>> getEntryOVPs(String className, long classPK) {
        ArrayList<ObjectValuePair<String, Long>> entryOVPs = new ArrayList<ObjectValuePair<String, Long>>();
        ObjectValuePair entryOVP = new ObjectValuePair((Object)className, (Object)classPK);
        entryOVPs.add(entryOVP);
        return entryOVPs;
    }

    protected List<ObjectValuePair<String, Long>> moveEntry(ActionRequest actionRequest) throws Exception {
        long containerModelId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"containerModelId");
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)className, (PortletRequest)actionRequest);
        TrashEntryServiceUtil.moveEntry((String)className, (long)classPK, (long)containerModelId, (ServiceContext)serviceContext);
        return this.getEntryOVPs(className, classPK);
    }

    protected List<ObjectValuePair<String, Long>> restoreEntries(ActionRequest actionRequest) throws Exception {
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        if (trashEntryId > 0L) {
            TrashEntry entry = TrashEntryServiceUtil.restoreEntry((long)trashEntryId);
            return this.getEntryOVPs(entry.getClassName(), entry.getClassPK());
        }
        long[] restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L);
        ArrayList<ObjectValuePair<String, Long>> entryOVPs = new ArrayList<ObjectValuePair<String, Long>>();
        int i2 = 0;
        while (i2 < restoreEntryIds.length) {
            TrashEntry entry = TrashEntryServiceUtil.restoreEntry((long)trashEntryId);
            entryOVPs.addAll(this.getEntryOVPs(entry.getClassName(), entry.getClassPK()));
            ++i2;
        }
        return entryOVPs;
    }

    protected List<ObjectValuePair<String, Long>> restoreOverride(ActionRequest actionRequest) throws Exception {
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        long duplicateEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"duplicateEntryId");
        TrashEntry entry = TrashEntryServiceUtil.restoreEntry((long)trashEntryId, (long)duplicateEntryId, null);
        return this.getEntryOVPs(entry.getClassName(), entry.getClassPK());
    }

    protected List<ObjectValuePair<String, Long>> restoreRename(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        String newName = ParamUtil.getString((PortletRequest)actionRequest, (String)"newName");
        if (Validator.isNull((String)newName)) {
            String oldName = ParamUtil.getString((PortletRequest)actionRequest, (String)"oldName");
            newName = TrashUtil.getNewName((ThemeDisplay)themeDisplay, (String)oldName);
        }
        TrashEntry entry = TrashEntryServiceUtil.restoreEntry((long)trashEntryId, (long)0L, (String)newName);
        return this.getEntryOVPs(entry.getClassName(), entry.getClassPK());
    }
}

