/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.softwarecatalog.DuplicateProductEntryModuleIdException;
import com.liferay.portlet.softwarecatalog.NoSuchProductEntryException;
import com.liferay.portlet.softwarecatalog.ProductEntryAuthorException;
import com.liferay.portlet.softwarecatalog.ProductEntryLicenseException;
import com.liferay.portlet.softwarecatalog.ProductEntryNameException;
import com.liferay.portlet.softwarecatalog.ProductEntryPageURLException;
import com.liferay.portlet.softwarecatalog.ProductEntryScreenshotsException;
import com.liferay.portlet.softwarecatalog.ProductEntryShortDescriptionException;
import com.liferay.portlet.softwarecatalog.ProductEntryTypeException;
import com.liferay.portlet.softwarecatalog.action.ActionUtil;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.model.SCProductScreenshot;
import com.liferay.portlet.softwarecatalog.service.SCProductEntryServiceUtil;
import com.liferay.portlet.softwarecatalog.service.SCProductScreenshotLocalServiceUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditProductEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateProductEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteProductEntry(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchProductEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.software_catalog.error");
            }
            if (e2 instanceof DuplicateProductEntryModuleIdException || e2 instanceof ProductEntryAuthorException || e2 instanceof ProductEntryNameException || e2 instanceof ProductEntryLicenseException || e2 instanceof ProductEntryPageURLException || e2 instanceof ProductEntryScreenshotsException || e2 instanceof ProductEntryShortDescriptionException || e2 instanceof ProductEntryTypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getProductEntry((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchProductEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.software_catalog.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.software_catalog.edit_product_entry"));
    }

    protected void deleteProductEntry(ActionRequest actionRequest) throws Exception {
        long productEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"productEntryId");
        SCProductEntryServiceUtil.deleteProductEntry((long)productEntryId);
    }

    protected List<byte[]> getFullImages(UploadPortletRequest uploadPortletRequest) throws Exception {
        return this.getImages(uploadPortletRequest, "fullImage");
    }

    protected List<byte[]> getImages(UploadPortletRequest uploadPortletRequest, String imagePrefix) throws Exception {
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        for (String name : this.getSortedParameterNames(uploadPortletRequest, imagePrefix)) {
            String contentType = uploadPortletRequest.getContentType(name);
            if (!MimeTypesUtil.isWebImage((String)contentType)) {
                throw new ProductEntryScreenshotsException();
            }
            int priority = GetterUtil.getInteger((String)name.substring(imagePrefix.length()));
            boolean preserveScreenshot = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)("preserveScreenshot" + priority));
            byte[] bytes = null;
            if (preserveScreenshot) {
                SCProductScreenshot productScreenshot = this.getProductScreenshot(uploadPortletRequest, priority);
                Image image = null;
                image = imagePrefix.equals("fullImage") ? ImageLocalServiceUtil.getImage((long)productScreenshot.getFullImageId()) : ImageLocalServiceUtil.getImage((long)productScreenshot.getThumbnailId());
                bytes = image.getTextObj();
            } else {
                InputStream inputStream = uploadPortletRequest.getFileAsStream(name);
                if (inputStream != null) {
                    bytes = FileUtil.getBytes((InputStream)inputStream);
                }
            }
            if (bytes != null && bytes.length > 0) {
                images.add(bytes);
                continue;
            }
            throw new ProductEntryScreenshotsException();
        }
        return images;
    }

    protected SCProductScreenshot getProductScreenshot(UploadPortletRequest uploadPortletRequest, int priority) throws Exception {
        long productEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"productEntryId");
        try {
            return SCProductScreenshotLocalServiceUtil.getProductScreenshot((long)productEntryId, (int)priority);
        }
        catch (Exception exception) {
            throw new ProductEntryScreenshotsException();
        }
    }

    protected List<String> getSortedParameterNames(UploadPortletRequest uploadPortletRequest, String imagePrefix) throws Exception {
        ArrayList<String> parameterNames = new ArrayList<String>();
        Enumeration enu = uploadPortletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(imagePrefix)) continue;
            parameterNames.add(name);
        }
        return ListUtil.sort(parameterNames);
    }

    protected List<byte[]> getThumbnails(UploadPortletRequest uploadPortletRequest) throws Exception {
        return this.getImages(uploadPortletRequest, "thumbnail");
    }

    protected void updateProductEntry(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long productEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"productEntryId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        String tags = ParamUtil.getString((PortletRequest)actionRequest, (String)"tags");
        String shortDescription = ParamUtil.getString((PortletRequest)actionRequest, (String)"shortDescription");
        String longDescription = ParamUtil.getString((PortletRequest)actionRequest, (String)"longDescription");
        String pageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"pageURL");
        String author = ParamUtil.getString((PortletRequest)actionRequest, (String)"author");
        String repoGroupId = ParamUtil.getString((PortletRequest)actionRequest, (String)"repoGroupId");
        String repoArtifactId = ParamUtil.getString((PortletRequest)actionRequest, (String)"repoArtifactId");
        long[] licenseIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"licenses");
        List<byte[]> thumbnails = this.getThumbnails(uploadPortletRequest);
        List<byte[]> fullImages = this.getFullImages(uploadPortletRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)SCProductEntry.class.getName(), (PortletRequest)actionRequest);
        if (productEntryId <= 0L) {
            SCProductEntryServiceUtil.addProductEntry((String)name, (String)type, (String)tags, (String)shortDescription, (String)longDescription, (String)pageURL, (String)author, (String)repoGroupId, (String)repoArtifactId, (long[])licenseIds, thumbnails, fullImages, (ServiceContext)serviceContext);
        } else {
            SCProductEntryServiceUtil.updateProductEntry((long)productEntryId, (String)name, (String)type, (String)tags, (String)shortDescription, (String)longDescription, (String)pageURL, (String)author, (String)repoGroupId, (String)repoArtifactId, (long[])licenseIds, thumbnails, fullImages);
        }
    }
}

