/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;
import com.liferay.portlet.social.model.SocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivitySet;
import com.liferay.portlet.social.model.impl.SocialActivityInterpreterImpl;
import com.liferay.portlet.social.service.base.SocialActivityInterpreterLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SocialActivityInterpreterLocalServiceImpl
extends SocialActivityInterpreterLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(SocialActivityInterpreterLocalServiceImpl.class);
    private Map<String, List<SocialActivityInterpreter>> _activityInterpreters = new HashMap<String, List<SocialActivityInterpreter>>();

    public void addActivityInterpreter(SocialActivityInterpreter activityInterpreter) {
        List<SocialActivityInterpreter> activityInterpreters = this._activityInterpreters.get(activityInterpreter.getSelector());
        if (activityInterpreters == null) {
            activityInterpreters = new ArrayList<SocialActivityInterpreter>();
        }
        activityInterpreters.add(activityInterpreter);
        this._activityInterpreters.put(activityInterpreter.getSelector(), activityInterpreters);
    }

    public void deleteActivityInterpreter(SocialActivityInterpreter activityInterpreter) {
        List<SocialActivityInterpreter> activityInterpreters = this._activityInterpreters.get(activityInterpreter.getSelector());
        if (activityInterpreters == null) {
            return;
        }
        activityInterpreters.remove(activityInterpreter);
    }

    public Map<String, List<SocialActivityInterpreter>> getActivityInterpreters() {
        return this._activityInterpreters;
    }

    public SocialActivityFeedEntry interpret(SocialActivity activity, ThemeDisplay themeDisplay) {
        ServiceContext serviceContext = null;
        try {
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)themeDisplay.getRequest());
        }
        catch (Exception exception) {
            return null;
        }
        return this.interpret("", activity, serviceContext);
    }

    public SocialActivityFeedEntry interpret(String selector, SocialActivity activity, ServiceContext serviceContext) {
        List<SocialActivityInterpreter> activityInterpreters;
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (activity.getUserId() == themeDisplay.getDefaultUserId()) {
                return null;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if (activity.getMirrorActivityId() > 0L) {
            SocialActivity mirrorActivity = null;
            try {
                mirrorActivity = this.socialActivityLocalService.getActivity(activity.getMirrorActivityId());
            }
            catch (Exception exception) {}
            if (mirrorActivity != null) {
                activity = mirrorActivity;
            }
        }
        if ((activityInterpreters = this._activityInterpreters.get(selector)) == null) {
            return null;
        }
        String className = PortalUtil.getClassName((long)activity.getClassNameId());
        int i2 = 0;
        while (i2 < activityInterpreters.size()) {
            SocialActivityFeedEntry activityFeedEntry;
            SocialActivityInterpreterImpl activityInterpreter = (SocialActivityInterpreterImpl)activityInterpreters.get(i2);
            if (activityInterpreter.hasClassName(className) && (activityFeedEntry = activityInterpreter.interpret(activity, serviceContext)) != null) {
                activityFeedEntry.setPortletId(activityInterpreter.getPortletId());
                return activityFeedEntry;
            }
            ++i2;
        }
        return null;
    }

    public SocialActivityFeedEntry interpret(String selector, SocialActivitySet activitySet, ServiceContext serviceContext) {
        List<SocialActivityInterpreter> activityInterpreters;
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (activitySet.getUserId() == themeDisplay.getDefaultUserId()) {
                return null;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if ((activityInterpreters = this._activityInterpreters.get(selector)) == null) {
            return null;
        }
        String className = PortalUtil.getClassName((long)activitySet.getClassNameId());
        int i2 = 0;
        while (i2 < activityInterpreters.size()) {
            SocialActivityFeedEntry activityFeedEntry;
            SocialActivityInterpreterImpl activityInterpreter = (SocialActivityInterpreterImpl)activityInterpreters.get(i2);
            if (activityInterpreter.hasClassName(className) && (activityFeedEntry = activityInterpreter.interpret(activitySet, serviceContext)) != null) {
                activityFeedEntry.setPortletId(activityInterpreter.getPortletId());
                return activityFeedEntry;
            }
            ++i2;
        }
        return null;
    }

    public void updateActivitySet(long activityId) throws PortalException, SystemException {
        List<SocialActivityInterpreter> activityInterpreters = this._activityInterpreters.get(PropsValues.SOCIAL_ACTIVITY_SETS_SELECTOR);
        if (activityInterpreters != null) {
            SocialActivity activity = this.socialActivityPersistence.findByPrimaryKey(activityId);
            String className = PortalUtil.getClassName((long)activity.getClassNameId());
            int i2 = 0;
            while (i2 < activityInterpreters.size()) {
                SocialActivityInterpreterImpl activityInterpreter = (SocialActivityInterpreterImpl)activityInterpreters.get(i2);
                if (activityInterpreter.hasClassName(className)) {
                    activityInterpreter.updateActivitySet(activityId);
                    return;
                }
                ++i2;
            }
        }
    }
}

