/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.sites.action;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.service.OrganizationServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserGroupGroupRoleServiceUtil;
import com.liferay.portal.service.UserGroupRoleServiceUtil;
import com.liferay.portal.service.UserGroupServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.sites.action.ActionUtil;
import java.util.HashSet;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditGroupAssignmentsAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("group_organizations")) {
                this.updateGroupOrganizations(actionRequest);
            } else if (cmd.equals("group_user_groups")) {
                this.updateGroupUserGroups(actionRequest);
            } else if (cmd.equals("group_users")) {
                this.updateGroupUsers(actionRequest);
            } else if (cmd.equals("user_group_group_role")) {
                this.updateUserGroupGroupRole(actionRequest);
            } else if (cmd.equals("user_group_role")) {
                this.updateUserGroupRole(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"assignmentsRedirect");
                if (Validator.isNull((String)redirect)) {
                    redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof MembershipPolicyException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.sites_admin.error");
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.sites_admin.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.sites_admin.edit_site_assignments"));
    }

    protected long[] filterAddUserIds(long groupId, long[] userIds) throws Exception {
        HashSet<Long> filteredUserIds = new HashSet<Long>(userIds.length);
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            if (!UserLocalServiceUtil.hasGroupUser((long)groupId, (long)userId)) {
                filteredUserIds.add(userId);
            }
            ++n2;
        }
        return ArrayUtil.toArray((Long[])filteredUserIds.toArray(new Long[filteredUserIds.size()]));
    }

    protected long[] filterRemoveUserIds(long groupId, long[] userIds) throws Exception {
        HashSet<Long> filteredUserIds = new HashSet<Long>(userIds.length);
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            if (UserLocalServiceUtil.hasGroupUser((long)groupId, (long)userId)) {
                filteredUserIds.add(userId);
            }
            ++n2;
        }
        return ArrayUtil.toArray((Long[])filteredUserIds.toArray(new Long[filteredUserIds.size()]));
    }

    protected void updateGroupOrganizations(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] addOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addOrganizationIds"), (long)0L);
        long[] removeOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeOrganizationIds"), (long)0L);
        OrganizationServiceUtil.addGroupOrganizations((long)groupId, (long[])addOrganizationIds);
        OrganizationServiceUtil.unsetGroupOrganizations((long)groupId, (long[])removeOrganizationIds);
    }

    protected void updateGroupUserGroups(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] addUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserGroupIds"), (long)0L);
        long[] removeUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserGroupIds"), (long)0L);
        UserGroupServiceUtil.addGroupUserGroups((long)groupId, (long[])addUserGroupIds);
        UserGroupServiceUtil.unsetGroupUserGroups((long)groupId, (long[])removeUserGroupIds);
    }

    protected void updateGroupUsers(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] addUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addUserIds"), (long)0L);
        addUserIds = this.filterAddUserIds(groupId, addUserIds);
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        removeUserIds = this.filterRemoveUserIds(groupId, removeUserIds);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        UserServiceUtil.addGroupUsers((long)groupId, (long[])addUserIds, (ServiceContext)serviceContext);
        UserServiceUtil.unsetGroupUsers((long)groupId, (long[])removeUserIds, (ServiceContext)serviceContext);
        LiveUsers.joinGroup(themeDisplay.getCompanyId(), groupId, addUserIds);
        LiveUsers.leaveGroup(themeDisplay.getCompanyId(), groupId, removeUserIds);
    }

    protected void updateUserGroupGroupRole(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long userGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userGroupId");
        long[] addRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addRoleIds"), (long)0L);
        long[] removeRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeRoleIds"), (long)0L);
        UserGroupGroupRoleServiceUtil.addUserGroupGroupRoles((long)userGroupId, (long)groupId, (long[])addRoleIds);
        UserGroupGroupRoleServiceUtil.deleteUserGroupGroupRoles((long)userGroupId, (long)groupId, (long[])removeRoleIds);
    }

    protected void updateUserGroupRole(ActionRequest actionRequest) throws Exception {
        User user = PortalUtil.getSelectedUser((PortletRequest)actionRequest, (boolean)false);
        if (user == null) {
            return;
        }
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] addRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addRoleIds"), (long)0L);
        long[] removeRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeRoleIds"), (long)0L);
        UserGroupRoleServiceUtil.addUserGroupRoles((long)user.getUserId(), (long)groupId, (long[])addRoleIds);
        UserGroupRoleServiceUtil.deleteUserGroupRoles((long)user.getUserId(), (long)groupId, (long[])removeRoleIds);
    }
}

