/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.shopping.NoSuchOrderItemException;
import com.liferay.portlet.shopping.model.ShoppingOrderItem;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderItemImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderItemModelImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingOrderItemPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShoppingOrderItemPersistenceImpl
extends BasePersistenceImpl<ShoppingOrderItem>
implements ShoppingOrderItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingOrderItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByOrderId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, ShoppingOrderItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByOrderId", new String[]{Long.class.getName()}, ShoppingOrderItemModelImpl.ORDERID_COLUMN_BITMASK | ShoppingOrderItemModelImpl.NAME_COLUMN_BITMASK | ShoppingOrderItemModelImpl.DESCRIPTION_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_ORDERID = new FinderPath(ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByOrderId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_ORDERID_ORDERID_2 = "shoppingOrderItem.orderId = ?";
    private static final String _SQL_SELECT_SHOPPINGORDERITEM = "SELECT shoppingOrderItem FROM ShoppingOrderItem shoppingOrderItem";
    private static final String _SQL_SELECT_SHOPPINGORDERITEM_WHERE = "SELECT shoppingOrderItem FROM ShoppingOrderItem shoppingOrderItem WHERE ";
    private static final String _SQL_COUNT_SHOPPINGORDERITEM = "SELECT COUNT(shoppingOrderItem) FROM ShoppingOrderItem shoppingOrderItem";
    private static final String _SQL_COUNT_SHOPPINGORDERITEM_WHERE = "SELECT COUNT(shoppingOrderItem) FROM ShoppingOrderItem shoppingOrderItem WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingOrderItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingOrderItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingOrderItem exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static Log _log = LogFactoryUtil.getLog(ShoppingOrderItemPersistenceImpl.class);
    private static ShoppingOrderItem _nullShoppingOrderItem = new ShoppingOrderItemImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<ShoppingOrderItem> toCacheModel() {
            return _nullShoppingOrderItemCacheModel;
        }
    };
    private static CacheModel<ShoppingOrderItem> _nullShoppingOrderItemCacheModel = new CacheModel<ShoppingOrderItem>(){

        public ShoppingOrderItem toEntityModel() {
            return _nullShoppingOrderItem;
        }
    };

    public List<ShoppingOrderItem> findByOrderId(long orderId) throws SystemException {
        return this.findByOrderId(orderId, -1, -1, null);
    }

    public List<ShoppingOrderItem> findByOrderId(long orderId, int start, int end) throws SystemException {
        return this.findByOrderId(orderId, start, end, null);
    }

    public List<ShoppingOrderItem> findByOrderId(long orderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID;
            finderArgs = new Object[]{orderId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ORDERID;
            finderArgs = new Object[]{orderId, start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (ShoppingOrderItem shoppingOrderItem : list) {
                if (orderId == shoppingOrderItem.getOrderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(orderId);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingOrderItem findByOrderId_First(long orderId, OrderByComparator orderByComparator) throws NoSuchOrderItemException, SystemException {
        ShoppingOrderItem shoppingOrderItem = this.fetchByOrderId_First(orderId, orderByComparator);
        if (shoppingOrderItem != null) {
            return shoppingOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("orderId=");
        msg.append(orderId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public ShoppingOrderItem fetchByOrderId_First(long orderId, OrderByComparator orderByComparator) throws SystemException {
        List<ShoppingOrderItem> list = this.findByOrderId(orderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingOrderItem findByOrderId_Last(long orderId, OrderByComparator orderByComparator) throws NoSuchOrderItemException, SystemException {
        ShoppingOrderItem shoppingOrderItem = this.fetchByOrderId_Last(orderId, orderByComparator);
        if (shoppingOrderItem != null) {
            return shoppingOrderItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("orderId=");
        msg.append(orderId);
        msg.append("}");
        throw new NoSuchOrderItemException(msg.toString());
    }

    public ShoppingOrderItem fetchByOrderId_Last(long orderId, OrderByComparator orderByComparator) throws SystemException {
        int count = this.countByOrderId(orderId);
        List<ShoppingOrderItem> list = this.findByOrderId(orderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingOrderItem[] findByOrderId_PrevAndNext(long orderItemId, long orderId, OrderByComparator orderByComparator) throws NoSuchOrderItemException, SystemException {
        ShoppingOrderItem shoppingOrderItem = this.findByPrimaryKey(orderItemId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrderItem[] array = new ShoppingOrderItemImpl[]{this.getByOrderId_PrevAndNext(session, shoppingOrderItem, orderId, orderByComparator, true), shoppingOrderItem, this.getByOrderId_PrevAndNext(session, shoppingOrderItem, orderId, orderByComparator, false)};
            ShoppingOrderItem[] shoppingOrderItemArray = array;
            return shoppingOrderItemArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrderItem getByOrderId_PrevAndNext(Session session, ShoppingOrderItem shoppingOrderItem, long orderId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGORDERITEM_WHERE);
        query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i2 = 0;
            while (i2 < orderByConditionFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i2;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i3 = 0;
            while (i3 < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i3;
            }
        } else {
            query.append(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(orderId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)shoppingOrderItem);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByOrderId(long orderId) throws SystemException {
        for (ShoppingOrderItem shoppingOrderItem : this.findByOrderId(orderId, -1, -1, null)) {
            this.remove((BaseModel)shoppingOrderItem);
        }
    }

    public int countByOrderId(long orderId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ORDERID;
        Object[] finderArgs = new Object[]{orderId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGORDERITEM_WHERE);
            query.append(_FINDER_COLUMN_ORDERID_ORDERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(orderId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void cacheResult(ShoppingOrderItem shoppingOrderItem) {
        EntityCacheUtil.putResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()), (Serializable)shoppingOrderItem);
        shoppingOrderItem.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingOrderItem> shoppingOrderItems) {
        for (ShoppingOrderItem shoppingOrderItem : shoppingOrderItems) {
            if (EntityCacheUtil.getResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey())) == null) {
                this.cacheResult(shoppingOrderItem);
                continue;
            }
            shoppingOrderItem.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)ShoppingOrderItemImpl.class.getName());
        }
        EntityCacheUtil.clearCache((String)ShoppingOrderItemImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingOrderItem shoppingOrderItem) {
        EntityCacheUtil.removeResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<ShoppingOrderItem> shoppingOrderItems) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingOrderItem shoppingOrderItem : shoppingOrderItems) {
            EntityCacheUtil.removeResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()));
        }
    }

    public ShoppingOrderItem create(long orderItemId) {
        ShoppingOrderItemImpl shoppingOrderItem = new ShoppingOrderItemImpl();
        shoppingOrderItem.setNew(true);
        shoppingOrderItem.setPrimaryKey(orderItemId);
        return shoppingOrderItem;
    }

    public ShoppingOrderItem remove(long orderItemId) throws NoSuchOrderItemException, SystemException {
        return this.remove(Long.valueOf(orderItemId));
    }

    public ShoppingOrderItem remove(Serializable primaryKey) throws NoSuchOrderItemException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingOrderItem shoppingOrderItem = (ShoppingOrderItem)session.get(ShoppingOrderItemImpl.class, primaryKey);
            if (shoppingOrderItem == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingOrderItem shoppingOrderItem2 = (ShoppingOrderItem)this.remove((BaseModel)shoppingOrderItem);
            return shoppingOrderItem2;
        }
        catch (NoSuchOrderItemException nsee) {
            throw nsee;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingOrderItem removeImpl(ShoppingOrderItem shoppingOrderItem) throws SystemException {
        shoppingOrderItem = this.toUnwrappedModel(shoppingOrderItem);
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (!session.contains((Object)shoppingOrderItem)) {
                    shoppingOrderItem = (ShoppingOrderItem)session.get(ShoppingOrderItemImpl.class, shoppingOrderItem.getPrimaryKeyObj());
                }
                if (shoppingOrderItem != null) {
                    session.delete((Object)shoppingOrderItem);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingOrderItem != null) {
            this.clearCache(shoppingOrderItem);
        }
        return shoppingOrderItem;
    }

    public ShoppingOrderItem updateImpl(ShoppingOrderItem shoppingOrderItem) throws SystemException {
        shoppingOrderItem = this.toUnwrappedModel(shoppingOrderItem);
        boolean isNew = shoppingOrderItem.isNew();
        ShoppingOrderItemModelImpl shoppingOrderItemModelImpl = (ShoppingOrderItemModelImpl)shoppingOrderItem;
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (shoppingOrderItem.isNew()) {
                    session.save((Object)shoppingOrderItem);
                    shoppingOrderItem.setNew(false);
                } else {
                    session.merge((Object)shoppingOrderItem);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !ShoppingOrderItemModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if ((shoppingOrderItemModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{shoppingOrderItemModelImpl.getOriginalOrderId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_ORDERID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID, (Object[])args);
            args = new Object[]{shoppingOrderItemModelImpl.getOrderId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_ORDERID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ORDERID, (Object[])args);
        }
        EntityCacheUtil.putResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)Long.valueOf(shoppingOrderItem.getPrimaryKey()), (Serializable)shoppingOrderItem);
        return shoppingOrderItem;
    }

    protected ShoppingOrderItem toUnwrappedModel(ShoppingOrderItem shoppingOrderItem) {
        if (shoppingOrderItem instanceof ShoppingOrderItemImpl) {
            return shoppingOrderItem;
        }
        ShoppingOrderItemImpl shoppingOrderItemImpl = new ShoppingOrderItemImpl();
        shoppingOrderItemImpl.setNew(shoppingOrderItem.isNew());
        shoppingOrderItemImpl.setPrimaryKey(shoppingOrderItem.getPrimaryKey());
        shoppingOrderItemImpl.setOrderItemId(shoppingOrderItem.getOrderItemId());
        shoppingOrderItemImpl.setOrderId(shoppingOrderItem.getOrderId());
        shoppingOrderItemImpl.setItemId(shoppingOrderItem.getItemId());
        shoppingOrderItemImpl.setSku(shoppingOrderItem.getSku());
        shoppingOrderItemImpl.setName(shoppingOrderItem.getName());
        shoppingOrderItemImpl.setDescription(shoppingOrderItem.getDescription());
        shoppingOrderItemImpl.setProperties(shoppingOrderItem.getProperties());
        shoppingOrderItemImpl.setPrice(shoppingOrderItem.getPrice());
        shoppingOrderItemImpl.setQuantity(shoppingOrderItem.getQuantity());
        shoppingOrderItemImpl.setShippedDate(shoppingOrderItem.getShippedDate());
        return shoppingOrderItemImpl;
    }

    public ShoppingOrderItem findByPrimaryKey(Serializable primaryKey) throws NoSuchOrderItemException, SystemException {
        ShoppingOrderItem shoppingOrderItem = this.fetchByPrimaryKey(primaryKey);
        if (shoppingOrderItem == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingOrderItem;
    }

    public ShoppingOrderItem findByPrimaryKey(long orderItemId) throws NoSuchOrderItemException, SystemException {
        return this.findByPrimaryKey(Long.valueOf(orderItemId));
    }

    public ShoppingOrderItem fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        ShoppingOrderItem shoppingOrderItem = (ShoppingOrderItem)EntityCacheUtil.getResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)primaryKey);
        if (shoppingOrderItem == _nullShoppingOrderItem) {
            return null;
        }
        if (shoppingOrderItem == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    shoppingOrderItem = (ShoppingOrderItem)session.get(ShoppingOrderItemImpl.class, primaryKey);
                    if (shoppingOrderItem != null) {
                        this.cacheResult(shoppingOrderItem);
                    } else {
                        EntityCacheUtil.putResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)primaryKey, (Serializable)_nullShoppingOrderItem);
                    }
                }
                catch (Exception e2) {
                    EntityCacheUtil.removeResult((boolean)ShoppingOrderItemModelImpl.ENTITY_CACHE_ENABLED, ShoppingOrderItemImpl.class, (Serializable)primaryKey);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingOrderItem;
    }

    public ShoppingOrderItem fetchByPrimaryKey(long orderItemId) throws SystemException {
        return this.fetchByPrimaryKey(Long.valueOf(orderItemId));
    }

    public List<ShoppingOrderItem> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingOrderItem> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<ShoppingOrderItem> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_SHOPPINGORDERITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGORDERITEM;
                if (pagination) {
                    sql = sql.concat(" ORDER BY shoppingOrderItem.name ASC, shoppingOrderItem.description ASC");
                }
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() throws SystemException {
        for (ShoppingOrderItem shoppingOrderItem : this.findAll()) {
            this.remove((BaseModel)shoppingOrderItem);
        }
    }

    public int countAll() throws SystemException {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_SHOPPINGORDERITEM);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.shopping.model.ShoppingOrderItem")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((ClassLoader)this.getClassLoader(), (String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)ShoppingOrderItemImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

