/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.shopping.NoSuchCartException;
import com.liferay.portlet.shopping.model.ShoppingCart;
import com.liferay.portlet.shopping.model.impl.ShoppingCartImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingCartModelImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingCartPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShoppingCartPersistenceImpl
extends BasePersistenceImpl<ShoppingCart>
implements ShoppingCartPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ShoppingCartImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, ShoppingCartModelImpl.GROUPID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "shoppingCart.groupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_USERID = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, ShoppingCartModelImpl.USERID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_USERID = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "shoppingCart.userId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_G_U = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, ShoppingCartImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_U", new String[]{Long.class.getName(), Long.class.getName()}, ShoppingCartModelImpl.GROUPID_COLUMN_BITMASK | ShoppingCartModelImpl.USERID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_U = new FinderPath(ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_U", new String[]{Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_G_U_GROUPID_2 = "shoppingCart.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_U_USERID_2 = "shoppingCart.userId = ?";
    private static final String _SQL_SELECT_SHOPPINGCART = "SELECT shoppingCart FROM ShoppingCart shoppingCart";
    private static final String _SQL_SELECT_SHOPPINGCART_WHERE = "SELECT shoppingCart FROM ShoppingCart shoppingCart WHERE ";
    private static final String _SQL_COUNT_SHOPPINGCART = "SELECT COUNT(shoppingCart) FROM ShoppingCart shoppingCart";
    private static final String _SQL_COUNT_SHOPPINGCART_WHERE = "SELECT COUNT(shoppingCart) FROM ShoppingCart shoppingCart WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "shoppingCart.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ShoppingCart exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ShoppingCart exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static Log _log = LogFactoryUtil.getLog(ShoppingCartPersistenceImpl.class);
    private static ShoppingCart _nullShoppingCart = new ShoppingCartImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<ShoppingCart> toCacheModel() {
            return _nullShoppingCartCacheModel;
        }
    };
    private static CacheModel<ShoppingCart> _nullShoppingCartCacheModel = new CacheModel<ShoppingCart>(){

        public ShoppingCart toEntityModel() {
            return _nullShoppingCart;
        }
    };

    public List<ShoppingCart> findByGroupId(long groupId) throws SystemException {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<ShoppingCart> findByGroupId(long groupId, int start, int end) throws SystemException {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<ShoppingCart> findByGroupId(long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (ShoppingCart shoppingCart : list) {
                if (groupId == shoppingCart.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY shoppingCart.cartId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingCart findByGroupId_First(long groupId, OrderByComparator orderByComparator) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.fetchByGroupId_First(groupId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchCartException(msg.toString());
    }

    public ShoppingCart fetchByGroupId_First(long groupId, OrderByComparator orderByComparator) throws SystemException {
        List<ShoppingCart> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart findByGroupId_Last(long groupId, OrderByComparator orderByComparator) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchCartException(msg.toString());
    }

    public ShoppingCart fetchByGroupId_Last(long groupId, OrderByComparator orderByComparator) throws SystemException {
        int count = this.countByGroupId(groupId);
        List<ShoppingCart> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart[] findByGroupId_PrevAndNext(long cartId, long groupId, OrderByComparator orderByComparator) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.findByPrimaryKey(cartId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart[] array = new ShoppingCartImpl[]{this.getByGroupId_PrevAndNext(session, shoppingCart, groupId, orderByComparator, true), shoppingCart, this.getByGroupId_PrevAndNext(session, shoppingCart, groupId, orderByComparator, false)};
            ShoppingCart[] shoppingCartArray = array;
            return shoppingCartArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart getByGroupId_PrevAndNext(Session session, ShoppingCart shoppingCart, long groupId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i2 = 0;
            while (i2 < orderByConditionFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i2;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i3 = 0;
            while (i3 < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i3;
            }
        } else {
            query.append(" ORDER BY shoppingCart.cartId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)shoppingCart);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingCart)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) throws SystemException {
        for (ShoppingCart shoppingCart : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countByGroupId(long groupId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPID;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ShoppingCart> findByUserId(long userId) throws SystemException {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<ShoppingCart> findByUserId(long userId, int start, int end) throws SystemException {
        return this.findByUserId(userId, start, end, null);
    }

    public List<ShoppingCart> findByUserId(long userId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID;
            finderArgs = new Object[]{userId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_USERID;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (ShoppingCart shoppingCart : list) {
                if (userId == shoppingCart.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            query.append("shoppingCart.userId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY shoppingCart.cartId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(userId);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ShoppingCart findByUserId_First(long userId, OrderByComparator orderByComparator) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.fetchByUserId_First(userId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchCartException(msg.toString());
    }

    public ShoppingCart fetchByUserId_First(long userId, OrderByComparator orderByComparator) throws SystemException {
        List<ShoppingCart> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart findByUserId_Last(long userId, OrderByComparator orderByComparator) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.fetchByUserId_Last(userId, orderByComparator);
        if (shoppingCart != null) {
            return shoppingCart;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchCartException(msg.toString());
    }

    public ShoppingCart fetchByUserId_Last(long userId, OrderByComparator orderByComparator) throws SystemException {
        int count = this.countByUserId(userId);
        List<ShoppingCart> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ShoppingCart[] findByUserId_PrevAndNext(long cartId, long userId, OrderByComparator orderByComparator) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.findByPrimaryKey(cartId);
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart[] array = new ShoppingCartImpl[]{this.getByUserId_PrevAndNext(session, shoppingCart, userId, orderByComparator, true), shoppingCart, this.getByUserId_PrevAndNext(session, shoppingCart, userId, orderByComparator, false)};
            ShoppingCart[] shoppingCartArray = array;
            return shoppingCartArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart getByUserId_PrevAndNext(Session session, ShoppingCart shoppingCart, long userId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
        query.append("shoppingCart.userId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i2 = 0;
            while (i2 < orderByConditionFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i2;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i3 = 0;
            while (i3 < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i3;
            }
        } else {
            query.append(" ORDER BY shoppingCart.cartId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(userId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)shoppingCart);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ShoppingCart)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) throws SystemException {
        for (ShoppingCart shoppingCart : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countByUserId(long userId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_USERID;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            query.append("shoppingCart.userId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(userId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ShoppingCart findByG_U(long groupId, long userId) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.fetchByG_U(groupId, userId);
        if (shoppingCart == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", userId=");
            msg.append(userId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCartException(msg.toString());
        }
        return shoppingCart;
    }

    public ShoppingCart fetchByG_U(long groupId, long userId) throws SystemException {
        return this.fetchByG_U(groupId, userId, true);
    }

    public ShoppingCart fetchByG_U(long groupId, long userId, boolean retrieveFromCache) throws SystemException {
        ShoppingCart shoppingCart;
        Object[] finderArgs = new Object[]{groupId, userId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result instanceof ShoppingCart && (groupId != (shoppingCart = (ShoppingCart)result).getGroupId() || userId != shoppingCart.getUserId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_SHOPPINGCART_WHERE);
            query.append(_FINDER_COLUMN_G_U_GROUPID_2);
            query.append("shoppingCart.userId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(userId);
                    List list = q.list();
                    if (list.isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])finderArgs, (Object)list);
                    } else {
                        ShoppingCart shoppingCart2 = (ShoppingCart)list.get(0);
                        result = shoppingCart2;
                        this.cacheResult(shoppingCart2);
                        if (shoppingCart2.getGroupId() != groupId || shoppingCart2.getUserId() != userId) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])finderArgs, (Object)shoppingCart2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ShoppingCart)result;
    }

    public ShoppingCart removeByG_U(long groupId, long userId) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.findByG_U(groupId, userId);
        return (ShoppingCart)this.remove((BaseModel)shoppingCart);
    }

    public int countByG_U(long groupId, long userId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_U;
        Object[] finderArgs = new Object[]{groupId, userId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_SHOPPINGCART_WHERE);
            query.append(_FINDER_COLUMN_G_U_GROUPID_2);
            query.append("shoppingCart.userId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(userId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void cacheResult(ShoppingCart shoppingCart) {
        EntityCacheUtil.putResult((boolean)ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()), (Serializable)shoppingCart);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])new Object[]{shoppingCart.getGroupId(), shoppingCart.getUserId()}, (Object)shoppingCart);
        shoppingCart.resetOriginalValues();
    }

    public void cacheResult(List<ShoppingCart> shoppingCarts) {
        for (ShoppingCart shoppingCart : shoppingCarts) {
            if (EntityCacheUtil.getResult((boolean)ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey())) == null) {
                this.cacheResult(shoppingCart);
                continue;
            }
            shoppingCart.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)ShoppingCartImpl.class.getName());
        }
        EntityCacheUtil.clearCache((String)ShoppingCartImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(ShoppingCart shoppingCart) {
        EntityCacheUtil.removeResult((boolean)ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache(shoppingCart);
    }

    public void clearCache(List<ShoppingCart> shoppingCarts) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ShoppingCart shoppingCart : shoppingCarts) {
            EntityCacheUtil.removeResult((boolean)ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()));
            this.clearUniqueFindersCache(shoppingCart);
        }
    }

    protected void cacheUniqueFindersCache(ShoppingCart shoppingCart) {
        if (shoppingCart.isNew()) {
            Object[] args = new Object[]{shoppingCart.getGroupId(), shoppingCart.getUserId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_U, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])args, (Object)shoppingCart);
        } else {
            ShoppingCartModelImpl shoppingCartModelImpl = (ShoppingCartModelImpl)shoppingCart;
            if ((shoppingCartModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_U.getColumnBitmask()) != 0L) {
                Object[] args = new Object[]{shoppingCart.getGroupId(), shoppingCart.getUserId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_U, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])args, (Object)shoppingCart);
            }
        }
    }

    protected void clearUniqueFindersCache(ShoppingCart shoppingCart) {
        ShoppingCartModelImpl shoppingCartModelImpl = (ShoppingCartModelImpl)shoppingCart;
        Object[] args = new Object[]{shoppingCart.getGroupId(), shoppingCart.getUserId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_G_U, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])args);
        if ((shoppingCartModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_U.getColumnBitmask()) != 0L) {
            args = new Object[]{shoppingCartModelImpl.getOriginalGroupId(), shoppingCartModelImpl.getOriginalUserId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_G_U, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_U, (Object[])args);
        }
    }

    public ShoppingCart create(long cartId) {
        ShoppingCartImpl shoppingCart = new ShoppingCartImpl();
        shoppingCart.setNew(true);
        shoppingCart.setPrimaryKey(cartId);
        return shoppingCart;
    }

    public ShoppingCart remove(long cartId) throws NoSuchCartException, SystemException {
        return this.remove(Long.valueOf(cartId));
    }

    public ShoppingCart remove(Serializable primaryKey) throws NoSuchCartException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            ShoppingCart shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, primaryKey);
            if (shoppingCart == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCartException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ShoppingCart shoppingCart2 = (ShoppingCart)this.remove((BaseModel)shoppingCart);
            return shoppingCart2;
        }
        catch (NoSuchCartException nsee) {
            throw nsee;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ShoppingCart removeImpl(ShoppingCart shoppingCart) throws SystemException {
        shoppingCart = this.toUnwrappedModel(shoppingCart);
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (!session.contains((Object)shoppingCart)) {
                    shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, shoppingCart.getPrimaryKeyObj());
                }
                if (shoppingCart != null) {
                    session.delete((Object)shoppingCart);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        if (shoppingCart != null) {
            this.clearCache(shoppingCart);
        }
        return shoppingCart;
    }

    public ShoppingCart updateImpl(ShoppingCart shoppingCart) throws SystemException {
        shoppingCart = this.toUnwrappedModel(shoppingCart);
        boolean isNew = shoppingCart.isNew();
        ShoppingCartModelImpl shoppingCartModelImpl = (ShoppingCartModelImpl)shoppingCart;
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (shoppingCart.isNew()) {
                    session.save((Object)shoppingCart);
                    shoppingCart.setNew(false);
                } else {
                    session.merge((Object)shoppingCart);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !ShoppingCartModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((shoppingCartModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingCartModelImpl.getOriginalGroupId()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, (Object[])args);
                args = new Object[]{shoppingCartModelImpl.getGroupId()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, (Object[])args);
            }
            if ((shoppingCartModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID.getColumnBitmask()) != 0L) {
                args = new Object[]{shoppingCartModelImpl.getOriginalUserId()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_USERID, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID, (Object[])args);
                args = new Object[]{shoppingCartModelImpl.getUserId()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_USERID, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID, (Object[])args);
            }
        }
        EntityCacheUtil.putResult((boolean)ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)Long.valueOf(shoppingCart.getPrimaryKey()), (Serializable)shoppingCart);
        this.clearUniqueFindersCache(shoppingCart);
        this.cacheUniqueFindersCache(shoppingCart);
        return shoppingCart;
    }

    protected ShoppingCart toUnwrappedModel(ShoppingCart shoppingCart) {
        if (shoppingCart instanceof ShoppingCartImpl) {
            return shoppingCart;
        }
        ShoppingCartImpl shoppingCartImpl = new ShoppingCartImpl();
        shoppingCartImpl.setNew(shoppingCart.isNew());
        shoppingCartImpl.setPrimaryKey(shoppingCart.getPrimaryKey());
        shoppingCartImpl.setCartId(shoppingCart.getCartId());
        shoppingCartImpl.setGroupId(shoppingCart.getGroupId());
        shoppingCartImpl.setCompanyId(shoppingCart.getCompanyId());
        shoppingCartImpl.setUserId(shoppingCart.getUserId());
        shoppingCartImpl.setUserName(shoppingCart.getUserName());
        shoppingCartImpl.setCreateDate(shoppingCart.getCreateDate());
        shoppingCartImpl.setModifiedDate(shoppingCart.getModifiedDate());
        shoppingCartImpl.setItemIds(shoppingCart.getItemIds());
        shoppingCartImpl.setCouponCodes(shoppingCart.getCouponCodes());
        shoppingCartImpl.setAltShipping(shoppingCart.getAltShipping());
        shoppingCartImpl.setInsure(shoppingCart.isInsure());
        return shoppingCartImpl;
    }

    public ShoppingCart findByPrimaryKey(Serializable primaryKey) throws NoSuchCartException, SystemException {
        ShoppingCart shoppingCart = this.fetchByPrimaryKey(primaryKey);
        if (shoppingCart == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCartException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return shoppingCart;
    }

    public ShoppingCart findByPrimaryKey(long cartId) throws NoSuchCartException, SystemException {
        return this.findByPrimaryKey(Long.valueOf(cartId));
    }

    public ShoppingCart fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        ShoppingCart shoppingCart = (ShoppingCart)EntityCacheUtil.getResult((boolean)ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)primaryKey);
        if (shoppingCart == _nullShoppingCart) {
            return null;
        }
        if (shoppingCart == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    shoppingCart = (ShoppingCart)session.get(ShoppingCartImpl.class, primaryKey);
                    if (shoppingCart != null) {
                        this.cacheResult(shoppingCart);
                    } else {
                        EntityCacheUtil.putResult((boolean)ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)primaryKey, (Serializable)_nullShoppingCart);
                    }
                }
                catch (Exception e2) {
                    EntityCacheUtil.removeResult((boolean)ShoppingCartModelImpl.ENTITY_CACHE_ENABLED, ShoppingCartImpl.class, (Serializable)primaryKey);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return shoppingCart;
    }

    public ShoppingCart fetchByPrimaryKey(long cartId) throws SystemException {
        return this.fetchByPrimaryKey(Long.valueOf(cartId));
    }

    public List<ShoppingCart> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<ShoppingCart> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<ShoppingCart> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_SHOPPINGCART);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_SHOPPINGCART;
                if (pagination) {
                    sql = sql.concat(" ORDER BY shoppingCart.cartId ASC");
                }
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() throws SystemException {
        for (ShoppingCart shoppingCart : this.findAll()) {
            this.remove((BaseModel)shoppingCart);
        }
    }

    public int countAll() throws SystemException {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_SHOPPINGCART);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.shopping.model.ShoppingCart")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((ClassLoader)this.getClassLoader(), (String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)ShoppingCartImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

