/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemPrice;
import com.liferay.portlet.shopping.model.impl.ShoppingCategoryImpl;
import com.liferay.portlet.shopping.model.impl.ShoppingItemBaseImpl;
import com.liferay.portlet.shopping.service.ShoppingCategoryLocalServiceUtil;
import com.liferay.portlet.shopping.service.ShoppingItemPriceLocalServiceUtil;
import com.liferay.portlet.shopping.util.comparator.ItemNameComparator;
import java.util.List;

public class ShoppingItemImpl
extends ShoppingItemBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ShoppingItemImpl.class);
    private String[] _fieldsQuantitiesArray;

    @Override
    public int compareTo(ShoppingItem item) {
        return new ItemNameComparator(true).compare((Object)this, (Object)item);
    }

    public ShoppingCategory getCategory() {
        ShoppingCategoryImpl category = null;
        if (this.getCategoryId() > 0L) {
            try {
                category = ShoppingCategoryLocalServiceUtil.getCategory((long)this.getCategoryId());
            }
            catch (Exception e2) {
                category = new ShoppingCategoryImpl();
                category.setGroupId(this.getGroupId());
                _log.error((Throwable)e2);
            }
        } else {
            category = new ShoppingCategoryImpl();
            category.setGroupId(this.getGroupId());
        }
        return category;
    }

    public String[] getFieldsQuantitiesArray() {
        return this._fieldsQuantitiesArray;
    }

    public List<ShoppingItemPrice> getItemPrices() throws PortalException, SystemException {
        return ShoppingItemPriceLocalServiceUtil.getItemPrices((long)this.getItemId());
    }

    @Override
    public void setFieldsQuantities(String fieldsQuantities) {
        this._fieldsQuantitiesArray = StringUtil.split((String)fieldsQuantities);
        super.setFieldsQuantities(fieldsQuantities);
    }

    public void setFieldsQuantitiesArray(String[] fieldsQuantitiesArray) {
        this._fieldsQuantitiesArray = fieldsQuantitiesArray;
        super.setFieldsQuantities(StringUtil.merge((Object[])fieldsQuantitiesArray));
    }
}

