/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rss.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandler;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.lar.JournalPortletDataHandler;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class RSSPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "rss";
    private static Log _log = LogFactoryUtil.getLog(RSSPortletDataHandler.class);

    public RSSPortletDataHandler() {
        PortletDataHandlerControl[] exportMetadataControls;
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDataPortletPreferences(new String[]{"footerArticleValues", "headerArticleValues"});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "selected-web-content", true, true, null, JournalArticle.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "embedded-assets")});
        JournalPortletDataHandler journalPortletDataHandler = new JournalPortletDataHandler();
        DLPortletDataHandler dlPortletDataHandler = new DLPortletDataHandler();
        PortletDataHandlerControl[] portletDataHandlerControlArray = exportMetadataControls = (PortletDataHandlerControl[])ArrayUtil.append((Object[])journalPortletDataHandler.getExportMetadataControls(), (Object[])dlPortletDataHandler.getExportMetadataControls());
        int n = exportMetadataControls.length;
        int n2 = 0;
        while (n2 < n) {
            PortletDataHandlerControl portletDataHandlerControl = portletDataHandlerControlArray[n2];
            portletDataHandlerControl.setNamespace(NAMESPACE);
            ++n2;
        }
        this.setExportMetadataControls(exportMetadataControls);
        this.setImportControls(new PortletDataHandlerControl[]{this.getExportControls()[0]});
        this.setPublishToLiveByDefault(true);
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("expandedItemsPerChannel", "");
        portletPreferences.setValue("feedImageAlignment", "");
        portletPreferences.setValues("footerArticleValues", new String[]{"0", ""});
        portletPreferences.setValues("headerArticleValues", new String[]{"0", ""});
        portletPreferences.setValue("itemsPerChannel", "");
        portletPreferences.setValue("showFeedDescription", "");
        portletPreferences.setValue("showFeedImage", "");
        portletPreferences.setValue("showFeedItemAuthor", "");
        portletPreferences.setValue("showFeedPublishedDate", "");
        portletPreferences.setValue("showFeedTitle", "");
        portletPreferences.setValue("titles", "");
        portletPreferences.setValue("urls", "");
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        JournalArticle headerArticle;
        JournalArticle footerArticle;
        ArrayList<JournalArticle> articles;
        block11: {
            long headerArticleGroupId;
            String headerArticleId;
            block10: {
                String[] footerArticleValues = portletPreferences.getValues("footerArticleValues", new String[]{"0", ""});
                String[] headerArticleValues = portletPreferences.getValues("headerArticleValues", new String[]{"0", ""});
                String footerArticleId = footerArticleValues[1];
                headerArticleId = headerArticleValues[1];
                if (Validator.isNull((String)footerArticleId) && Validator.isNull((String)headerArticleId)) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No article ids found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                long footerArticleGroupId = GetterUtil.getLong((String)footerArticleValues[0]);
                headerArticleGroupId = GetterUtil.getLong((String)headerArticleValues[0]);
                if (footerArticleGroupId <= 0L && headerArticleGroupId <= 0L) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No group ids found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                articles = new ArrayList<JournalArticle>(2);
                footerArticle = null;
                try {
                    footerArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)footerArticleGroupId, (String)footerArticleId, (int)0);
                    articles.add(footerArticle);
                }
                catch (NoSuchArticleException noSuchArticleException) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn((Object)("No approved article found with group id " + footerArticleGroupId + " and article id " + footerArticleId));
                }
            }
            headerArticle = null;
            try {
                headerArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)headerArticleGroupId, (String)headerArticleId, (int)0);
                articles.add(headerArticle);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn((Object)("No approved article found with group id " + headerArticleGroupId + " and article id " + headerArticleId));
            }
        }
        if (footerArticle == null && headerArticle == null) {
            return "";
        }
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        for (JournalArticle article : articles) {
            String path = ExportImportPathUtil.getModelPath((StagedModel)article);
            Element articleElement = null;
            articleElement = article == footerArticle ? rootElement.addElement("footer-article") : rootElement.addElement("header-article");
            articleElement.addAttribute("path", path);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)article);
            portletDataContext.addReferenceElement((StagedModel)article, articleElement, (ClassedModel)article, "weak", false);
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getPlid());
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element footerArticleElement = rootElement.element("footer-article");
        this.importReferenceArticle(portletDataContext, footerArticleElement);
        String[] footerArticleValues = portletPreferences.getValues("footerArticleValues", new String[]{"0", ""});
        String footerArticleId = footerArticleValues[1];
        footerArticleId = MapUtil.getString((Map)articleIds, (String)footerArticleId, (String)footerArticleId);
        if (Validator.isNotNull((String)footerArticleId)) {
            footerArticleId = MapUtil.getString((Map)articleIds, (String)footerArticleId, (String)footerArticleId);
            portletPreferences.setValues("footerArticleValues", new String[]{String.valueOf(portletDataContext.getScopeGroupId()), footerArticleId});
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)footerArticleId, (boolean)true);
        }
        Element headerArticleElement = rootElement.element("header-article");
        this.importReferenceArticle(portletDataContext, headerArticleElement);
        String[] headerArticleValues = portletPreferences.getValues("headerArticleValues", new String[]{"0", ""});
        String headerArticleId = headerArticleValues[1];
        headerArticleId = MapUtil.getString((Map)articleIds, (String)headerArticleId, (String)headerArticleId);
        if (Validator.isNotNull((String)headerArticleId)) {
            headerArticleId = MapUtil.getString((Map)articleIds, (String)headerArticleId, (String)headerArticleId);
            portletPreferences.setValues("headerArticleValues", new String[]{String.valueOf(portletDataContext.getScopeGroupId()), headerArticleId});
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)headerArticleId, (boolean)true);
        }
        return portletPreferences;
    }

    protected void importReferenceArticle(PortletDataContext portletDataContext, Element parentElement) throws PortletDataException {
        List referenceDataElements = portletDataContext.getReferenceDataElements(parentElement, JournalArticle.class);
        if (referenceDataElements.isEmpty()) {
            return;
        }
        for (Element referenceDataElement : referenceDataElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)referenceDataElement);
        }
    }
}

