/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rolesadmin.lar;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.RoleExportActionableDynamicQuery;
import com.liferay.portal.util.PortalUtil;
import java.util.List;
import javax.portlet.PortletPreferences;

public class RolesAdminPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "roles_admin";

    public RolesAdminPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTAL);
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "system-roles", true, false)});
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(RolesAdminPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        List roles = RoleLocalServiceUtil.getRoles((long)portletDataContext.getCompanyId());
        for (Role role : roles) {
            if (PortalUtil.isSystemRole((String)role.getName())) continue;
            RoleLocalServiceUtil.deleteRole((Role)role);
        }
        return portletPreferences;
    }

    protected String doExportData(final PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("90", portletDataContext.getCompanyId());
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        RoleExportActionableDynamicQuery actionableDynamicQuery = new RoleExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                long classNameId = PortalUtil.getClassNameId(Team.class);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(classNameIdProperty.ne((Object)classNameId));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                Role role = (Role)object;
                if (!portletDataContext.getBooleanParameter(RolesAdminPortletDataHandler.NAMESPACE, "system-roles")) {
                    return;
                }
                long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)portletDataContext.getCompanyId());
                if (role.getUserId() == defaultUserId) {
                    return;
                }
                super.performAction(object);
            }
        };
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("90", portletDataContext.getSourceCompanyId(), portletDataContext.getCompanyId());
        Element rolesElement = portletDataContext.getImportDataGroupElement(Role.class);
        List roleElements = rolesElement.elements();
        for (Element roleElement : roleElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)roleElement);
        }
        return null;
    }
}

