/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portlet.ratings.model.RatingsStats;
import com.liferay.portlet.ratings.service.RatingsEntryServiceUtil;
import com.liferay.portlet.ratings.service.RatingsStatsLocalServiceUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class RateEntryAction
extends JSONAction {
    @Override
    public String getJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String className = this.getClassName(request);
        long classPK = this.getClassPK(request);
        double score = ParamUtil.getDouble((HttpServletRequest)request, (String)"score");
        if (score == 0.0) {
            RatingsEntryServiceUtil.deleteEntry((String)className, (long)classPK);
        } else {
            RatingsEntryServiceUtil.updateEntry((String)className, (long)classPK, (double)score);
        }
        RatingsStats stats = RatingsStatsLocalServiceUtil.getStats((String)className, (long)classPK);
        double averageScore = MathUtil.format((double)stats.getAverageScore(), (int)1, (int)1);
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
        jsonObj.put("totalEntries", stats.getTotalEntries());
        jsonObj.put("totalScore", stats.getTotalScore());
        jsonObj.put("averageScore", averageScore);
        return jsonObj.toString();
    }

    protected String getClassName(HttpServletRequest request) {
        return ParamUtil.getString((HttpServletRequest)request, (String)"className");
    }

    protected long getClassPK(HttpServletRequest request) {
        return ParamUtil.getLong((HttpServletRequest)request, (String)"classPK");
    }
}

