/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARFileSizeException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatalists.RecordSetDuplicateRecordSetKeyException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateStructureKeyException;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportImportAction
extends EditConfigurationAction {
    private static Log _log = LogFactoryUtil.getLog(ExportImportAction.class);

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (Validator.isNotNull((String)cmd)) {
                if (cmd.equals("copy_from_live")) {
                    StagingUtil.copyFromLive((PortletRequest)actionRequest, (Portlet)portlet);
                    this.sendRedirect(actionRequest, actionResponse);
                } else if (cmd.equals("export")) {
                    this.exportData(actionRequest, actionResponse, portlet);
                    this.sendRedirect(actionRequest, actionResponse);
                } else if (cmd.equals("import")) {
                    this.checkExceededSizeLimit((PortletRequest)actionRequest);
                    this.importData(actionRequest, actionResponse, portlet);
                    this.sendRedirect(actionRequest, actionResponse);
                } else if (cmd.equals("publish_to_live")) {
                    StagingUtil.publishToLive((PortletRequest)actionRequest, (Portlet)portlet);
                    this.sendRedirect(actionRequest, actionResponse);
                }
            } else {
                Date endDate;
                long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
                DateRange dateRange = ExportImportHelperUtil.getDateRange((PortletRequest)actionRequest, (long)0L, (boolean)false, (long)plid, (String)portlet.getPortletId());
                Date startDate = dateRange.getStartDate();
                if (startDate != null) {
                    actionResponse.setRenderParameter("startDate", String.valueOf(startDate.getTime()));
                }
                if ((endDate = dateRange.getEndDate()) != null) {
                    actionResponse.setRenderParameter("endDate", String.valueOf(endDate.getTime()));
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof LARFileSizeException || e2 instanceof NoSuchLayoutException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.export_import"));
    }

    protected void checkExceededSizeLimit(PortletRequest portletRequest) throws PortalException {
        UploadException uploadException = (UploadException)portletRequest.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            if (uploadException.isExceededSizeLimit()) {
                throw new LARFileSizeException(uploadException.getCause());
            }
            throw new PortalException(uploadException.getCause());
        }
    }

    protected void exportData(ActionRequest actionRequest, ActionResponse actionResponse, Portlet portlet) throws Exception {
        block6: {
            File file = null;
            try {
                try {
                    long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
                    long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
                    String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportFileName");
                    DateRange dateRange = ExportImportHelperUtil.getDateRange((PortletRequest)actionRequest, (long)groupId, (boolean)false, (long)plid, (String)portlet.getPortletId());
                    file = LayoutServiceUtil.exportPortletInfoAsFile((long)plid, (long)groupId, (String)portlet.getPortletId(), (Map)actionRequest.getParameterMap(), (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate());
                    HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)new FileInputStream(file), (String)"application/zip");
                    this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
                }
                catch (Exception e2) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e2, (Throwable)e2);
                    }
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                    FileUtil.delete(file);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
            FileUtil.delete((File)file);
        }
    }

    protected void importData(ActionRequest actionRequest, ActionResponse actionResponse, Portlet portlet) throws Exception {
        try {
            UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
            long plid = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"plid");
            long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
            File file = uploadPortletRequest.getFile("importFileName");
            if (!file.exists()) {
                throw new LARFileException("Import file does not exist");
            }
            LayoutServiceUtil.importPortletInfo((long)plid, (long)groupId, (String)portlet.getPortletId(), (Map)actionRequest.getParameterMap(), (File)file);
            this.addSuccessMessage(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof LARFileException || e2 instanceof LARTypeException || e2 instanceof PortletIdException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof LocaleException || e2 instanceof RecordSetDuplicateRecordSetKeyException || e2 instanceof StructureDuplicateStructureKeyException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            _log.error((Object)e2, (Throwable)e2);
            SessionErrors.add((PortletRequest)actionRequest, (String)LayoutImportException.class.getName());
        }
    }
}

