/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditSharingAction
extends EditConfigurationAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        String tabs2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs2");
        if (tabs2.equals("any-website")) {
            this.updateAnyWebsite(actionRequest, preferences);
        } else if (tabs2.equals("facebook")) {
            this.updateFacebook(actionRequest, preferences);
        } else if (tabs2.equals("friends")) {
            this.updateFriends(actionRequest, preferences);
        } else if (tabs2.equals("opensocial-gadget")) {
            this.updateGoogleGadget(actionRequest, preferences);
        } else if (tabs2.equals("netvibes")) {
            this.updateNetvibes(actionRequest, preferences);
        }
        preferences.store();
        if (!SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            return;
        }
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".refreshPortlet"), (Object)portletResource);
        SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".updatedConfiguration"));
        String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
        if (Validator.isNotNull((String)redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_sharing"));
    }

    protected void updateAnyWebsite(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean widgetShowAddAppLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"widgetShowAddAppLink");
        preferences.setValue("lfrWidgetShowAddAppLink", String.valueOf(widgetShowAddAppLink));
    }

    protected void updateFacebook(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String facebookAPIKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"facebookAPIKey");
        String facebookCanvasPageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"facebookCanvasPageURL");
        boolean facebookShowAddAppLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"facebookShowAddAppLink");
        preferences.setValue("lfrFacebookApiKey", facebookAPIKey);
        preferences.setValue("lfrFacebookCanvasPageUrl", facebookCanvasPageURL);
        preferences.setValue("lfrFacebookShowAddAppLink", String.valueOf(facebookShowAddAppLink));
    }

    protected void updateFriends(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean appShowShareWithFriendsLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"appShowShareWithFriendsLink");
        preferences.setValue("lfrAppShowShareWithFriendsLink", String.valueOf(appShowShareWithFriendsLink));
    }

    protected void updateGoogleGadget(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean iGoogleShowAddAppLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"iGoogleShowAddAppLink");
        preferences.setValue("lfrIgoogleShowAddAppLink", String.valueOf(iGoogleShowAddAppLink));
    }

    protected void updateNetvibes(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean netvibesShowAddAppLink = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"netvibesShowAddAppLink");
        preferences.setValue("lfrNetvibesShowAddAppLink", String.valueOf(netvibesShowAddAppLink));
    }
}

