/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.lar;

import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.StagedModel;
import com.liferay.portlet.polls.NoSuchQuestionException;
import com.liferay.portlet.polls.lar.PollsPortletDataHandler;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.model.PollsVote;
import com.liferay.portlet.polls.service.persistence.PollsQuestionUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PollsDisplayPortletDataHandler
extends PollsPortletDataHandler {
    private static Log _log = LogFactoryUtil.getLog(PollsDisplayPortletDataHandler.class);

    public PollsDisplayPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDataPortletPreferences(new String[]{"questionId"});
        this.setPublishToLiveByDefault(true);
    }

    @Override
    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("questionId", "");
        return portletPreferences;
    }

    @Override
    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long questionId = GetterUtil.getLong((String)portletPreferences.getValue("questionId", ""));
        if (questionId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No question id found in preferences of portlet " + portletId));
            }
            return "";
        }
        PollsQuestion question = null;
        try {
            question = PollsQuestionUtil.findByPrimaryKey((long)questionId);
        }
        catch (NoSuchQuestionException nsqe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsqe, (Throwable)nsqe);
            }
            return "";
        }
        portletDataContext.addPermissions("com.liferay.portlet.polls", portletDataContext.getScopeGroupId());
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)question);
        return this.getExportDataRootElementString(rootElement);
    }

    @Override
    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        long questionId;
        portletDataContext.importPermissions("com.liferay.portlet.polls", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Element questionsElement = portletDataContext.getImportDataGroupElement(PollsQuestion.class);
        List questionElements = questionsElement.elements();
        for (Element questionElement : questionElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)questionElement);
        }
        Element choicesElement = portletDataContext.getImportDataGroupElement(PollsChoice.class);
        List choiceElements = choicesElement.elements();
        for (Element choiceElement : choiceElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)choiceElement);
        }
        if (portletDataContext.getBooleanParameter("polls", "votes")) {
            Element votesElement = portletDataContext.getImportDataGroupElement(PollsVote.class);
            List voteElements = votesElement.elements();
            for (Element voteElement : voteElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)voteElement);
            }
        }
        if ((questionId = GetterUtil.getLong((String)portletPreferences.getValue("questionId", ""))) > 0L) {
            Map questionIds = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
            questionId = MapUtil.getLong((Map)questionIds, (long)questionId, (long)questionId);
            portletPreferences.setValue("questionId", String.valueOf(questionId));
        }
        return portletPreferences;
    }
}

