/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.PollsChoiceLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsQuestionLocalServiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceFinderUtil;
import java.util.Map;

public class PollsChoiceStagedModelDataHandler
extends BaseStagedModelDataHandler<PollsChoice> {
    public static final String[] CLASS_NAMES = new String[]{PollsChoice.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(PollsChoice choice) {
        return choice.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, PollsChoice choice) throws Exception {
        PollsQuestion question = PollsQuestionLocalServiceUtil.getQuestion((long)choice.getQuestionId());
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)question);
        Element choiceElement = portletDataContext.getExportDataElement((ClassedModel)choice);
        portletDataContext.addClassedModel(choiceElement, ExportImportPathUtil.getModelPath((StagedModel)choice), (ClassedModel)choice, "polls");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, PollsChoice choice) throws Exception {
        long userId = portletDataContext.getUserId(choice.getUserUuid());
        String questionPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)PollsQuestion.class.getName(), (long)choice.getQuestionId());
        PollsQuestion question = (PollsQuestion)portletDataContext.getZipEntryAsObject(questionPath);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)question);
        Map questionIds = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
        long questionId = MapUtil.getLong((Map)questionIds, (long)choice.getQuestionId(), (long)choice.getQuestionId());
        PollsChoice importedChoice = null;
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)choice, "polls");
        if (portletDataContext.isDataStrategyMirror()) {
            PollsChoice existingChoice = PollsChoiceFinderUtil.fetchByUUID_G((String)choice.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingChoice == null) {
                serviceContext.setUuid(choice.getUuid());
                importedChoice = PollsChoiceLocalServiceUtil.addChoice((long)userId, (long)questionId, (String)choice.getName(), (String)choice.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedChoice = PollsChoiceLocalServiceUtil.updateChoice((long)existingChoice.getChoiceId(), (long)questionId, (String)choice.getName(), (String)choice.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            importedChoice = PollsChoiceLocalServiceUtil.addChoice((long)userId, (long)questionId, (String)choice.getName(), (String)choice.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)choice, (ClassedModel)importedChoice, "polls");
    }
}

