/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.nestedportlets.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ViewAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(ViewAction.class);
    private static Pattern _columnIdPattern = Pattern.compile("([<].*?id=[\"'])([^ ]*?)([\"'].*?[>])", 32);
    private static Pattern _processColumnPattern = Pattern.compile("(processColumn[(]\")(.*?)(\"(?:, *\"(?:.*?)\")?[)])", 32);

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Portlet portlet = (Portlet)renderRequest.getAttribute("RENDER_PORTLET");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)renderRequest, (String)portlet.getPortletId());
        String layoutTemplateId = preferences.getValue("layoutTemplateId", PropsValues.NESTED_PORTLETS_LAYOUT_TEMPLATE_DEFAULT);
        String velocityTemplateId = "";
        String velocityTemplateContent = "";
        HashMap<String, String> columnIds = new HashMap<String, String>();
        if (Validator.isNotNull((String)layoutTemplateId)) {
            Theme theme = themeDisplay.getTheme();
            LayoutTemplate layoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)false, (String)theme.getThemeId());
            String content = layoutTemplate.getContent();
            Matcher processColumnMatcher = _processColumnPattern.matcher(content);
            while (processColumnMatcher.find()) {
                String columnId = processColumnMatcher.group(2);
                if (!Validator.isNotNull((String)columnId)) continue;
                columnIds.put(columnId, String.valueOf(renderResponse.getNamespace()) + "_" + columnId);
            }
            processColumnMatcher.reset();
            StringBundler sb = new StringBundler(4);
            sb.append(theme.getThemeId());
            sb.append("_CUSTOM_");
            sb.append(renderResponse.getNamespace());
            sb.append(layoutTemplateId);
            velocityTemplateId = sb.toString();
            content = processColumnMatcher.replaceAll("$1\\${$2}$3");
            Matcher columnIdMatcher = _columnIdPattern.matcher(content);
            velocityTemplateContent = columnIdMatcher.replaceAll("$1" + renderResponse.getNamespace() + "$2$3");
        }
        this.checkLayout(themeDisplay.getLayout(), columnIds.values());
        renderRequest.setAttribute("NESTED_PORTLET_VELOCITY_TEMPLATE_ID", (Object)velocityTemplateId);
        renderRequest.setAttribute("NESTED_PORTLET_VELOCITY_TEMPLATE_CONTENT", (Object)velocityTemplateContent);
        Map vmVariables = (Map)renderRequest.getAttribute("VM_VARIABLES");
        if (vmVariables != null) {
            vmVariables.putAll(columnIds);
        } else {
            renderRequest.setAttribute("VM_VARIABLES", columnIds);
        }
        return mapping.findForward("portlet.nested_portlets.view");
    }

    protected void checkLayout(Layout layout, Collection<String> columnIds) {
        block4: {
            UnicodeProperties properties = layout.getTypeSettingsProperties();
            Object[] layoutColumnIds = StringUtil.split((String)((String)properties.get((Object)"nested-column-ids")));
            boolean updateColumnIds = false;
            for (String columnId : columnIds) {
                String portletIds = properties.getProperty(columnId);
                if (!Validator.isNotNull((String)portletIds) || ArrayUtil.contains((Object[])layoutColumnIds, (Object)columnId)) continue;
                layoutColumnIds = (String[])ArrayUtil.append((Object[])layoutColumnIds, (Object)columnId);
                updateColumnIds = true;
            }
            if (updateColumnIds) {
                properties.setProperty("nested-column-ids", StringUtil.merge((Object[])layoutColumnIds));
                layout.setTypeSettingsProperties(properties);
                try {
                    LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)e2, (Throwable)e2);
                }
            }
        }
    }
}

