/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import com.liferay.portlet.mobiledevicerules.service.base.MDRRuleServiceBaseImpl;
import com.liferay.portlet.mobiledevicerules.service.permission.MDRRuleGroupPermissionUtil;
import java.util.Locale;
import java.util.Map;

public class MDRRuleServiceImpl
extends MDRRuleServiceBaseImpl {
    public MDRRule addRule(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)ruleGroupId, (String)"UPDATE");
        return this.mdrRuleLocalService.addRule(ruleGroupId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public MDRRule addRule(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettings, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)ruleGroupId, (String)"UPDATE");
        return this.mdrRuleLocalService.addRule(ruleGroupId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public void deleteRule(long ruleId) throws PortalException, SystemException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)rule.getRuleGroupId(), (String)"UPDATE");
        this.mdrRuleLocalService.deleteRule(rule);
    }

    public MDRRule fetchRule(long ruleId) throws PortalException, SystemException {
        MDRRule rule = this.mdrRuleLocalService.fetchRule(ruleId);
        if (rule != null) {
            MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)rule.getRuleGroupId(), (String)"VIEW");
        }
        return rule;
    }

    public MDRRule getRule(long ruleId) throws PortalException, SystemException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)rule.getRuleGroupId(), (String)"VIEW");
        return rule;
    }

    public MDRRule updateRule(long ruleId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)rule.getRuleGroupId(), (String)"UPDATE");
        return this.mdrRuleLocalService.updateRule(ruleId, nameMap, descriptionMap, type, typeSettings, serviceContext);
    }

    public MDRRule updateRule(long ruleId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        MDRRuleGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)rule.getRuleGroupId(), (String)"UPDATE");
        return this.mdrRuleLocalService.updateRule(ruleId, nameMap, descriptionMap, type, typeSettingsProperties, serviceContext);
    }
}

