/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.service.base.MDRRuleLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MDRRuleLocalServiceImpl
extends MDRRuleLocalServiceBaseImpl {
    public MDRRule addRule(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(serviceContext.getUserId());
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        Date now = new Date();
        long ruleId = this.counterLocalService.increment();
        MDRRule rule = this.mdrRulePersistence.create(ruleId);
        rule.setUuid(serviceContext.getUuid());
        rule.setGroupId(ruleGroup.getGroupId());
        rule.setCompanyId(serviceContext.getCompanyId());
        rule.setCreateDate(serviceContext.getCreateDate(now));
        rule.setModifiedDate(serviceContext.getModifiedDate(now));
        rule.setUserId(user.getUserId());
        rule.setUserName(user.getFullName());
        rule.setRuleGroupId(ruleGroupId);
        rule.setNameMap(nameMap);
        rule.setDescriptionMap(descriptionMap);
        rule.setType(type);
        rule.setTypeSettings(typeSettings);
        rule = this.updateMDRRule(rule);
        ruleGroup.setModifiedDate(now);
        this.mdrRuleGroupPersistence.update((BaseModel)ruleGroup);
        return rule;
    }

    public MDRRule addRule(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addRule(ruleGroupId, nameMap, descriptionMap, type, typeSettingsProperties.toString(), serviceContext);
    }

    public MDRRule copyRule(long ruleId, long ruleGroupId, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        return this.copyRule(rule, ruleGroupId, serviceContext);
    }

    public MDRRule copyRule(MDRRule rule, long ruleGroupId, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        MDRRule newRule = this.addRule(ruleGroup.getRuleGroupId(), (Map<Locale, String>)rule.getNameMap(), (Map<Locale, String>)rule.getDescriptionMap(), rule.getType(), rule.getTypeSettings(), serviceContext);
        return newRule;
    }

    public void deleteRule(long ruleId) throws PortalException, SystemException {
        MDRRule rule = this.mdrRulePersistence.fetchByPrimaryKey(ruleId);
        if (rule != null) {
            this.deleteRule(rule);
        }
    }

    public void deleteRule(MDRRule rule) throws PortalException, SystemException {
        this.mdrRulePersistence.remove((BaseModel)rule);
        this.systemEventLocalService.addSystemEvent(rule.getGroupId(), MDRRule.class.getName(), rule.getRuleId(), rule.getUuid(), 1);
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.fetchByPrimaryKey(rule.getRuleGroupId());
        if (ruleGroup != null) {
            ruleGroup.setModifiedDate(new Date());
            this.mdrRuleGroupPersistence.update((BaseModel)ruleGroup);
        }
    }

    public void deleteRules(long ruleGroupId) throws PortalException, SystemException {
        List rules = this.mdrRulePersistence.findByRuleGroupId(ruleGroupId);
        for (MDRRule rule : rules) {
            this.deleteRule(rule);
        }
    }

    public MDRRule fetchRule(long ruleId) throws SystemException {
        return this.mdrRulePersistence.fetchByPrimaryKey(ruleId);
    }

    public MDRRule getRule(long ruleId) throws PortalException, SystemException {
        return this.mdrRulePersistence.findByPrimaryKey(ruleId);
    }

    public List<MDRRule> getRules(long ruleGroupId) throws SystemException {
        return this.mdrRulePersistence.findByRuleGroupId(ruleGroupId);
    }

    public List<MDRRule> getRules(long ruleGroupId, int start, int end) throws SystemException {
        return this.mdrRulePersistence.findByRuleGroupId(ruleGroupId, start, end);
    }

    public int getRulesCount(long ruleGroupId) throws SystemException {
        return this.mdrRulePersistence.countByRuleGroupId(ruleGroupId);
    }

    public MDRRule updateRule(long ruleId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRRule rule = this.mdrRulePersistence.findByPrimaryKey(ruleId);
        rule.setModifiedDate(serviceContext.getModifiedDate(null));
        rule.setNameMap(nameMap);
        rule.setDescriptionMap(descriptionMap);
        rule.setType(type);
        rule.setTypeSettings(typeSettings);
        this.mdrRulePersistence.update((BaseModel)rule);
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(rule.getRuleGroupId());
        ruleGroup.setModifiedDate(serviceContext.getModifiedDate(null));
        this.mdrRuleGroupPersistence.update((BaseModel)ruleGroup);
        return rule;
    }

    public MDRRule updateRule(long ruleId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateRule(ruleId, nameMap, descriptionMap, type, typeSettingsProperties.toString(), serviceContext);
    }
}

