/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.action;

import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.mobiledevicerules.NoSuchRuleGroupException;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupServiceUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRuleGroupAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            MDRRuleGroup ruleGroup = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                ruleGroup = this.updateRuleGroup(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRuleGroup(actionRequest);
            } else if (cmd.equals("copy")) {
                ruleGroup = this.copyRuleGroup(actionRequest);
            }
            if (cmd.equals("add") || cmd.equals("copy")) {
                String redirect = this.getRedirect(actionRequest, actionResponse, ruleGroup);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.mobile_device_rules.error");
            }
            if (e2 instanceof NoSuchRuleGroupException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        long ruleGroupId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"ruleGroupId");
        MDRRuleGroup ruleGroup = MDRRuleGroupServiceUtil.fetchRuleGroup((long)ruleGroupId);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP", (Object)ruleGroup);
        return mapping.findForward("portlet.mobile_device_rules.edit_rule_group");
    }

    protected MDRRuleGroup copyRuleGroup(ActionRequest actionRequest) throws Exception {
        long ruleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupId");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        return MDRRuleGroupServiceUtil.copyRuleGroup((long)ruleGroupId, (long)groupId, (ServiceContext)serviceContext);
    }

    protected void deleteRuleGroup(ActionRequest actionRequest) throws Exception {
        long ruleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupId");
        MDRRuleGroupServiceUtil.deleteRuleGroup((long)ruleGroupId);
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MDRRuleGroup ruleGroup) {
        LiferayPortletResponse liferayPortletResponse = (LiferayPortletResponse)actionResponse;
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/mobile_device_rules/edit_rule_group");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("ruleGroupId", String.valueOf(ruleGroup.getRuleGroupId()));
        return portletURL.toString();
    }

    protected MDRRuleGroup updateRuleGroup(ActionRequest actionRequest) throws Exception {
        long ruleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupId");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        MDRRuleGroup ruleGroup = null;
        ruleGroup = ruleGroupId <= 0L ? MDRRuleGroupServiceUtil.addRuleGroup((long)groupId, (Map)nameMap, (Map)descriptionMap, (ServiceContext)serviceContext) : MDRRuleGroupServiceUtil.updateRuleGroup((long)ruleGroupId, (Map)nameMap, (Map)descriptionMap, (ServiceContext)serviceContext);
        return ruleGroup;
    }
}

