/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.shard.ShardCallable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.util.ContentUtil;
import com.liferay.util.mail.JavaMailUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class MBUtil {
    public static final String BB_CODE_EDITOR_WYSIWYG_IMPL_KEY = "editor.wysiwyg.portal-web.docroot.html.portlet.message_boards.edit_message.bb_code.jsp";
    public static final String MESSAGE_POP_PORTLET_PREFIX = "mb_message.";
    private static Log _log = LogFactoryUtil.getLog(MBUtil.class);

    public static void addPortletBreadcrumbEntries(long categoryId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        MBUtil.addPortletBreadcrumbEntries(category, request, renderResponse);
    }

    public static void addPortletBreadcrumbEntries(MBCategory category, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/message_boards/select_category") || strutsAction.equals("/message_boards_admin/select_category")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            portletURL.setParameter("struts_action", "/message_boards/select_category");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("categories"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/message_boards/view");
        }
        List ancestorCategories = category.getAncestors();
        Collections.reverse(ancestorCategories);
        for (MBCategory curCategory : ancestorCategories) {
            portletURL.setParameter("mbCategoryId", String.valueOf(curCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)curCategory.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("mbCategoryId", String.valueOf(category.getCategoryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)category.getName(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(MBMessage message, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (message.getCategoryId() == -1L) {
            return;
        }
        if (message.getCategoryId() != 0L) {
            MBUtil.addPortletBreadcrumbEntries(message.getCategory(), request, renderResponse);
        }
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)message.getSubject(), (String)portletURL.toString());
    }

    public static void collectMultipartContent(MimeMultipart multipart, MBMailMessage collector) throws Exception {
        int i2 = 0;
        while (i2 < multipart.getCount()) {
            BodyPart part = multipart.getBodyPart(i2);
            MBUtil.collectPartContent((Part)part, collector);
            ++i2;
        }
    }

    public static void collectPartContent(Part part, MBMailMessage mbMailMessage) throws Exception {
        Object partContent = part.getContent();
        String contentType = part.getContentType().toLowerCase();
        if (part.getDisposition() != null && part.getDisposition().equalsIgnoreCase("attachment")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing attachment");
            }
            byte[] bytes = null;
            if (partContent instanceof String) {
                bytes = ((String)partContent).getBytes();
            } else if (partContent instanceof InputStream) {
                bytes = JavaMailUtil.getBytes((Part)part);
            }
            mbMailMessage.addBytes(part.getFileName(), bytes);
        } else if (partContent instanceof MimeMultipart) {
            MimeMultipart mimeMultipart = (MimeMultipart)partContent;
            MBUtil.collectMultipartContent(mimeMultipart, mbMailMessage);
        } else if (partContent instanceof String) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("emailPartToMBMessageBody", Boolean.TRUE);
            String messageBody = SanitizerUtil.sanitize((long)0L, (long)0L, (long)0L, (String)MBMessage.class.getName(), (long)0L, (String)contentType, (String)"ALL", (String)((String)partContent), options);
            if (contentType.startsWith("text/html")) {
                mbMailMessage.setHtmlBody(messageBody);
            } else {
                mbMailMessage.setPlainBody(messageBody);
            }
        }
    }

    public static String getAbsolutePath(PortletRequest portletRequest, long mbCategoryId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (mbCategoryId == 0L) {
            return themeDisplay.translate("home");
        }
        MBCategory mbCategory = MBCategoryLocalServiceUtil.fetchMBCategory((long)mbCategoryId);
        List categories = mbCategory.getAncestors();
        Collections.reverse(categories);
        StringBundler sb = new StringBundler(categories.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (MBCategory curCategory : categories) {
            sb.append("&raquo;");
            sb.append(" ");
            sb.append(curCategory.getName());
        }
        sb.append("&raquo;");
        sb.append(" ");
        sb.append(mbCategory.getName());
        return sb.toString();
    }

    public static long getCategoryId(HttpServletRequest request, MBCategory category) {
        long categoryId = 0L;
        if (category != null) {
            categoryId = category.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static long getCategoryId(HttpServletRequest request, MBMessage message) {
        long categoryId = 0L;
        if (message != null) {
            categoryId = message.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static Set<Long> getCategorySubscriptionClassPKs(long userId) throws SystemException {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)MBCategory.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public static String getEmailFromAddress(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.MESSAGE_BOARDS_EMAIL_FROM_ADDRESS);
    }

    public static String getEmailFromName(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.MESSAGE_BOARDS_EMAIL_FROM_NAME);
    }

    public static boolean getEmailHtmlFormat(PortletPreferences preferences) {
        String emailHtmlFormat = preferences.getValue("emailHtmlFormat", "");
        if (Validator.isNotNull((String)emailHtmlFormat)) {
            return GetterUtil.getBoolean((String)emailHtmlFormat);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_HTML_FORMAT;
    }

    public static String getEmailMessageAddedBody(PortletPreferences preferences) {
        String emailMessageAddedBody = preferences.getValue("emailMessageAddedBody", "");
        if (Validator.isNotNull((String)emailMessageAddedBody)) {
            return emailMessageAddedBody;
        }
        return ContentUtil.get((String)PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_BODY);
    }

    public static boolean getEmailMessageAddedEnabled(PortletPreferences preferences) {
        String emailMessageAddedEnabled = preferences.getValue("emailMessageAddedEnabled", "");
        if (Validator.isNotNull((String)emailMessageAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailMessageAddedEnabled);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_ENABLED;
    }

    public static String getEmailMessageAddedSignature(PortletPreferences preferences) {
        String emailMessageAddedSignature = preferences.getValue("emailMessageAddedSignature", "");
        if (Validator.isNotNull((String)emailMessageAddedSignature)) {
            return emailMessageAddedSignature;
        }
        return ContentUtil.get((String)PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_SIGNATURE);
    }

    public static String getEmailMessageAddedSubject(PortletPreferences preferences) {
        String emailMessageAddedSubject = preferences.getValue("emailMessageAddedSubject", "");
        if (Validator.isNotNull((String)emailMessageAddedSubject)) {
            return emailMessageAddedSubject;
        }
        return ContentUtil.get((String)PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_SUBJECT);
    }

    public static String getEmailMessageUpdatedBody(PortletPreferences preferences) {
        String emailMessageUpdatedBody = preferences.getValue("emailMessageUpdatedBody", "");
        if (Validator.isNotNull((String)emailMessageUpdatedBody)) {
            return emailMessageUpdatedBody;
        }
        return ContentUtil.get((String)PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_BODY);
    }

    public static boolean getEmailMessageUpdatedEnabled(PortletPreferences preferences) {
        String emailMessageUpdatedEnabled = preferences.getValue("emailMessageUpdatedEnabled", "");
        if (Validator.isNotNull((String)emailMessageUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailMessageUpdatedEnabled);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_ENABLED;
    }

    public static String getEmailMessageUpdatedSignature(PortletPreferences preferences) {
        String emailMessageUpdatedSignature = preferences.getValue("emailMessageUpdatedSignature", "");
        if (Validator.isNotNull((String)emailMessageUpdatedSignature)) {
            return emailMessageUpdatedSignature;
        }
        return ContentUtil.get((String)PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_SIGNATURE);
    }

    public static String getEmailMessageUpdatedSubject(PortletPreferences preferences) {
        String emailMessageUpdatedSubject = preferences.getValue("emailMessageUpdatedSubject", "");
        if (Validator.isNotNull((String)emailMessageUpdatedSubject)) {
            return emailMessageUpdatedSubject;
        }
        return ContentUtil.get((String)PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_SUBJECT);
    }

    public static List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        Document[] documentArray = hits.getDocs();
        int n = documentArray.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Document document = documentArray[n2];
                long categoryId = GetterUtil.getLong((String)document.get("categoryId"));
                try {
                    MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Message boards search index is stale and contains category " + categoryId));
                    }
                    break block12;
                }
                long threadId = GetterUtil.getLong((String)document.get("threadId"));
                try {
                    MBThreadLocalServiceUtil.getThread((long)threadId);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Message boards search index is stale and contains thread " + threadId));
                    }
                    break block12;
                }
                String entryClassName = document.get("entryClassName");
                long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                MBMessage obj = null;
                try {
                    if (entryClassName.equals(DLFileEntry.class.getName())) {
                        long classPK = GetterUtil.getLong((String)document.get("classPK"));
                        MBMessageLocalServiceUtil.getMessage((long)classPK);
                        obj = DLFileEntryLocalServiceUtil.getDLFileEntry((long)entryClassPK);
                    } else if (entryClassName.equals(MBMessage.class.getName())) {
                        obj = MBMessageLocalServiceUtil.getMessage((long)entryClassPK);
                    }
                    entries.add(obj);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block12;
                    _log.warn((Object)("Message boards search index is stale and contains entry {className=" + entryClassName + ", " + "classPK=" + entryClassPK + "}"));
                }
            }
            ++n2;
        }
        return entries;
    }

    public static String getMessageFormat(PortletPreferences preferences) {
        String messageFormat = preferences.getValue("messageFormat", MBMessageConstants.DEFAULT_FORMAT);
        String editorImpl = PropsUtil.get((String)BB_CODE_EDITOR_WYSIWYG_IMPL_KEY);
        if (messageFormat.equals("bbcode") && !editorImpl.equals("bbcode") && !editorImpl.equals("ckeditor_bbcode")) {
            messageFormat = "html";
        }
        return messageFormat;
    }

    public static long getMessageId(String mailId) {
        String temp;
        int z;
        int x = mailId.indexOf(60) + 1;
        int y = mailId.indexOf(64);
        long messageId = 0L;
        if (x > 0 && y != -1 && (z = (temp = mailId.substring(x, y)).lastIndexOf(46)) != -1) {
            messageId = GetterUtil.getLong((String)temp.substring(z + 1));
        }
        return messageId;
    }

    public static long getParentMessageId(Message message) throws Exception {
        long parentMessageId = -1L;
        String parentHeader = MBUtil.getParentMessageIdString(message);
        if (parentHeader != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent header " + parentHeader));
            }
            parentMessageId = MBUtil.getMessageId(parentHeader);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Previous message id " + parentMessageId));
            }
        }
        return parentMessageId;
    }

    public static String getParentMessageIdString(Message message) throws Exception {
        String[] inReplyToHeaders;
        String reference;
        int x;
        String parentHeader = null;
        String[] references = message.getHeader("References");
        if (references != null && references.length > 0 && (x = (reference = references[0]).lastIndexOf("<mb.")) > -1) {
            int y = reference.indexOf(">", x);
            parentHeader = reference.substring(x, y);
        }
        if (parentHeader == null && (inReplyToHeaders = message.getHeader("In-Reply-To")) != null && inReplyToHeaders.length > 0) {
            parentHeader = inReplyToHeaders[0];
        }
        if (Validator.isNull(parentHeader) || !parentHeader.startsWith(MESSAGE_POP_PORTLET_PREFIX, 1)) {
            parentHeader = MBUtil._getParentMessageIdFromSubject(message);
        }
        return parentHeader;
    }

    public static String getReplyToAddress(long categoryId, long messageId, String mx, String defaultMailingListAddress) {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() <= 0) {
            return defaultMailingListAddress;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(MESSAGE_POP_PORTLET_PREFIX);
        sb.append(categoryId);
        sb.append(".");
        sb.append(messageId);
        sb.append("@");
        sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
        sb.append(".");
        sb.append(mx);
        return sb.toString();
    }

    public static String getSubjectWithoutMessageId(Message message) throws Exception {
        int pos;
        String subject = message.getSubject();
        String parentMessageId = MBUtil._getParentMessageIdFromSubject(message);
        if (Validator.isNotNull((String)parentMessageId) && (pos = subject.indexOf(parentMessageId)) != -1) {
            subject = subject.substring(0, pos);
        }
        return subject;
    }

    public static String[] getThreadPriority(PortletPreferences preferences, String languageId, double value, ThemeDisplay themeDisplay) throws Exception {
        String[] priorities = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"priorities", (String)languageId);
        String[] priorityPair = MBUtil._findThreadPriority(value, themeDisplay, priorities);
        if (priorityPair == null) {
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
            priorities = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"priorities", (String)defaultLanguageId);
            priorityPair = MBUtil._findThreadPriority(value, themeDisplay, priorities);
        }
        return priorityPair;
    }

    public static Set<Long> getThreadSubscriptionClassPKs(long userId) throws SystemException {
        List subscriptions = SubscriptionLocalServiceUtil.getUserSubscriptions((long)userId, (String)MBThread.class.getName());
        HashSet<Long> classPKs = new HashSet<Long>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            classPKs.add(subscription.getClassPK());
        }
        return classPKs;
    }

    public static Date getUnbanDate(MBBan ban, int expireInterval) {
        Date banDate = ban.getCreateDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(banDate);
        cal.add(5, expireInterval);
        return cal.getTime();
    }

    public static String getUserRank(PortletPreferences preferences, String languageId, int posts) throws Exception {
        String rank = "";
        String[] ranks = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"ranks", (String)languageId);
        int i2 = 0;
        while (i2 < ranks.length) {
            String[] kvp = StringUtil.split((String)ranks[i2], (char)'=');
            String kvpName = kvp[0];
            int kvpPosts = GetterUtil.getInteger((String)kvp[1]);
            if (posts < kvpPosts) break;
            rank = kvpName;
            ++i2;
        }
        return rank;
    }

    public static String[] getUserRank(PortletPreferences preferences, String languageId, MBStatsUser statsUser) throws Exception {
        String[] rank = new String[]{"", ""};
        int maxPosts = 0;
        Group group = GroupLocalServiceUtil.getGroup((long)statsUser.getGroupId());
        long companyId = group.getCompanyId();
        String[] ranks = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"ranks", (String)languageId);
        int i2 = 0;
        while (i2 < ranks.length) {
            block7: {
                String[] kvp = StringUtil.split((String)ranks[i2], (char)'=');
                String curRank = kvp[0];
                String curRankValue = kvp[1];
                String[] curRankValueKvp = StringUtil.split((String)curRankValue, (char)':');
                if (curRankValueKvp.length <= 1) {
                    int posts = GetterUtil.getInteger((String)curRankValue);
                    if (posts <= statsUser.getMessageCount() && posts >= maxPosts) {
                        rank[0] = curRank;
                        maxPosts = posts;
                    }
                } else {
                    String entityType = curRankValueKvp[0];
                    String entityValue = curRankValueKvp[1];
                    try {
                        if (MBUtil._isEntityRank(companyId, statsUser, entityType, entityValue)) {
                            rank[1] = curRank;
                            break;
                        }
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Throwable)e2);
                    }
                }
            }
            ++i2;
        }
        return rank;
    }

    public static boolean hasMailIdHeader(Message message) throws Exception {
        String[] messageIds = message.getHeader("Message-ID");
        if (messageIds == null) {
            return false;
        }
        String[] stringArray = messageIds;
        int n = messageIds.length;
        int n2 = 0;
        while (n2 < n) {
            String messageId = stringArray[n2];
            if (Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN) && messageId.contains(PropsValues.POP_SERVER_SUBDOMAIN)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAllowAnonymousPosting(PortletPreferences preferences) {
        return GetterUtil.getBoolean((String)preferences.getValue("allowAnonymousPosting", null), (boolean)PropsValues.MESSAGE_BOARDS_ANONYMOUS_POSTING_ENABLED);
    }

    public static boolean isViewableMessage(ThemeDisplay themeDisplay, MBMessage message) throws Exception {
        return MBUtil.isViewableMessage(themeDisplay, message, message);
    }

    public static boolean isViewableMessage(ThemeDisplay themeDisplay, MBMessage message, MBMessage parentMessage) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!MBMessagePermission.contains(permissionChecker, parentMessage, "VIEW")) {
            return false;
        }
        if (message.getMessageId() != parentMessage.getMessageId() && !MBMessagePermission.contains(permissionChecker, message, "VIEW")) {
            return false;
        }
        return message.isApproved() || Validator.equals((long)message.getUserId(), (long)themeDisplay.getUserId()) || permissionChecker.isGroupAdmin(themeDisplay.getScopeGroupId());
    }

    public static String replaceMessageBodyPaths(ThemeDisplay themeDisplay, String messageBody) {
        return StringUtil.replace((String)messageBody, (String[])new String[]{"@theme_images_path@", "href=\"/", "src=\"/"}, (String[])new String[]{themeDisplay.getPathThemeImages(), "href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
    }

    public static void updateCategoryMessageCount(long companyId, final long categoryId) {
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                MBCategory category = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
                if (category == null) {
                    return null;
                }
                int messageCount = MBUtil._getMessageCount(category);
                category.setMessageCount(messageCount);
                MBCategoryLocalServiceUtil.updateMBCategory((MBCategory)category);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    public static void updateCategoryStatistics(long companyId, final long categoryId) {
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                MBCategory category = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
                if (category == null) {
                    return null;
                }
                int messageCount = MBUtil._getMessageCount(category);
                int threadCount = MBThreadLocalServiceUtil.getCategoryThreadsCount((long)category.getGroupId(), (long)category.getCategoryId(), (int)0);
                category.setMessageCount(messageCount);
                category.setThreadCount(threadCount);
                MBCategoryLocalServiceUtil.updateMBCategory((MBCategory)category);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    public static void updateCategoryThreadCount(long companyId, final long categoryId) {
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                MBCategory category = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
                if (category == null) {
                    return null;
                }
                int threadCount = MBThreadLocalServiceUtil.getCategoryThreadsCount((long)category.getGroupId(), (long)category.getCategoryId(), (int)0);
                category.setThreadCount(threadCount);
                MBCategoryLocalServiceUtil.updateMBCategory((MBCategory)category);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    public static void updateThreadMessageCount(long companyId, final long threadId) {
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                MBThread thread = MBThreadLocalServiceUtil.fetchThread((long)threadId);
                if (thread == null) {
                    return null;
                }
                int messageCount = MBMessageLocalServiceUtil.getThreadMessagesCount((long)threadId, (int)0);
                thread.setMessageCount(messageCount);
                MBThreadLocalServiceUtil.updateMBThread((MBThread)thread);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    private static String[] _findThreadPriority(double value, ThemeDisplay themeDisplay, String[] priorities) {
        int i2 = 0;
        while (i2 < priorities.length) {
            String[] priority = StringUtil.split((String)priorities[i2]);
            try {
                String priorityName = priority[0];
                String priorityImage = priority[1];
                double priorityValue = GetterUtil.getDouble((String)priority[2]);
                if (value == priorityValue) {
                    if (!priorityImage.startsWith("http")) {
                        priorityImage = String.valueOf(themeDisplay.getPathThemeImages()) + priorityImage;
                    }
                    return new String[]{priorityName, priorityImage};
                }
            }
            catch (Exception e2) {
                _log.error((Object)"Unable to determine thread priority", (Throwable)e2);
            }
            ++i2;
        }
        return null;
    }

    private static int _getMessageCount(MBCategory category) throws SystemException {
        int messageCount = MBMessageLocalServiceUtil.getCategoryMessagesCount((long)category.getGroupId(), (long)category.getCategoryId(), (int)0);
        QueryDefinition queryDefinition = new QueryDefinition(8);
        List threads = MBThreadLocalServiceUtil.getGroupThreads((long)category.getGroupId(), (QueryDefinition)queryDefinition);
        for (MBThread thread : threads) {
            messageCount -= thread.getMessageCount();
        }
        return messageCount;
    }

    private static String _getParentMessageIdFromSubject(Message message) throws Exception {
        if (message.getSubject() == null) {
            return null;
        }
        String parentMessageId = null;
        String subject = StringUtil.reverse((String)message.getSubject());
        int pos = subject.indexOf(60);
        if (pos != -1) {
            parentMessageId = StringUtil.reverse((String)subject.substring(0, pos + 1));
        }
        return parentMessageId;
    }

    private static boolean _isEntityRank(long companyId, MBStatsUser statsUser, String entityType, String entityValue) throws Exception {
        UserGroup userGroup;
        Organization organization;
        Role role;
        long groupId = statsUser.getGroupId();
        long userId = statsUser.getUserId();
        return entityType.equals("organization-role") || entityType.equals("site-role") ? UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)groupId, (long)(role = RoleLocalServiceUtil.getRole((long)companyId, (String)entityValue)).getRoleId(), (boolean)true) : (entityType.equals("organization") ? OrganizationLocalServiceUtil.hasUserOrganization((long)userId, (long)(organization = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)entityValue)).getOrganizationId(), (boolean)false, (boolean)false) : (entityType.equals("regular-role") ? RoleLocalServiceUtil.hasUserRole((long)userId, (long)companyId, (String)entityValue, (boolean)true) : entityType.equals("user-group") && UserLocalServiceUtil.hasUserGroupUser((long)(userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)entityValue)).getUserGroupId(), (long)userId)));
    }
}

