/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.trash.MBThreadTrashRenderer;
import com.liferay.portlet.messageboards.util.MBUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;

public class MBThreadTrashHandler
extends BaseTrashHandler {
    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        MBThreadLocalServiceUtil.deleteThread((long)classPK);
    }

    public String getClassName() {
        return MBThread.class.getName();
    }

    public String getContainerModelClassName() {
        return MBCategory.class.getName();
    }

    public String getContainerModelName() {
        return "category";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException, SystemException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        List categories = MBCategoryLocalServiceUtil.getCategories((long)thread.getGroupId(), (long)parentContainerModelId, (int)0, (int)start, (int)end);
        for (MBCategory category : categories) {
            containerModels.add((ContainerModel)category);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException, SystemException {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        return MBCategoryLocalServiceUtil.getCategoriesCount((long)thread.getGroupId(), (long)parentContainerModelId, (int)0);
    }

    public String getRestoreLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        String portletId = "19";
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        long plid = PortalUtil.getPlidFromPortletId((long)thread.getGroupId(), (String)"19");
        if (plid == 0L) {
            portletId = "162";
            plid = PortalUtil.getControlPanelPlid((PortletRequest)portletRequest);
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        if (portletId.equals("19")) {
            portletURL.setParameter("struts_action", "/message_boards/view");
        } else {
            portletURL.setParameter("struts_action", "/message_boards_admin/view");
        }
        portletURL.setParameter("mbCategoryId", String.valueOf(thread.getCategoryId()));
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        return MBUtil.getAbsolutePath(portletRequest, thread.getCategoryId());
    }

    public ContainerModel getTrashContainer(long classPK) throws PortalException, SystemException {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        return thread.getTrashContainer();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        return new MBThreadTrashRenderer(thread);
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        return thread.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        return thread.isInTrashContainer();
    }

    public boolean isMovable() {
        return true;
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBThreadLocalServiceUtil.moveThread((long)userId, (long)containerModelId, (long)classPK);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBThreadLocalServiceUtil.moveThreadFromTrash((long)userId, (long)containerModelId, (long)classPK);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        MBThreadLocalServiceUtil.restoreThreadFromTrash((long)userId, (long)classPK);
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        MBThread thread = MBThreadLocalServiceUtil.getThread((long)classPK);
        return MBMessagePermission.contains(permissionChecker, thread.getRootMessageId(), actionId);
    }
}

