/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBThreadModelImpl;
import com.liferay.portlet.messageboards.service.base.MBThreadServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class MBThreadServiceImpl
extends MBThreadServiceBaseImpl {
    public void deleteThread(long threadId) throws PortalException, SystemException {
        if (this.lockLocalService.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException();
        }
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            MBMessagePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        this.mbThreadLocalService.deleteThread(threadId);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, Date modifiedDate, int status, int start, int end) throws PortalException, SystemException {
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
            return this.mbThreadFinder.findByG_U_LPD(groupId, userId, categoryIds, modifiedDate, queryDefinition);
        }
        List threadIds = this.mbMessageFinder.filterFindByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, start, end);
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator iterator = threadIds.iterator();
        while (iterator.hasNext()) {
            long threadId = (Long)iterator.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) throws PortalException, SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.doGetGroupThreads(groupId, userId, status, subscribed, includeAnonymous, start, end);
        }
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        List threadIds = null;
        if (userId <= 0L) {
            threadIds = this.mbMessageFinder.filterFindByG_U_C_S(groupId, 0L, categoryIds, status, start, end);
        } else {
            if (subscribed) {
                QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
                return this.mbThreadFinder.filterFindByS_G_U_C(groupId, userId, categoryIds, queryDefinition);
            }
            threadIds = includeAnonymous ? this.mbMessageFinder.filterFindByG_U_C_S(groupId, userId, categoryIds, status, start, end) : this.mbMessageFinder.filterFindByG_U_C_A_S(groupId, userId, categoryIds, false, status, start, end);
        }
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator iterator = threadIds.iterator();
        while (iterator.hasNext()) {
            long threadId = (Long)iterator.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, status, subscribed, true, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, status, false, start, end);
    }

    public int getGroupThreadsCount(long groupId, long userId, Date modifiedDate, int status) throws SystemException {
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            QueryDefinition queryDefinition = new QueryDefinition(status);
            return this.mbThreadFinder.countByG_U_LPD(groupId, userId, categoryIds, modifiedDate, queryDefinition);
        }
        return this.mbMessageFinder.filterCountByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, status, false);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, status, subscribed, true);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) throws SystemException {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return this.doGetGroupThreadsCount(groupId, userId, status, subscribed, includeAnonymous);
        }
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        if (userId <= 0L) {
            return this.mbMessageFinder.filterCountByG_U_C_S(groupId, 0L, categoryIds, status);
        }
        if (subscribed) {
            QueryDefinition queryDefinition = new QueryDefinition(status);
            return this.mbThreadFinder.filterCountByS_G_U_C(groupId, userId, categoryIds, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbMessageFinder.filterCountByG_U_C_S(groupId, userId, categoryIds, status);
        }
        return this.mbMessageFinder.filterCountByG_U_C_A_S(groupId, userId, categoryIds, false, status);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbThreadFinder.filterFindByG_C(groupId, categoryId, start, end);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.mbThreadFinder.filterFindByG_C(groupId, new long[]{categoryId}, queryDefinition);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbThreadFinder.filterCountByG_C(groupId, new long[]{categoryId}, queryDefinition);
    }

    public Lock lockThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "LOCK_THREAD");
        return this.lockLocalService.lock(this.getUserId(), MBThread.class.getName(), threadId, String.valueOf(threadId), false, MBThreadModelImpl.LOCK_EXPIRATION_TIME);
    }

    public MBThread moveThread(long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "MOVE_THREAD");
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), categoryId, "MOVE_THREAD");
        return this.mbThreadLocalService.moveThread(thread.getGroupId(), categoryId, threadId);
    }

    public MBThread moveThreadFromTrash(long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "UPDATE");
        return this.mbThreadLocalService.moveThreadFromTrash(this.getUserId(), categoryId, threadId);
    }

    public MBThread moveThreadToTrash(long threadId) throws PortalException, SystemException {
        if (this.lockLocalService.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException();
        }
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            MBMessagePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        return this.mbThreadLocalService.moveThreadToTrash(this.getUserId(), threadId);
    }

    public void restoreThreadFromTrash(long threadId) throws PortalException, SystemException {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            MBMessagePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        this.mbThreadLocalService.restoreThreadFromTrash(this.getUserId(), threadId);
    }

    public MBThread splitThread(long messageId, String subject, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessageLocalService.getMessage(messageId);
        MBCategoryPermission.check(this.getPermissionChecker(), message.getGroupId(), message.getCategoryId(), "MOVE_THREAD");
        return this.mbThreadLocalService.splitThread(messageId, subject, serviceContext);
    }

    public void unlockThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "LOCK_THREAD");
        this.lockLocalService.unlock(MBThread.class.getName(), threadId);
    }

    protected List<MBThread> doGetGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) throws SystemException {
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        if (userId <= 0L) {
            return this.mbThreadFinder.findByG_C(groupId, categoryIds, queryDefinition);
        }
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U_C(groupId, userId, categoryIds, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.findByG_U_C(groupId, userId, categoryIds, queryDefinition);
        }
        return this.mbThreadFinder.findByG_U_C_A(groupId, userId, categoryIds, false, queryDefinition);
    }

    protected int doGetGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) throws SystemException {
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (userId <= 0L) {
            return this.mbThreadFinder.countByG_C(groupId, categoryIds, queryDefinition);
        }
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U_C(groupId, userId, categoryIds, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.countByG_U_C(groupId, userId, categoryIds, queryDefinition);
        }
        return this.mbThreadFinder.countByG_U_C_A(groupId, userId, categoryIds, false, queryDefinition);
    }
}

