/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.blogs.util.LinkbackProducerUtil;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchDiscussionException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageDisplayImpl;
import com.liferay.portlet.messageboards.service.base.MBMessageLocalServiceBaseImpl;
import com.liferay.portlet.messageboards.util.MBSubscriptionSender;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.messageboards.util.MailingListThreadLocal;
import com.liferay.portlet.messageboards.util.comparator.MessageCreateDateComparator;
import com.liferay.portlet.messageboards.util.comparator.MessageThreadComparator;
import com.liferay.portlet.messageboards.util.comparator.ThreadLastPostDateComparator;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.util.SerializableUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public class MBMessageLocalServiceImpl
extends MBMessageLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBMessageLocalServiceImpl.class);

    public MBMessage addDiscussionMessage(long userId, String userName, long groupId, String className, long classPK, int workflowAction) throws PortalException, SystemException {
        String subject;
        long threadId = 0L;
        long parentMessageId = 0L;
        String body = subject = String.valueOf(classPK);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setWorkflowAction(workflowAction);
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            MBMessage mBMessage = this.addDiscussionMessage(userId, userName, groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
            return mBMessage;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public MBMessage addDiscussionMessage(long userId, String userName, long groupId, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        long classNameId;
        MBDiscussion discussion;
        long categoryId = -1L;
        if (Validator.isNull((String)subject)) {
            if (Validator.isNotNull((String)body)) {
                int pos = Math.min(body.length(), 50);
                subject = String.valueOf(body.substring(0, pos)) + "...";
            } else {
                throw new MessageBodyException();
            }
        }
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        boolean anonymous = false;
        double priority = 0.0;
        boolean allowPingbacks = false;
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        MBMessage message = this.addMessage(userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
        if (parentMessageId == 0L && (discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId = PortalUtil.getClassNameId((String)className), classPK)) == null) {
            this.mbDiscussionLocalService.addDiscussion(userId, classNameId, classPK, message.getThreadId(), serviceContext);
        }
        return message;
    }

    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, long threadId, long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage parentMessage;
        User user = this.userPersistence.findByPrimaryKey(userId);
        userName = user.isDefaultUser() ? userName : user.getFullName();
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences != null && !MBUtil.isAllowAnonymousPosting(preferences) && (anonymous || user.isDefaultUser())) {
            throw new PrincipalException();
        }
        if (user.isDefaultUser()) {
            anonymous = true;
        }
        Date now = new Date();
        long messageId = this.counterLocalService.increment();
        body = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)userId, (String)MBMessage.class.getName(), (long)messageId, (String)("text/" + format), (String)body);
        this.validate(subject, body);
        subject = this.getSubject(subject, body);
        body = this.getBody(subject, body);
        MBMessage message = this.mbMessagePersistence.create(messageId);
        message.setUuid(serviceContext.getUuid());
        message.setGroupId(groupId);
        message.setCompanyId(user.getCompanyId());
        message.setUserId(user.getUserId());
        message.setUserName(userName);
        message.setCreateDate(serviceContext.getCreateDate(now));
        message.setModifiedDate(serviceContext.getModifiedDate(now));
        if (threadId > 0L) {
            message.setThreadId(threadId);
        }
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        message.setAllowPingbacks(allowPingbacks);
        message.setStatus(2);
        message.setStatusByUserId(user.getUserId());
        message.setStatusByUserName(userName);
        message.setStatusDate(serviceContext.getModifiedDate(now));
        if (parentMessageId != 0L && (parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(parentMessageId)) == null) {
            parentMessageId = 0L;
        }
        MBThread thread = null;
        if (threadId > 0L) {
            thread = this.mbThreadPersistence.fetchByPrimaryKey(threadId);
        }
        if (thread == null || parentMessageId == 0L) {
            thread = this.mbThreadLocalService.addThread(categoryId, message, serviceContext);
        }
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this.mbThreadPersistence.update((BaseModel)thread);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        message.setCategoryId(categoryId);
        message.setThreadId(thread.getThreadId());
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(parentMessageId);
        message.setSubject(subject);
        message.setBody(body);
        message.setFormat(format);
        message.setAnonymous(anonymous);
        if (message.isDiscussion()) {
            long classNameId = PortalUtil.getClassNameId((String)((String)((Object)serviceContext.getAttribute("className"))));
            long classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK");
            message.setClassNameId(classNameId);
            message.setClassPK(classPK);
        }
        message.setExpandoBridgeAttributes(serviceContext);
        this.mbMessagePersistence.update((BaseModel)message);
        if (!inputStreamOVPs.isEmpty()) {
            Folder folder = message.addAttachmentsFolder();
            PortletFileRepositoryUtil.addPortletFileEntries((long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)message.getMessageId(), (String)"19", (long)folder.getFolderId(), inputStreamOVPs);
        }
        if (!message.isDiscussion()) {
            if (user.isDefaultUser()) {
                this.addMessageResources(message, true, true);
            } else if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
                this.addMessageResources(message, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
            } else {
                this.addMessageResources(message, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
            }
        }
        this.updateAsset(userId, message, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.isAssetEntryVisible());
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)message.getWorkflowClassName(), (long)message.getMessageId(), (Object)message, (ServiceContext)serviceContext);
        return message;
    }

    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        long threadId = 0L;
        long parentMessageId = 0L;
        return this.addMessage(userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(long userId, String userName, long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        return this.addMessage(userId, userName, category.getGroupId(), categoryId, 0L, 0L, subject, body, MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, false, 0.0, false, serviceContext);
    }

    public void addMessageResources(long messageId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, addGroupPermissions, addGuestPermissions);
    }

    public void addMessageResources(long messageId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, groupPermissions, guestPermissions);
    }

    public void addMessageResources(MBMessage message, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addMessageResources(MBMessage message, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), groupPermissions, guestPermissions);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteDiscussionMessage(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.deleteMessage(message);
    }

    public void deleteDiscussionMessages(String className, long classPK) throws PortalException, SystemException {
        block3: {
            try {
                long classNameId = PortalUtil.getClassNameId((String)className);
                MBDiscussion discussion = this.mbDiscussionPersistence.findByC_C(classNameId, classPK);
                List messages = this.mbMessagePersistence.findByT_P(discussion.getThreadId(), 0L, 0, 1);
                if (!messages.isEmpty()) {
                    MBMessage message = (MBMessage)messages.get(0);
                    this.mbThreadLocalService.deleteThread(message.getThreadId());
                }
                this.mbDiscussionPersistence.remove((BaseModel)discussion);
            }
            catch (NoSuchDiscussionException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteMessage(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.deleteMessage(message);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteMessage(MBMessage message) throws PortalException, SystemException {
        int count;
        long folderId = message.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deleteFolder((long)folderId);
        }
        if ((count = this.mbMessagePersistence.countByThreadId(message.getThreadId())) == 1) {
            long threadAttachmentsFolderId = message.getThreadAttachmentsFolderId();
            if (threadAttachmentsFolderId != 0L) {
                PortletFileRepositoryUtil.deleteFolder((long)threadAttachmentsFolderId);
            }
            this.subscriptionLocalService.deleteSubscriptions(message.getCompanyId(), MBThread.class.getName(), message.getThreadId());
            this.mbThreadPersistence.remove(message.getThreadId());
            if (message.getCategoryId() != 0L && message.getCategoryId() != -1L) {
                MBUtil.updateCategoryStatistics(message.getCompanyId(), message.getCategoryId());
            }
        } else {
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
            if (thread.getRootMessageId() == message.getMessageId()) {
                List childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (childrenMessages.size() > 1) {
                    throw new RequiredMessageException(String.valueOf(message.getMessageId()));
                }
                if (childrenMessages.size() == 1) {
                    MBMessage childMessage = (MBMessage)childrenMessages.get(0);
                    childMessage.setRootMessageId(childMessage.getMessageId());
                    childMessage.setParentMessageId(0L);
                    this.mbMessagePersistence.update((BaseModel)childMessage);
                    List repliesMessages = this.mbMessagePersistence.findByThreadReplies(message.getThreadId());
                    for (MBMessage repliesMessage : repliesMessages) {
                        repliesMessage.setRootMessageId(childMessage.getMessageId());
                        this.mbMessagePersistence.update((BaseModel)repliesMessage);
                    }
                    thread.setRootMessageId(childMessage.getMessageId());
                    thread.setRootMessageUserId(childMessage.getUserId());
                    this.mbThreadPersistence.update((BaseModel)thread);
                }
            } else {
                List childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (!childrenMessages.isEmpty()) {
                    for (MBMessage childMessage : childrenMessages) {
                        childMessage.setParentMessageId(message.getParentMessageId());
                        this.mbMessagePersistence.update((BaseModel)childMessage);
                    }
                } else {
                    MessageCreateDateComparator comparator = new MessageCreateDateComparator(true);
                    MBMessage lastMessage = this.mbMessagePersistence.fetchByT_S_Last(thread.getThreadId(), 0, (OrderByComparator)comparator);
                    if (lastMessage != null && message.getMessageId() == lastMessage.getMessageId()) {
                        MBMessage parentMessage = this.mbMessagePersistence.findByPrimaryKey(message.getParentMessageId());
                        thread.setLastPostByUserId(parentMessage.getUserId());
                        thread.setLastPostDate(parentMessage.getModifiedDate());
                    }
                }
            }
            if (message.isApproved()) {
                MBUtil.updateThreadMessageCount(thread.getCompanyId(), thread.getThreadId());
            } else {
                this.mbThreadPersistence.update((BaseModel)thread);
            }
            if (message.getCategoryId() != 0L && message.getCategoryId() != -1L && !message.isDraft()) {
                MBUtil.updateCategoryMessageCount(message.getCompanyId(), message.getCategoryId());
            }
        }
        this.assetEntryLocalService.deleteEntry(message.getWorkflowClassName(), message.getMessageId());
        this.expandoValueLocalService.deleteValues(message.getWorkflowClassName(), message.getMessageId());
        this.ratingsStatsLocalService.deleteStats(message.getWorkflowClassName(), message.getMessageId());
        if (!message.isDiscussion()) {
            this.resourceLocalService.deleteResource(message.getCompanyId(), message.getWorkflowClassName(), 4, message.getMessageId());
        }
        this.mbMessagePersistence.remove((BaseModel)message);
        if (!message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
        }
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
        return message;
    }

    public void deleteMessageAttachment(long messageId, String fileName) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        PortletFileRepositoryUtil.deletePortletFileEntry((long)message.getGroupId(), (long)folderId, (String)fileName);
    }

    public void deleteMessageAttachments(long messageId) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        PortletFileRepositoryUtil.deletePortletFileEntries((long)message.getGroupId(), (long)folderId);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbMessagePersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_C(groupId, categoryId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_C_S(groupId, categoryId, status, start, end, obc);
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByG_C(groupId, categoryId);
        }
        return this.mbMessagePersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByCompanyId(companyId, start, end);
        }
        return this.mbMessagePersistence.findByC_S(companyId, status, start, end);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByCompanyId(companyId, start, end, obc);
        }
        return this.mbMessagePersistence.findByC_S(companyId, status, start, end, obc);
    }

    public int getCompanyMessagesCount(long companyId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByCompanyId(companyId);
        }
        return this.mbMessagePersistence.countByC_S(companyId, status);
    }

    public MBMessageDisplay getDiscussionMessageDisplay(long userId, long groupId, String className, long classPK, int status) throws PortalException, SystemException {
        return this.getDiscussionMessageDisplay(userId, groupId, className, classPK, status, "combination");
    }

    public MBMessageDisplay getDiscussionMessageDisplay(long userId, long groupId, String className, long classPK, int status, String threadView) throws PortalException, SystemException {
        MBMessage message;
        block9: {
            long classNameId = PortalUtil.getClassNameId((String)className);
            message = null;
            MBDiscussion discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
            if (discussion != null) {
                List messages = this.mbMessagePersistence.findByT_P(discussion.getThreadId(), 0L);
                message = (MBMessage)messages.get(0);
            } else {
                boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
                WorkflowThreadLocal.setEnabled((boolean)false);
                try {
                    try {
                        String subject = String.valueOf(classPK);
                        message = this.addDiscussionMessage(userId, null, groupId, className, classPK, 0L, 0L, subject, subject, new ServiceContext());
                    }
                    catch (SystemException se) {
                        List messages;
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)"Add failed, fetch {threadId=0, parentMessageId=0}");
                        }
                        if ((messages = this.mbMessagePersistence.findByT_P(0L, 0L)).isEmpty()) {
                            throw se;
                        }
                        message = (MBMessage)messages.get(0);
                        WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
                    throw throwable;
                }
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        }
        return this.getMessageDisplay(userId, message, status, threadView, false);
    }

    public int getDiscussionMessagesCount(long classNameId, long classPK, int status) throws SystemException {
        MBDiscussion discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
        if (discussion == null) {
            return 0;
        }
        int count = 0;
        count = status == -1 ? this.mbMessagePersistence.countByThreadId(discussion.getThreadId()) : this.mbMessagePersistence.countByT_S(discussion.getThreadId(), status);
        if (count >= 1) {
            return count - 1;
        }
        return 0;
    }

    public int getDiscussionMessagesCount(String className, long classPK, int status) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getDiscussionMessagesCount(classNameId, classPK, status);
    }

    public List<MBDiscussion> getDiscussions(String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mbDiscussionPersistence.findByClassNameId(classNameId);
    }

    public List<MBMessage> getGroupMessages(long groupId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByGroupId(groupId, start, end);
        }
        return this.mbMessagePersistence.findByG_S(groupId, status, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByGroupId(groupId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_S(groupId, status, start, end, obc);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_U(groupId, userId, start, end);
        }
        return this.mbMessagePersistence.findByG_U_S(groupId, userId, status, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_U(groupId, userId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_U_S(groupId, userId, status, start, end, obc);
    }

    public int getGroupMessagesCount(long groupId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByGroupId(groupId);
        }
        return this.mbMessagePersistence.countByG_S(groupId, status);
    }

    public int getGroupMessagesCount(long groupId, long userId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByG_U(groupId, userId);
        }
        return this.mbMessagePersistence.countByG_U_S(groupId, userId, status);
    }

    public MBMessage getMessage(long messageId) throws PortalException, SystemException {
        return this.mbMessagePersistence.findByPrimaryKey(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long userId, long messageId, int status, String threadView, boolean includePrevAndNext) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        return this.getMessageDisplay(userId, message, status, threadView, includePrevAndNext);
    }

    public MBMessageDisplay getMessageDisplay(long userId, MBMessage message, int status, String threadView, boolean includePrevAndNext) throws PortalException, SystemException {
        MBCategoryImpl category = null;
        if (message.getCategoryId() != 0L && message.getCategoryId() != -1L) {
            category = this.mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
        } else {
            category = new MBCategoryImpl();
            category.setCategoryId(message.getCategoryId());
            category.setDisplayStyle(MBCategoryConstants.DEFAULT_DISPLAY_STYLE);
        }
        MBMessage parentMessage = null;
        if (message.isReply()) {
            parentMessage = this.mbMessagePersistence.findByPrimaryKey(message.getParentMessageId());
        }
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (message.isApproved() && !message.isDiscussion()) {
            this.mbThreadLocalService.incrementViewCounter(thread.getThreadId(), 1);
            if (thread.getRootMessageUserId() != userId) {
                MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
                this.socialActivityLocalService.addActivity(userId, rootMessage.getGroupId(), MBMessage.class.getName(), rootMessage.getMessageId(), 10001, "", 0L);
            }
        }
        MBThread previousThread = null;
        MBThread nextThread = null;
        if (message.isApproved() && includePrevAndNext) {
            ThreadLastPostDateComparator comparator = new ThreadLastPostDateComparator(false);
            MBThread[] prevAndNextThreads = this.mbThreadPersistence.findByG_C_PrevAndNext(message.getThreadId(), message.getGroupId(), message.getCategoryId(), (OrderByComparator)comparator);
            previousThread = prevAndNextThreads[0];
            nextThread = prevAndNextThreads[2];
        }
        return new MBMessageDisplayImpl(message, parentMessage, category, thread, previousThread, nextThread, status, threadView, this);
    }

    public List<MBMessage> getMessages(String className, long classPK, int status) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        if (status == -1) {
            return this.mbMessagePersistence.findByC_C(classNameId, classPK);
        }
        return this.mbMessagePersistence.findByC_C_S(classNameId, classPK, status);
    }

    public List<MBMessage> getNoAssetMessages() throws SystemException {
        return this.mbMessageFinder.findByNoAssets();
    }

    public int getPositionInThread(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageFinder.countByC_T(message.getCreateDate(), message.getThreadId());
    }

    public List<MBMessage> getThreadMessages(long threadId, int status) throws SystemException {
        return this.getThreadMessages(threadId, status, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    public List<MBMessage> getThreadMessages(long threadId, int status, Comparator<MBMessage> comparator) throws SystemException {
        List messages = null;
        messages = status == -1 ? this.mbMessagePersistence.findByThreadId(threadId) : this.mbMessagePersistence.findByT_S(threadId, status);
        return ListUtil.sort((List)messages, comparator);
    }

    public List<MBMessage> getThreadMessages(long threadId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByThreadId(threadId, start, end);
        }
        return this.mbMessagePersistence.findByT_S(threadId, status, start, end);
    }

    public int getThreadMessagesCount(long threadId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByThreadId(threadId);
        }
        return this.mbMessagePersistence.countByT_S(threadId, status);
    }

    public List<MBMessage> getThreadRepliesMessages(long threadId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByThreadReplies(threadId, start, end);
        }
        return this.mbMessagePersistence.findByTR_S(threadId, status, start, end);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, long classNameId, long classPK, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByU_C_C(userId, classNameId, classPK, start, end, obc);
        }
        return this.mbMessagePersistence.findByU_C_C_S(userId, classNameId, classPK, status, start, end, obc);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, long[] classNameIds, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByU_C(userId, classNameIds, start, end, obc);
        }
        return this.mbMessagePersistence.findByU_C_S(userId, classNameIds, status, start, end, obc);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, String className, long classPK, int status, int start, int end, OrderByComparator obc) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getUserDiscussionMessages(userId, classNameId, classPK, status, start, end, obc);
    }

    public int getUserDiscussionMessagesCount(long userId, long classNameId, long classPK, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByU_C_C(userId, classNameId, classPK);
        }
        return this.mbMessagePersistence.countByU_C_C_S(userId, classNameId, classPK, status);
    }

    public int getUserDiscussionMessagesCount(long userId, long[] classNameIds, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByU_C(userId, classNameIds);
        }
        return this.mbMessagePersistence.countByU_C_S(userId, classNameIds, status);
    }

    public int getUserDiscussionMessagesCount(long userId, String className, long classPK, int status) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getUserDiscussionMessagesCount(userId, classNameId, classPK, status);
    }

    public long moveMessageAttachmentToTrash(long userId, long messageId, String fileName) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)message.getGroupId(), (long)folderId, (String)fileName);
        PortletFileRepositoryUtil.movePortletFileEntryToTrash((long)userId, (long)fileEntry.getFileEntryId());
        return fileEntry.getFileEntryId();
    }

    public void restoreMessageAttachmentFromTrash(long userId, long messageId, String deletedFileName) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        Folder folder = message.addAttachmentsFolder();
        PortletFileRepositoryUtil.restorePortletFileEntryFromTrash((long)message.getGroupId(), (long)userId, (long)folder.getFolderId(), (String)deletedFileName);
    }

    public void subscribeMessage(long userId, long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.subscriptionLocalService.addSubscription(userId, message.getGroupId(), MBThread.class.getName(), message.getThreadId());
    }

    public void unsubscribeMessage(long userId, long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.subscriptionLocalService.deleteSubscription(userId, MBThread.class.getName(), message.getThreadId());
    }

    public void updateAnswer(long messageId, boolean answer, boolean cascade) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.updateAnswer(message, answer, cascade);
    }

    public void updateAnswer(MBMessage message, boolean answer, boolean cascade) throws PortalException, SystemException {
        if (message.isAnswer() != answer) {
            message.setAnswer(answer);
            this.mbMessagePersistence.update((BaseModel)message);
        }
        if (cascade) {
            List messages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
            for (MBMessage curMessage : messages) {
                this.updateAnswer(curMessage, answer, cascade);
            }
        }
    }

    public void updateAsset(long userId, MBMessage message, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        this.updateAsset(userId, message, assetCategoryIds, assetTagNames, assetLinkEntryIds, true);
    }

    public MBMessage updateDiscussionMessage(long userId, long messageId, String className, long classPK, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        if (Validator.isNull((String)subject)) {
            if (Validator.isNotNull((String)body)) {
                int pos = Math.min(body.length(), 50);
                subject = String.valueOf(body.substring(0, pos)) + "...";
            } else {
                throw new MessageBodyException();
            }
        }
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        ArrayList<String> existingFiles = new ArrayList<String>();
        double priority = 0.0;
        boolean allowPingbacks = false;
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        return this.updateMessage(userId, messageId, subject, body, inputStreamOVPs, existingFiles, priority, allowPingbacks, serviceContext);
    }

    public MBMessage updateMessage(long userId, long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, List<String> existingFiles, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        List fileEntries;
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        int oldStatus = message.getStatus();
        Date modifiedDate = serviceContext.getModifiedDate(new Date());
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        body = SanitizerUtil.sanitize((long)message.getCompanyId(), (long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)messageId, (String)("text/" + message.getFormat()), (String)body);
        this.validate(subject, body);
        subject = this.getSubject(subject, body);
        body = this.getBody(subject, body);
        message.setModifiedDate(modifiedDate);
        message.setSubject(subject);
        message.setBody(body);
        message.setAllowPingbacks(allowPingbacks);
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (serviceContext.getWorkflowAction() == 2 && !message.isDraft() && !message.isPending()) {
            message.setStatus(2);
            User user = this.userPersistence.findByPrimaryKey(userId);
            this.updateThreadStatus(thread, message, user, oldStatus, modifiedDate);
            this.assetEntryLocalService.updateVisible(message.getWorkflowClassName(), message.getMessageId(), false);
            if (!message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.delete((Object)message);
            }
        }
        if (!inputStreamOVPs.isEmpty() || !existingFiles.isEmpty()) {
            fileEntries = message.getAttachmentsFileEntries();
            for (FileEntry fileEntry : fileEntries) {
                String fileEntryId = String.valueOf(fileEntry.getFileEntryId());
                if (existingFiles.contains(fileEntryId)) continue;
                if (!TrashUtil.isTrashEnabled((long)message.getGroupId())) {
                    this.deleteMessageAttachment(messageId, fileEntry.getTitle());
                    continue;
                }
                this.moveMessageAttachmentToTrash(userId, messageId, fileEntry.getTitle());
            }
            Folder folder = message.addAttachmentsFolder();
            PortletFileRepositoryUtil.addPortletFileEntries((long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)message.getMessageId(), (String)"19", (long)folder.getFolderId(), inputStreamOVPs);
        } else if (TrashUtil.isTrashEnabled((long)message.getGroupId())) {
            fileEntries = message.getAttachmentsFileEntries();
            for (FileEntry fileEntry : fileEntries) {
                this.moveMessageAttachmentToTrash(userId, messageId, fileEntry.getTitle());
            }
        }
        message.setExpandoBridgeAttributes(serviceContext);
        this.mbMessagePersistence.update((BaseModel)message);
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this.mbThreadPersistence.update((BaseModel)thread);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        this.updateAsset(userId, message, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)message.getCompanyId(), (long)message.getGroupId(), (long)userId, (String)message.getWorkflowClassName(), (long)message.getMessageId(), (Object)message, (ServiceContext)serviceContext);
        return message;
    }

    public MBMessage updateMessage(long messageId, String body) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        message.setBody(body);
        this.mbMessagePersistence.update((BaseModel)message);
        return message;
    }

    public MBMessage updateStatus(long userId, long messageId, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        int oldStatus = message.getStatus();
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        Date modifiedDate = serviceContext.getModifiedDate(now);
        message.setStatus(status);
        message.setStatusByUserId(userId);
        message.setStatusByUserName(user.getFullName());
        message.setStatusDate(modifiedDate);
        this.mbMessagePersistence.update((BaseModel)message);
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        this.updateThreadStatus(thread, message, user, oldStatus, modifiedDate);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        if (status == 0) {
            if (oldStatus != 0) {
                if (serviceContext.isAssetEntryVisible() && (message.getClassNameId() == 0L || message.getParentMessageId() != 0L)) {
                    Date publishDate = null;
                    AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(message.getWorkflowClassName(), message.getMessageId());
                    if (assetEntry != null && assetEntry.getPublishDate() != null) {
                        publishDate = assetEntry.getPublishDate();
                    } else {
                        publishDate = now;
                        serviceContext.setCommand("add");
                    }
                    this.assetEntryLocalService.updateEntry(message.getWorkflowClassName(), message.getMessageId(), publishDate, true);
                }
                if (serviceContext.isCommandAdd()) {
                    JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                    extraDataJSONObject.put("title", message.getSubject());
                    if (!message.isDiscussion()) {
                        if (!message.isAnonymous() && !user.isDefaultUser()) {
                            long receiverUserId = 0L;
                            MBMessage parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(message.getParentMessageId());
                            if (parentMessage != null) {
                                receiverUserId = parentMessage.getUserId();
                            }
                            this.socialActivityLocalService.addActivity(userId, message.getGroupId(), MBMessage.class.getName(), message.getMessageId(), 1, extraDataJSONObject.toString(), receiverUserId);
                            if (parentMessage != null && receiverUserId != userId) {
                                this.socialActivityLocalService.addActivity(userId, parentMessage.getGroupId(), MBMessage.class.getName(), parentMessage.getMessageId(), 2, extraDataJSONObject.toString(), 0L);
                            }
                        }
                    } else {
                        AssetEntry assetEntry;
                        String className = (String)((Object)serviceContext.getAttribute("className"));
                        long classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK");
                        long parentMessageId = message.getParentMessageId();
                        if (parentMessageId != 0L && (assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK)) != null) {
                            extraDataJSONObject.put("messageId", message.getMessageId());
                            this.socialActivityLocalService.addActivity(userId, assetEntry.getGroupId(), className, classPK, 10005, extraDataJSONObject.toString(), assetEntry.getUserId());
                        }
                    }
                }
            }
            this.notifySubscribers((MBMessage)message.clone(), serviceContext);
            indexer.reindex((Object)message);
            this.pingPingback(message, serviceContext);
        } else if (oldStatus == 0) {
            this.assetEntryLocalService.updateVisible(message.getWorkflowClassName(), message.getMessageId(), false);
            indexer.delete((Object)message);
        }
        if (!message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), userId, serviceContext.getModifiedDate(now));
        }
        return message;
    }

    public void updateUserName(long userId, String userName) throws SystemException {
        List messages = this.mbMessagePersistence.findByUserId(userId);
        for (MBMessage message : messages) {
            message.setUserName(userName);
            this.mbMessagePersistence.update((BaseModel)message);
        }
    }

    protected String getBody(String subject, String body) {
        if (Validator.isNull((String)body)) {
            return subject;
        }
        return body;
    }

    protected String getSubject(String subject, String body) {
        if (Validator.isNull((String)subject)) {
            return StringUtil.shorten((String)body);
        }
        return subject;
    }

    protected void notifyDiscussionSubscribers(MBMessage message, ServiceContext serviceContext) throws SystemException {
        if (!PrefsPropsUtil.getBoolean(message.getCompanyId(), "discussion.email.comments.added.enabled")) {
            return;
        }
        String contentURL = (String)((Object)serviceContext.getAttribute("contentURL"));
        String userAddress = "";
        String userName = (String)((Object)serviceContext.getAttribute("pingbackUserName"));
        if (Validator.isNull((String)userName)) {
            userAddress = PortalUtil.getUserEmailAddress((long)message.getUserId());
            userName = PortalUtil.getUserName((long)message.getUserId(), (String)"");
        }
        String fromName = PrefsPropsUtil.getString(message.getCompanyId(), "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(message.getCompanyId(), "admin.email.from.address");
        String subject = PrefsPropsUtil.getContent(message.getCompanyId(), "discussion.email.subject");
        String body = PrefsPropsUtil.getContent(message.getCompanyId(), "discussion.email.body");
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(message.getCompanyId());
        subscriptionSender.setContextAttribute("[$COMMENTS_BODY$]", (Object)message.getBody(true), false);
        subscriptionSender.setContextAttributes(new Object[]{"[$COMMENTS_USER_ADDRESS$]", userAddress, "[$COMMENTS_USER_NAME$]", userName, "[$CONTENT_URL$]", contentURL});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("mb_discussion", new Object[]{message.getCategoryId(), message.getMessageId()});
        subscriptionSender.setScopeGroupId(message.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(message.getUserId());
        String className = (String)((Object)serviceContext.getAttribute("className"));
        long classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK");
        subscriptionSender.addPersistedSubscribers(className, classPK);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void notifySubscribers(MBMessage message, ServiceContext serviceContext) throws PortalException, SystemException {
        long categoryId;
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (!message.isApproved() || Validator.isNull((String)layoutFullURL)) {
            return;
        }
        if (message.isDiscussion()) {
            try {
                this.notifyDiscussionSubscribers(message, serviceContext);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = message.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "19";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(message.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(serviceContext.isCommandAdd() && MBUtil.getEmailMessageAddedEnabled(preferences) || serviceContext.isCommandUpdate() && MBUtil.getEmailMessageUpdatedEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(message.getCompanyId());
        Group group = this.groupPersistence.findByPrimaryKey(message.getGroupId());
        String emailAddress = PortalUtil.getUserEmailAddress((long)message.getUserId());
        String fullName = PortalUtil.getUserName((long)message.getUserId(), (String)message.getUserName());
        if (message.isAnonymous()) {
            emailAddress = "";
            fullName = serviceContext.translate("anonymous", new Object[0]);
        }
        MBCategory category = message.getCategory();
        String categoryName = category.getName();
        if (category.getCategoryId() == 0L) {
            categoryName = serviceContext.translate("message-boards-home", new Object[0]);
            categoryName = String.valueOf(categoryName) + " - " + group.getDescriptiveName();
        }
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(message.getCategoryId());
        if (message.getCategoryId() != 0L) {
            categoryIds.addAll(category.getAncestorCategoryIds());
        }
        String messageURL = String.valueOf(layoutFullURL) + "/-/" + "message_boards/view_message/" + message.getMessageId();
        String fromName = MBUtil.getEmailFromName(preferences, message.getCompanyId());
        String fromAddress = MBUtil.getEmailFromAddress(preferences, message.getCompanyId());
        String replyToAddress = "";
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            replyToAddress = MBUtil.getReplyToAddress(message.getCategoryId(), message.getMessageId(), company.getMx(), fromAddress);
        }
        String subject = null;
        String body = null;
        String signature = null;
        if (serviceContext.isCommandUpdate()) {
            subject = MBUtil.getEmailMessageUpdatedSubject(preferences);
            body = MBUtil.getEmailMessageUpdatedBody(preferences);
            signature = MBUtil.getEmailMessageUpdatedSignature(preferences);
        } else {
            subject = MBUtil.getEmailMessageAddedSubject(preferences);
            body = MBUtil.getEmailMessageAddedBody(preferences);
            signature = MBUtil.getEmailMessageAddedSignature(preferences);
        }
        boolean htmlFormat = MBUtil.getEmailHtmlFormat(preferences);
        if (Validator.isNotNull((String)signature)) {
            String signatureSeparator = null;
            signatureSeparator = htmlFormat ? "<br />--<br />" : "\n--\n";
            body = String.valueOf(body) + signatureSeparator + signature;
        }
        String messageBody = message.getBody();
        if (htmlFormat && message.isFormatBBCode()) {
            try {
                messageBody = BBCodeTranslatorUtil.getHTML((String)messageBody);
                HttpServletRequest request = serviceContext.getRequest();
                if (request != null) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    messageBody = MBUtil.replaceMessageBodyPaths(themeDisplay, messageBody);
                }
            }
            catch (Exception e3) {
                _log.error((Object)("Could not parse message " + message.getMessageId() + " " + e3.getMessage()));
            }
        }
        String inReplyTo = null;
        if (message.getParentMessageId() != 0L) {
            inReplyTo = PortalUtil.getMailId((String)company.getMx(), (String)"mb_message.", (Object[])new Object[]{message.getCategoryId(), message.getParentMessageId()});
        }
        MBSubscriptionSender subscriptionSenderPrototype = new MBSubscriptionSender();
        subscriptionSenderPrototype.setBody(body);
        subscriptionSenderPrototype.setBulk(PropsValues.MESSAGE_BOARDS_EMAIL_BULK);
        subscriptionSenderPrototype.setCompanyId(message.getCompanyId());
        subscriptionSenderPrototype.setContextAttribute("[$MESSAGE_BODY$]", messageBody, false);
        subscriptionSenderPrototype.setContextAttributes(new Object[]{"[$CATEGORY_NAME$]", categoryName, "[$MAILING_LIST_ADDRESS$]", replyToAddress, "[$MESSAGE_ID$]", message.getMessageId(), "[$MESSAGE_SUBJECT$]", message.getSubject(), "[$MESSAGE_URL$]", messageURL, "[$MESSAGE_USER_ADDRESS$]", emailAddress, "[$MESSAGE_USER_NAME$]", fullName});
        subscriptionSenderPrototype.setFrom(fromAddress, fromName);
        subscriptionSenderPrototype.setHtmlFormat(htmlFormat);
        subscriptionSenderPrototype.setInReplyTo(inReplyTo);
        subscriptionSenderPrototype.setMailId("mb_message.", new Object[]{message.getCategoryId(), message.getMessageId()});
        subscriptionSenderPrototype.setPortletId("19");
        subscriptionSenderPrototype.setReplyToAddress(replyToAddress);
        subscriptionSenderPrototype.setScopeGroupId(message.getGroupId());
        subscriptionSenderPrototype.setServiceContext(serviceContext);
        subscriptionSenderPrototype.setSubject(subject);
        subscriptionSenderPrototype.setUserId(message.getUserId());
        SubscriptionSender subscriptionSender = (SubscriptionSender)SerializableUtil.clone((Object)((Object)subscriptionSenderPrototype));
        subscriptionSender.addPersistedSubscribers(MBCategory.class.getName(), message.getGroupId());
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            categoryId = (Long)iterator.next();
            if (categoryId == 0L) continue;
            subscriptionSender.addPersistedSubscribers(MBCategory.class.getName(), categoryId);
        }
        subscriptionSender.addPersistedSubscribers(MBThread.class.getName(), message.getThreadId());
        subscriptionSender.flushNotificationsAsync();
        if (!MailingListThreadLocal.isSourceMailingList()) {
            iterator = categoryIds.iterator();
            while (iterator.hasNext()) {
                categoryId = (Long)iterator.next();
                MBSubscriptionSender sourceMailingListSubscriptionSender = (MBSubscriptionSender)((Object)SerializableUtil.clone((Object)((Object)subscriptionSenderPrototype)));
                sourceMailingListSubscriptionSender.setBulk(false);
                sourceMailingListSubscriptionSender.addMailingListSubscriber(message.getGroupId(), categoryId);
                sourceMailingListSubscriptionSender.flushNotificationsAsync();
            }
        }
    }

    protected void pingPingback(MBMessage message, ServiceContext serviceContext) {
        if (!(PropsValues.BLOGS_PINGBACK_ENABLED && message.isAllowPingbacks() && message.isApproved())) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        String sourceUri = String.valueOf(layoutFullURL) + "/-/" + "message_boards/view_message/" + message.getMessageId();
        Source source = new Source((CharSequence)message.getBody(true));
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            String targetUri = startTag.getAttributeValue("href");
            if (!Validator.isNotNull((String)targetUri)) continue;
            try {
                LinkbackProducerUtil.sendPingback(sourceUri, targetUri);
            }
            catch (Exception e2) {
                _log.error((Object)("Error while sending pingback " + targetUri), (Throwable)e2);
            }
        }
    }

    protected void updateAsset(long userId, MBMessage message, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, boolean assetEntryVisible) throws PortalException, SystemException {
        boolean visible = false;
        if (assetEntryVisible && message.isApproved() && (message.getClassNameId() == 0L || message.getParentMessageId() != 0L)) {
            visible = true;
        }
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, message.getGroupId(), message.getCreateDate(), message.getModifiedDate(), message.getWorkflowClassName(), message.getMessageId(), message.getUuid(), 0L, assetCategoryIds, assetTagNames, visible, null, null, null, "text/html", message.getSubject(), null, null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    protected void updatePriorities(long threadId, double priority) throws SystemException {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            if (message.getPriority() == priority) continue;
            message.setPriority(priority);
            this.mbMessagePersistence.update((BaseModel)message);
        }
    }

    protected void updateThreadStatus(MBThread thread, MBMessage message, User user, int oldStatus, Date modifiedDate) throws PortalException, SystemException {
        MBCategory category = null;
        int status = message.getStatus();
        if (thread.getCategoryId() != 0L && thread.getCategoryId() != -1L) {
            category = this.mbCategoryPersistence.findByPrimaryKey(thread.getCategoryId());
        }
        if (thread.getRootMessageId() == message.getMessageId() && oldStatus != status) {
            thread.setModifiedDate(modifiedDate);
            thread.setStatus(status);
            thread.setStatusByUserId(user.getUserId());
            thread.setStatusByUserName(user.getFullName());
            thread.setStatusDate(modifiedDate);
        }
        if (status == oldStatus) {
            return;
        }
        if (status == 0) {
            if (message.isAnonymous()) {
                thread.setLastPostByUserId(0L);
            } else {
                thread.setLastPostByUserId(message.getUserId());
            }
            thread.setLastPostDate(modifiedDate);
            if (category != null) {
                category.setLastPostDate(modifiedDate);
                category = (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
            }
        }
        if (oldStatus == 0 || status == 0) {
            MBUtil.updateThreadMessageCount(thread.getCompanyId(), thread.getThreadId());
            if (category != null && thread.getRootMessageId() == message.getMessageId()) {
                MBUtil.updateCategoryStatistics(category.getCompanyId(), category.getCategoryId());
            }
            if (category != null && thread.getRootMessageId() != message.getMessageId()) {
                MBUtil.updateCategoryMessageCount(category.getCompanyId(), category.getCategoryId());
            }
        }
        this.mbThreadPersistence.update((BaseModel)thread);
    }

    protected void validate(String subject, String body) throws PortalException {
        if (Validator.isNull((String)subject) && Validator.isNull((String)body)) {
            throw new MessageSubjectException();
        }
    }
}

