/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MBMessageStagedModelDataHandler
extends BaseStagedModelDataHandler<MBMessage> {
    public static final String[] CLASS_NAMES = new String[]{MBMessage.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(MBMessageStagedModelDataHandler.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBMessage message) {
        return message.getSubject();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        if (message.getStatus() != 0 || message.getCategoryId() == -1L) {
            return;
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)message.getCategory());
        Element messageElement = portletDataContext.getExportDataElement((ClassedModel)message);
        message.setPriority(message.getPriority());
        MBThread thread = message.getThread();
        messageElement.addAttribute("question", String.valueOf(thread.isQuestion()));
        boolean hasAttachmentsFileEntries = message.getAttachmentsFileEntriesCount() > 0;
        messageElement.addAttribute("hasAttachmentsFileEntries", String.valueOf(hasAttachmentsFileEntries));
        if (hasAttachmentsFileEntries) {
            for (FileEntry fileEntry : message.getAttachmentsFileEntries()) {
                String name = fileEntry.getTitle();
                String binPath = ExportImportPathUtil.getModelPath((StagedModel)message, (String)name);
                Element attachmentElement = messageElement.addElement("attachment");
                attachmentElement.addAttribute("name", name);
                attachmentElement.addAttribute("bin-path", binPath);
                portletDataContext.addZipEntry(binPath, fileEntry.getContentStream());
            }
            long folderId = message.getAttachmentsFolderId();
            if (folderId != 0L) {
                message.setAttachmentsFolderId(folderId);
            }
        }
        portletDataContext.addClassedModel(messageElement, ExportImportPathUtil.getModelPath((StagedModel)message), (ClassedModel)message, "message_boards");
    }

    /*
     * Unable to fully structure code
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        userId = portletDataContext.getUserId(message.getUserUuid());
        userName = message.getUserName();
        categoryIds = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)message.getCategoryId(), (long)message.getCategoryId());
        threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        threadId = MapUtil.getLong((Map)threadIds, (long)message.getThreadId(), (long)0L);
        messageIds = portletDataContext.getNewPrimaryKeysMap(MBMessage.class);
        parentMessageId = MapUtil.getLong((Map)messageIds, (long)message.getParentMessageId(), (long)message.getParentMessageId());
        element = portletDataContext.getImportDataStagedModelElement((StagedModel)message);
        inputStreamOVPs = this.getAttachments(portletDataContext, element, message);
        try {
            serviceContext = portletDataContext.createServiceContext((StagedModel)message, "message_boards");
            if (message.getStatus() != 0) {
                serviceContext.setWorkflowAction(2);
            }
            if (parentCategoryId != 0L && parentCategoryId != -1L && parentCategoryId == message.getCategoryId()) {
                categoryPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)MBCategory.class.getName(), (long)parentCategoryId);
                category = (MBCategory)portletDataContext.getZipEntryAsObject(categoryPath);
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)category);
                parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)message.getCategoryId(), (long)message.getCategoryId());
            }
            importedMessage = null;
            if (portletDataContext.isDataStrategyMirror()) {
                existingMessage = MBMessageUtil.fetchByUUID_G((String)message.getUuid(), (long)portletDataContext.getScopeGroupId());
                if (existingMessage == null) {
                    serviceContext.setUuid(message.getUuid());
                    importedMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)portletDataContext.getScopeGroupId(), (long)parentCategoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (String)message.getFormat(), inputStreamOVPs, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
                } else {
                    importedMessage = MBMessageLocalServiceUtil.updateMessage((long)userId, (long)existingMessage.getMessageId(), (String)message.getSubject(), (String)message.getBody(), inputStreamOVPs, new ArrayList<E>(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
                }
            } else {
                importedMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)portletDataContext.getScopeGroupId(), (long)parentCategoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (String)message.getFormat(), inputStreamOVPs, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
            }
            importedMessage.setAnswer(message.getAnswer());
            if (importedMessage.isRoot()) {
                MBThreadLocalServiceUtil.updateQuestion((long)importedMessage.getThreadId(), (boolean)GetterUtil.getBoolean((String)element.attributeValue("question")));
            }
            threadIds.put(message.getThreadId(), importedMessage.getThreadId());
            portletDataContext.importClassedModel((ClassedModel)message, (ClassedModel)importedMessage, "message_boards");
        }
        finally {
            ** for (inputStreamOVP : inputStreamOVPs)
        }
lbl-1000:
        // 1 sources

        {
            inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((InputStream)inputStream);
            continue;
        }
lbl42:
        // 1 sources

    }

    protected List<ObjectValuePair<String, InputStream>> getAttachments(PortletDataContext portletDataContext, Element messageElement, MBMessage message) {
        boolean hasAttachmentsFileEntries = GetterUtil.getBoolean((String)messageElement.attributeValue("hasAttachmentsFileEntries"));
        if (!hasAttachmentsFileEntries) {
            return Collections.emptyList();
        }
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>();
        List attachmentElements = messageElement.elements("attachment");
        for (Element attachmentElement : attachmentElements) {
            String name = attachmentElement.attributeValue("name");
            String binPath = attachmentElement.attributeValue("bin-path");
            InputStream inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
            if (inputStream == null) continue;
            ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)name, (Object)inputStream);
            inputStreamOVPs.add((ObjectValuePair<String, InputStream>)inputStreamOVP);
        }
        if (inputStreamOVPs.isEmpty()) {
            _log.error((Object)("Could not find attachments for message " + message.getMessageId()));
        }
        return inputStreamOVPs;
    }
}

