/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBCategoryUtil;
import java.util.Map;

public class MBCategoryStagedModelDataHandler
extends BaseStagedModelDataHandler<MBCategory> {
    public static final String[] CLASS_NAMES = new String[]{MBCategory.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBCategory category) {
        return category.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBCategory category) throws Exception {
        if (category.getCategoryId() == 0L || category.getCategoryId() == -1L) {
            return;
        }
        if (category.getParentCategory() != null) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)category.getParentCategory());
        }
        Element categoryElement = portletDataContext.getExportDataElement((ClassedModel)category);
        portletDataContext.addClassedModel(categoryElement, ExportImportPathUtil.getModelPath((StagedModel)category), (ClassedModel)category, "message_boards");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBCategory category) throws Exception {
        long userId = portletDataContext.getUserId(category.getUserUuid());
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        String emailAddress = null;
        String inProtocol = null;
        String inServerName = null;
        int inServerPort = 0;
        boolean inUseSSL = false;
        String inUserName = null;
        String inPassword = null;
        int inReadInterval = 0;
        String outEmailAddress = null;
        boolean outCustom = false;
        String outServerName = null;
        int outServerPort = 0;
        boolean outUseSSL = false;
        String outUserName = null;
        String outPassword = null;
        boolean allowAnonymous = false;
        boolean mailingListActive = false;
        if (parentCategoryId != 0L && parentCategoryId != -1L && parentCategoryId == category.getParentCategoryId()) {
            String parentCategoryPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)MBCategory.class.getName(), (long)parentCategoryId);
            MBCategory parentCategory = (MBCategory)portletDataContext.getZipEntryAsObject(parentCategoryPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)parentCategory);
            parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)category, "message_boards");
        MBCategory importedCategory = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MBCategory existingCategory = MBCategoryUtil.fetchByUUID_G((String)category.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingCategory == null) {
                serviceContext.setUuid(category.getUuid());
                importedCategory = MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (ServiceContext)serviceContext);
            } else {
                importedCategory = MBCategoryLocalServiceUtil.updateCategory((long)existingCategory.getCategoryId(), (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedCategory = MBCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, (String)category.getName(), (String)category.getDescription(), (String)category.getDisplayStyle(), emailAddress, inProtocol, inServerName, (int)inServerPort, (boolean)inUseSSL, inUserName, inPassword, (int)inReadInterval, outEmailAddress, (boolean)outCustom, outServerName, (int)outServerPort, (boolean)outUseSSL, outUserName, outPassword, (boolean)allowAnonymous, (boolean)mailingListActive, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)category, (ClassedModel)importedCategory, "message_boards");
    }
}

