/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class MBCategoryAssetRenderer
extends BaseAssetRenderer {
    private MBCategory _category;

    public MBCategoryAssetRenderer(MBCategory category) {
        this._category = category;
    }

    public String getClassName() {
        return MBCategory.class.getName();
    }

    public long getClassPK() {
        return this._category.getCategoryId();
    }

    public long getGroupId() {
        return this._category.getGroupId();
    }

    public String getSummary(Locale locale) {
        return HtmlUtil.stripHtml((String)this._category.getDescription());
    }

    public String getTitle(Locale locale) {
        return this._category.getName();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "19", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/message_boards/edit_category");
        portletURL.setParameter("mbCategoryId", String.valueOf(this._category.getCategoryId()));
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL("19", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/message_boards/view");
        portletURL.setParameter("mbCategoryId", String.valueOf(this._category.getCategoryId()));
        portletURL.setWindowState(windowState);
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/message_boards/find_category", "mbCategoryId", this._category.getCategoryId());
    }

    public long getUserId() {
        return this._category.getUserId();
    }

    public String getUserName() {
        return this._category.getUserName();
    }

    public String getUuid() {
        return this._category.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return MBCategoryPermission.contains(permissionChecker, this._category, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return MBCategoryPermission.contains(permissionChecker, this._category, "VIEW");
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("MESSAGE_BOARDS_CATEGORY", (Object)this._category);
            return "/html/portlet/message_boards/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/conversation.png";
    }
}

