/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.captcha.CaptchaMaxChallengesException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditMessageAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            MBMessage message = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                message = this.updateMessage(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteMessage(actionRequest);
            } else if (cmd.equals("lock")) {
                this.lockThreads(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeMessage(actionRequest);
            } else if (cmd.equals("unlock")) {
                this.unlockThreads(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeMessage(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = this.getRedirect(actionRequest, actionResponse, message);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchMessageException || e2 instanceof PrincipalException || e2 instanceof RequiredMessageException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            if (e2 instanceof CaptchaMaxChallengesException || e2 instanceof CaptchaTextException || e2 instanceof FileExtensionException || e2 instanceof FileNameException || e2 instanceof FileSizeException || e2 instanceof LockedThreadException || e2 instanceof MessageBodyException || e2 instanceof MessageSubjectException || e2 instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            Throwable cause = e2.getCause();
            if (cause instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, SanitizerException.class);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getMessage((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchMessageException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.message_boards.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.edit_message"));
    }

    protected void deleteMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.deleteMessage((long)messageId);
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        if (message == null) {
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            return redirect;
        }
        int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
        if (workflowAction == 2) {
            return this.getSaveAndContinueRedirect(actionRequest, actionResponse, message);
        }
        if (message == null) {
            // empty if block
        }
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        PortletURL portletURL = actionResponseImpl.createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        return portletURL.toString();
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
        PortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/edit_message");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        portletURL.setParameter("preview", String.valueOf(preview));
        return portletURL.toString();
    }

    protected void lockThreads(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        if (threadId > 0L) {
            MBThreadServiceUtil.lockThread((long)threadId);
        } else {
            long[] threadIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
            int i2 = 0;
            while (i2 < threadIds.length) {
                MBThreadServiceUtil.lockThread((long)threadIds[i2]);
                ++i2;
            }
        }
    }

    protected void subscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.subscribeMessage((long)messageId);
    }

    protected void unlockThreads(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        if (threadId > 0L) {
            MBThreadServiceUtil.unlockThread((long)threadId);
        } else {
            long[] threadIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
            int i2 = 0;
            while (i2 < threadIds.length) {
                MBThreadServiceUtil.unlockThread((long)threadIds[i2]);
                ++i2;
            }
        }
    }

    protected void unsubscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.unsubscribeMessage((long)messageId);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MBMessage updateMessage(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        preferences = actionRequest.getPreferences();
        themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        groupId = themeDisplay.getScopeGroupId();
        categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        parentMessageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentMessageId");
        subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
        body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
        format = GetterUtil.getString((String)preferences.getValue("messageFormat", null), (String)MBMessageConstants.DEFAULT_FORMAT);
        inputStreamOVPs = new ArrayList<ObjectValuePair>(5);
        try {
            block15: {
                block14: {
                    uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
                    i = 1;
                    while (i <= 5) {
                        fileName = uploadPortletRequest.getFileName("msgFile" + i);
                        inputStream = uploadPortletRequest.getFileAsStream("msgFile" + i);
                        if (inputStream != null && !Validator.isNull((String)fileName)) {
                            inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                            inputStreamOVPs.add(inputStreamOVP);
                        }
                        ++i;
                    }
                    question = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"question");
                    anonymous = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"anonymous");
                    priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
                    allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
                    serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
                    preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
                    serviceContext.setAttribute("preview", (Serializable)Boolean.valueOf(preview));
                    message = null;
                    if (messageId > 0L) break block14;
                    if (PropsValues.CAPTCHA_CHECK_PORTLET_MESSAGE_BOARDS_EDIT_MESSAGE) {
                        CaptchaUtil.check((PortletRequest)actionRequest);
                    }
                    if (threadId <= 0L) {
                        message = MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)body, (String)format, inputStreamOVPs, (boolean)anonymous, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
                        if (question) {
                            MBThreadLocalServiceUtil.updateQuestion((long)message.getThreadId(), (boolean)true);
                        }
                        break block15;
                    } else {
                        message = MBMessageServiceUtil.addMessage((long)parentMessageId, (String)subject, (String)body, (String)format, inputStreamOVPs, (boolean)anonymous, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
                    }
                    break block15;
                }
                existingFiles = new ArrayList<String>();
                i = 1;
                while (i <= 5) {
                    path = ParamUtil.getString((PortletRequest)actionRequest, (String)("existingPath" + i));
                    if (Validator.isNotNull((String)path)) {
                        existingFiles.add(path);
                    }
                    ++i;
                }
                message = MBMessageServiceUtil.updateMessage((long)messageId, (String)subject, (String)body, inputStreamOVPs, existingFiles, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
                if (message.isRoot()) {
                    MBThreadLocalServiceUtil.updateQuestion((long)message.getThreadId(), (boolean)question);
                }
            }
            permissionChecker = themeDisplay.getPermissionChecker();
            subscribe = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"subscribe");
            if (!preview && subscribe && MBMessagePermission.contains(permissionChecker, message, "SUBSCRIBE")) {
                MBMessageServiceUtil.subscribeMessage((long)message.getMessageId());
            }
            var32_28 = message;
            return var32_28;
        }
        finally {
            ** for (inputStreamOVP : inputStreamOVPs)
        }
lbl-1000:
        // 1 sources

        {
            inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((InputStream)inputStream);
            continue;
        }
lbl67:
        // 1 sources

        return var32_28;
    }
}

