/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditDiscussionAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (cmd.equals("add") || cmd.equals("update")) {
                MBMessage message = this.updateMessage(actionRequest);
                String randomNamespace = ParamUtil.getString((PortletRequest)actionRequest, (String)"randomNamespace");
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("messageId", message.getMessageId());
                jsonObject.put("randomNamespace", randomNamespace);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
                return;
            }
            if (cmd.equals("delete")) {
                this.deleteMessage(actionRequest);
            } else if (cmd.equals("subscribe_to_comments")) {
                this.subscribeToComments(actionRequest, true);
            } else if (cmd.equals("unsubscribe_from_comments")) {
                this.subscribeToComments(actionRequest, false);
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e2) {
            if (e2 instanceof MessageBodyException || e2 instanceof NoSuchMessageException || e2 instanceof PrincipalException || e2 instanceof RequiredMessageException) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.putException(e2);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getMessage((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchMessageException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.message_boards.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.edit_discussion"));
    }

    protected void deleteMessage(ActionRequest actionRequest) throws Exception {
        long groupId = PortalUtil.getScopeGroupId((PortletRequest)actionRequest);
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        String permissionClassName = ParamUtil.getString((PortletRequest)actionRequest, (String)"permissionClassName");
        long permissionClassPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"permissionClassPK");
        long permissionOwnerId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"permissionOwnerId");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.deleteDiscussionMessage((long)groupId, (String)className, (long)classPK, (String)permissionClassName, (long)permissionClassPK, (long)permissionOwnerId, (long)messageId);
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void subscribeToComments(ActionRequest actionRequest, boolean subscribe) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        if (subscribe) {
            SubscriptionLocalServiceUtil.addSubscription((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)className, (long)classPK);
        } else {
            SubscriptionLocalServiceUtil.deleteSubscription((long)themeDisplay.getUserId(), (String)className, (long)classPK);
        }
    }

    protected MBMessage updateMessage(ActionRequest actionRequest) throws Exception {
        boolean subscribe;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        String permissionClassName = ParamUtil.getString((PortletRequest)actionRequest, (String)"permissionClassName");
        long permissionClassPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"permissionClassPK");
        long permissionOwnerId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"permissionOwnerId");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        long parentMessageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentMessageId");
        String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
        String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
        MBMessage message = null;
        if (messageId <= 0L) {
            User user = null;
            if (themeDisplay.isSignedIn()) {
                user = themeDisplay.getUser();
            } else {
                String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
                user = UserLocalServiceUtil.fetchUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)emailAddress);
                if (user == null || user.getStatus() != 6) {
                    return null;
                }
            }
            String name = PrincipalThreadLocal.getName();
            PrincipalThreadLocal.setName((long)user.getUserId());
            try {
                message = MBMessageServiceUtil.addDiscussionMessage((long)serviceContext.getScopeGroupId(), (String)className, (long)classPK, (String)permissionClassName, (long)permissionClassPK, (long)permissionOwnerId, (long)threadId, (long)parentMessageId, (String)subject, (String)body, (ServiceContext)serviceContext);
            }
            finally {
                PrincipalThreadLocal.setName((String)name);
            }
        } else {
            message = MBMessageServiceUtil.updateDiscussionMessage((String)className, (long)classPK, (String)permissionClassName, (long)permissionClassPK, (long)permissionOwnerId, (long)messageId, (String)subject, (String)body, (ServiceContext)serviceContext);
        }
        if (subscribe = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"subscribe")) {
            SubscriptionLocalServiceUtil.addSubscription((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)className, (long)classPK);
        }
        return message;
    }
}

