/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.lar;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutStagingHandler;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.LayoutFriendlyURLUtil;
import com.liferay.portal.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutStagedModelDataHandler
extends BaseStagedModelDataHandler<Layout> {
    public static final String[] CLASS_NAMES = new String[]{Layout.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(LayoutStagedModelDataHandler.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected String[] appendPortletIds(String[] portletIds, String[] newPortletIds, String portletsMergeMode) {
        String[] stringArray = newPortletIds;
        int n = newPortletIds.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            if (!ArrayUtil.contains((Object[])portletIds, (Object)portletId)) {
                portletIds = portletsMergeMode.equals("ADD_TO_BOTTOM") ? (String[])ArrayUtil.append((Object[])portletIds, (Object)portletId) : (String[])ArrayUtil.append((Object[])new String[]{portletId}, (Object[])portletIds);
            }
            ++n2;
        }
        return portletIds;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Layout layout) throws Exception {
        Layout parentLayout;
        LayoutRevision layoutRevision = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean exportLAR = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"exportLAR");
        if (!exportLAR && LayoutStagingUtil.isBranchingLayout((Layout)layout) && !layout.isTypeURL()) {
            long layoutSetBranchId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"layoutSetBranchId");
            if (layoutSetBranchId <= 0L) {
                return;
            }
            layoutRevision = LayoutRevisionUtil.fetchByL_H_P((long)layoutSetBranchId, (boolean)true, (long)layout.getPlid());
            if (layoutRevision == null) {
                return;
            }
            LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
            layoutStagingHandler.setLayoutRevision(layoutRevision);
        }
        Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
        this.populateElementLayoutMetadata(layoutElement, layout, layoutRevision);
        boolean deleteLayout = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)("delete_" + layout.getPlid()));
        if (deleteLayout) {
            layoutElement.addAttribute("delete", String.valueOf(true));
            return;
        }
        portletDataContext.setPlid(layout.getPlid());
        long parentLayoutId = layout.getParentLayoutId();
        if (parentLayoutId != 0L && (parentLayout = LayoutLocalServiceUtil.fetchLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId)) != null) {
            this.exportStagedModel(portletDataContext, (StagedModel)parentLayout);
            portletDataContext.addReferenceElement((StagedModel)layout, layoutElement, (ClassedModel)parentLayout, "parent", false);
            layoutElement.addAttribute("parent-layout-uuid", parentLayout.getUuid());
        }
        List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutFriendlyURL);
            portletDataContext.addReferenceElement((StagedModel)layout, layoutElement, (ClassedModel)layoutFriendlyURL, "dependency", false);
        }
        if (layout.isIconImage()) {
            this.exportLayoutIconImage(portletDataContext, layout, layoutElement);
        }
        if (layout.isTypeArticle()) {
            this.exportJournalArticle(portletDataContext, layout, layoutElement);
        } else if (layout.isTypeLinkToLayout()) {
            this.exportLinkedLayout(portletDataContext, layout, layoutElement);
        }
        this.fixExportTypeSettings(layout);
        portletDataContext.addClassedModel(layoutElement, ExportImportPathUtil.getModelPath((StagedModel)layout), (ClassedModel)layout, "layouts_admin");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Layout layout) throws Exception {
        long layoutId;
        long groupId = portletDataContext.getGroupId();
        long userId = portletDataContext.getUserId(layout.getUserUuid());
        Element layoutElement = portletDataContext.getImportDataStagedModelElement((StagedModel)layout);
        String layoutUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-uuid"));
        long oldLayoutId = layoutId = (long)GetterUtil.getInteger((String)layoutElement.attributeValue("layout-id"));
        boolean deleteLayout = GetterUtil.getBoolean((String)layoutElement.attributeValue("delete"));
        boolean privateLayout = portletDataContext.isPrivateLayout();
        Map newLayoutsMap = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        if (deleteLayout) {
            Layout deletingLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId, (boolean)privateLayout);
            newLayoutsMap.put(oldLayoutId, layout);
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            LayoutLocalServiceUtil.deleteLayout((Layout)deletingLayout, (boolean)false, (ServiceContext)serviceContext);
            return;
        }
        Layout existingLayout = null;
        Layout importedLayout = null;
        String friendlyURL = layout.getFriendlyURL();
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (layoutsImportMode.equals("ADD_AS_NEW")) {
            layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            friendlyURL = "/" + layoutId;
        } else if (layoutsImportMode.equals("MERGE_BY_LAYOUT_NAME")) {
            Locale locale = LocaleUtil.getDefault();
            String localizedName = layout.getName(locale);
            List previousLayouts = LayoutUtil.findByG_P((long)groupId, (boolean)privateLayout);
            for (Layout curLayout : previousLayouts) {
                if (!localizedName.equals(curLayout.getName(locale)) && !friendlyURL.equals(curLayout.getFriendlyURL())) continue;
                existingLayout = curLayout;
                break;
            }
            if (existingLayout == null) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            }
        } else if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            existingLayout = LayoutUtil.fetchByUUID_G_P((String)layout.getUuid(), (long)groupId, (boolean)privateLayout);
            if (SitesUtil.isLayoutModifiedSinceLastMerge((Layout)existingLayout)) {
                newLayoutsMap.put(oldLayoutId, existingLayout);
                return;
            }
            LayoutFriendlyURL layoutFriendlyURL = LayoutFriendlyURLUtil.fetchByG_P_F_First((long)groupId, (boolean)privateLayout, (String)friendlyURL, null);
            if (layoutFriendlyURL != null && existingLayout == null) {
                Layout mergeFailFriendlyURLLayout = LayoutUtil.findByPrimaryKey((long)layoutFriendlyURL.getPlid());
                SitesUtil.addMergeFailFriendlyURLLayout((Layout)mergeFailFriendlyURLLayout);
                return;
            }
        } else {
            existingLayout = LayoutUtil.fetchByUUID_G_P((String)layout.getUuid(), (long)groupId, (boolean)privateLayout);
            if (existingLayout == null) {
                existingLayout = LayoutUtil.fetchByG_P_F((long)groupId, (boolean)privateLayout, (String)friendlyURL);
            }
            if (existingLayout == null) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            }
        }
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(7);
            sb.append("Layout with {groupId=");
            sb.append(groupId);
            sb.append(",privateLayout=");
            sb.append(privateLayout);
            sb.append(",layoutId=");
            sb.append(layoutId);
            if (existingLayout == null) {
                sb.append("} does not exist");
                _log.debug((Object)sb.toString());
            } else {
                sb.append("} exists");
                _log.debug((Object)sb.toString());
            }
        }
        if (existingLayout == null) {
            long plid = CounterLocalServiceUtil.increment();
            importedLayout = LayoutUtil.create((long)plid);
            if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
                importedLayout.setSourcePrototypeLayoutUuid(layout.getUuid());
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            } else {
                importedLayout.setCreateDate(layout.getCreateDate());
                importedLayout.setModifiedDate(layout.getModifiedDate());
                importedLayout.setLayoutPrototypeUuid(layout.getLayoutPrototypeUuid());
                importedLayout.setLayoutPrototypeLinkEnabled(layout.isLayoutPrototypeLinkEnabled());
                importedLayout.setSourcePrototypeLayoutUuid(layout.getSourcePrototypeLayoutUuid());
            }
            importedLayout.setUuid(layout.getUuid());
            importedLayout.setGroupId(groupId);
            importedLayout.setPrivateLayout(privateLayout);
            importedLayout.setLayoutId(layoutId);
            this.initNewLayoutPermissions(portletDataContext.getCompanyId(), groupId, userId, layout, importedLayout, privateLayout);
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            importedLayout.setLayoutSet(layoutSet);
        } else {
            importedLayout = existingLayout;
        }
        portletDataContext.setPlid(importedLayout.getPlid());
        portletDataContext.setOldPlid(layout.getPlid());
        newLayoutsMap.put(oldLayoutId, importedLayout);
        long parentLayoutId = layout.getParentLayoutId();
        String parentLayoutUuid = GetterUtil.getString((String)layoutElement.attributeValue("parent-layout-uuid"));
        Element parentLayoutElement = portletDataContext.getReferenceDataElement((StagedModel)layout, Layout.class, layout.getGroupId(), parentLayoutUuid);
        if (parentLayoutId != 0L && parentLayoutElement != null) {
            String parentLayoutPath = parentLayoutElement.attributeValue("path");
            Layout parentLayout = (Layout)portletDataContext.getZipEntryAsObject(parentLayoutPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)parentLayout);
            Layout importedParentLayout = (Layout)newLayoutsMap.get(parentLayoutId);
            parentLayoutId = importedParentLayout.getLayoutId();
        }
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(4);
            sb.append("Importing layout with layout id ");
            sb.append(layoutId);
            sb.append(" and parent layout id ");
            sb.append(parentLayoutId);
            _log.debug((Object)sb.toString());
        }
        importedLayout.setCompanyId(portletDataContext.getCompanyId());
        importedLayout.setParentLayoutId(parentLayoutId);
        importedLayout.setName(layout.getName());
        importedLayout.setTitle(layout.getTitle());
        importedLayout.setDescription(layout.getDescription());
        importedLayout.setKeywords(layout.getKeywords());
        importedLayout.setRobots(layout.getRobots());
        importedLayout.setType(layout.getType());
        String portletsMergeMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"PORTLETS_MERGE_MODE", (String)"REPLACE");
        if (layout.isTypeArticle()) {
            this.importJournalArticle(portletDataContext, layout, layoutElement);
            this.updateTypeSettings(importedLayout, layout);
        } else if (layout.isTypePortlet() && Validator.isNotNull((String)layout.getTypeSettings()) && !portletsMergeMode.equals("REPLACE")) {
            this.mergePortlets(importedLayout, layout.getTypeSettings(), portletsMergeMode);
        } else if (layout.isTypeLinkToLayout()) {
            this.importLinkedLayout(portletDataContext, layout, importedLayout, layoutElement, newLayoutsMap);
        } else {
            this.updateTypeSettings(importedLayout, layout);
        }
        importedLayout.setHidden(layout.isHidden());
        importedLayout.setFriendlyURL(friendlyURL);
        importedLayout.setIconImage(false);
        if (layout.isIconImage()) {
            this.importLayoutIconImage(portletDataContext, importedLayout, layoutElement);
        } else {
            ImageLocalServiceUtil.deleteImage((long)importedLayout.getIconImageId());
        }
        boolean importThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (importThemeSettings) {
            importedLayout.setThemeId(layout.getThemeId());
            importedLayout.setColorSchemeId(layout.getColorSchemeId());
        } else {
            importedLayout.setThemeId("");
            importedLayout.setColorSchemeId("");
        }
        importedLayout.setWapThemeId(layout.getWapThemeId());
        importedLayout.setWapColorSchemeId(layout.getWapColorSchemeId());
        importedLayout.setCss(layout.getCss());
        importedLayout.setPriority(layout.getPriority());
        importedLayout.setLayoutPrototypeUuid(layout.getLayoutPrototypeUuid());
        importedLayout.setLayoutPrototypeLinkEnabled(layout.isLayoutPrototypeLinkEnabled());
        StagingUtil.updateLastImportSettings((Element)layoutElement, (Layout)importedLayout, (PortletDataContext)portletDataContext);
        this.fixImportTypeSettings(importedLayout);
        LayoutUtil.update((Layout)importedLayout);
        List newLayouts = portletDataContext.getNewLayouts();
        newLayouts.add(importedLayout);
        layoutPlids.put(layout.getPlid(), importedLayout.getPlid());
        this.importLayoutFriendlyURLs(portletDataContext, layout);
        portletDataContext.importClassedModel((ClassedModel)layout, (ClassedModel)importedLayout, "layouts_admin");
    }

    protected void exportJournalArticle(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        JournalArticle article;
        block4: {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            String articleId = typeSettingsProperties.getProperty("article-id", "");
            long articleGroupId = layout.getGroupId();
            if (Validator.isNull((String)articleId) && _log.isWarnEnabled()) {
                _log.warn((Object)("No article id found in typeSettings of layout " + layout.getPlid()));
            }
            article = null;
            try {
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (int)0);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                if (!_log.isWarnEnabled()) break block4;
                StringBundler sb = new StringBundler(4);
                sb.append("No approved article found with group id ");
                sb.append(articleGroupId);
                sb.append(" and layout id ");
                sb.append(articleId);
                _log.warn((Object)sb.toString());
            }
        }
        if (article == null) {
            return;
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)article);
        portletDataContext.addReferenceElement((StagedModel)layout, layoutElement, (ClassedModel)article, "embedded", false);
    }

    protected void exportLayoutIconImage(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        Image image = ImageLocalServiceUtil.getImage((long)layout.getIconImageId());
        if (image != null) {
            String iconPath = ExportImportPathUtil.getModelPath((long)portletDataContext.getScopeGroupId(), (String)Image.class.getName(), (long)image.getImageId());
            Element iconImagePathElement = layoutElement.addElement("icon-image-path");
            iconImagePathElement.addText(iconPath);
            portletDataContext.addZipEntry(iconPath, image.getTextObj());
        }
    }

    protected void exportLinkedLayout(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
        if (linkToLayoutId > 0L) {
            try {
                Layout linkedToLayout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)linkToLayoutId);
                this.exportStagedModel(portletDataContext, (StagedModel)linkedToLayout);
                portletDataContext.addReferenceElement((StagedModel)layout, layoutElement, (ClassedModel)linkedToLayout, "strong", false);
                layoutElement.addAttribute("linked-to-layout-uuid", linkedToLayout.getUuid());
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
    }

    protected Object[] extractFriendlyURLInfo(Layout layout) {
        if (!layout.isTypeURL()) {
            return null;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = GetterUtil.getString((String)typeSettings.getProperty("url"));
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
            return null;
        }
        int x = url.indexOf(47, 1);
        if (x == -1) {
            return null;
        }
        int y = url.indexOf(47, x + 1);
        if (y == -1) {
            return null;
        }
        return new Object[]{url.substring(x, y), url, x, y};
    }

    protected void fixExportTypeSettings(Layout layout) throws Exception {
        Object[] friendlyURLInfo = this.extractFriendlyURLInfo(layout);
        if (friendlyURLInfo == null) {
            return;
        }
        String friendlyURL = (String)friendlyURLInfo[0];
        Group group = layout.getGroup();
        String groupFriendlyURL = group.getFriendlyURL();
        if (!friendlyURL.equals(groupFriendlyURL)) {
            return;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = (String)friendlyURLInfo[1];
        int x = (Integer)friendlyURLInfo[2];
        int y = (Integer)friendlyURLInfo[3];
        typeSettings.setProperty("url", String.valueOf(url.substring(0, x)) + "/[$SAME_GROUP_FRIENDLY_URL$]" + url.substring(y));
    }

    protected void fixImportTypeSettings(Layout layout) throws Exception {
        Object[] friendlyURLInfo = this.extractFriendlyURLInfo(layout);
        if (friendlyURLInfo == null) {
            return;
        }
        String friendlyURL = (String)friendlyURLInfo[0];
        if (!friendlyURL.equals("/[$SAME_GROUP_FRIENDLY_URL$]")) {
            return;
        }
        Group group = layout.getGroup();
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = (String)friendlyURLInfo[1];
        int x = (Integer)friendlyURLInfo[2];
        int y = (Integer)friendlyURLInfo[3];
        typeSettings.setProperty("url", String.valueOf(url.substring(0, x)) + group.getFriendlyURL() + url.substring(y));
    }

    protected void importJournalArticle(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        String articleId = typeSettingsProperties.getProperty("article-id", "");
        if (Validator.isNull((String)articleId)) {
            return;
        }
        List referenceDataElements = portletDataContext.getReferenceDataElements(layoutElement, JournalArticle.class);
        if (!referenceDataElements.isEmpty()) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)((Element)referenceDataElements.get(0)));
        }
        Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
        articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
        typeSettingsProperties.setProperty("article-id", articleId);
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)"", (String)articleId, (boolean)true);
    }

    protected void importLayoutFriendlyURLs(PortletDataContext portletDataContext, Layout layout) throws Exception {
        List layoutFriendlyURLElements = portletDataContext.getReferenceDataElements((StagedModel)layout, LayoutFriendlyURL.class);
        for (Element layoutFriendlyURLElement : layoutFriendlyURLElements) {
            String layoutFriendlyURLPath = layoutFriendlyURLElement.attributeValue("path");
            LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)portletDataContext.getZipEntryAsObject(layoutFriendlyURLPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutFriendlyURL);
        }
    }

    protected void importLayoutIconImage(PortletDataContext portletDataContext, Layout importedLayout, Element layoutElement) throws Exception {
        String iconImagePath = layoutElement.elementText("icon-image-path");
        byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(iconImagePath);
        if (iconBytes != null && iconBytes.length > 0) {
            importedLayout.setIconImage(true);
            if (importedLayout.getIconImageId() == 0L) {
                long iconImageId = CounterLocalServiceUtil.increment();
                importedLayout.setIconImageId(iconImageId);
            }
            ImageLocalServiceUtil.updateImage((long)importedLayout.getIconImageId(), (byte[])iconBytes);
        }
    }

    protected void importLinkedLayout(PortletDataContext portletDataContext, Layout layout, Layout importedLayout, Element layoutElement, Map<Long, Layout> newLayoutsMap) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
        String linkedToLayoutUuid = layoutElement.attributeValue("linked-to-layout-uuid");
        if (linkToLayoutId <= 0L) {
            this.updateTypeSettings(importedLayout, layout);
            return;
        }
        Element linkedToLayoutElement = portletDataContext.getReferenceDataElement((StagedModel)layout, Layout.class, layout.getGroupId(), linkedToLayoutUuid);
        if (linkedToLayoutElement != null) {
            String linkedToLayoutPath = linkedToLayoutElement.attributeValue("path");
            Layout linkedToLayout = (Layout)portletDataContext.getZipEntryAsObject(linkedToLayoutPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)linkedToLayout);
            Layout importedLinkedLayout = newLayoutsMap.get(linkToLayoutId);
            typeSettingsProperties.setProperty("privateLayout", String.valueOf(importedLinkedLayout.isPrivateLayout()));
            typeSettingsProperties.setProperty("linkToLayoutId", String.valueOf(importedLinkedLayout.getLayoutId()));
        } else if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(6);
            sb.append("Unable to link layout with friendly URL ");
            sb.append(layout.getFriendlyURL());
            sb.append(" and layout id ");
            sb.append(layout.getLayoutId());
            sb.append(" to layout with layout id ");
            sb.append(linkToLayoutId);
            _log.warn((Object)sb.toString());
        }
        this.updateTypeSettings(importedLayout, layout);
    }

    protected void initNewLayoutPermissions(long companyId, long groupId, long userId, Layout layout, Layout importedLayout, boolean privateLayout) throws Exception {
        boolean addGroupPermissions = true;
        Group group = importedLayout.getGroup();
        if (privateLayout && group.isUser()) {
            addGroupPermissions = false;
        }
        boolean addGuestPermissions = false;
        if (!privateLayout || layout.isTypeControlPanel()) {
            addGuestPermissions = true;
        }
        ResourceLocalServiceUtil.addResources((long)companyId, (long)groupId, (long)userId, (String)Layout.class.getName(), (long)importedLayout.getPlid(), (boolean)false, (boolean)addGroupPermissions, (boolean)addGuestPermissions);
    }

    protected void mergePortlets(Layout layout, String newTypeSettings, String portletsMergeMode) {
        try {
            UnicodeProperties previousTypeSettingsProperties = layout.getTypeSettingsProperties();
            LayoutTypePortlet previousLayoutType = (LayoutTypePortlet)layout.getLayoutType();
            LayoutTemplate previousLayoutTemplate = previousLayoutType.getLayoutTemplate();
            List previousColumns = previousLayoutTemplate.getColumns();
            UnicodeProperties newTypeSettingsProperties = new UnicodeProperties(true);
            newTypeSettingsProperties.load(newTypeSettings);
            String layoutTemplateId = newTypeSettingsProperties.getProperty("layout-template-id");
            previousTypeSettingsProperties.setProperty("layout-template-id", layoutTemplateId);
            String nestedColumnIds = newTypeSettingsProperties.getProperty("nested-column-ids");
            if (Validator.isNotNull((String)nestedColumnIds)) {
                String[] nestedColumnIdsArray;
                previousTypeSettingsProperties.setProperty("nested-column-ids", nestedColumnIds);
                String[] stringArray = nestedColumnIdsArray = StringUtil.split((String)nestedColumnIds);
                int n = nestedColumnIdsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String nestedColumnId = stringArray[n2];
                    String nestedColumnValue = newTypeSettingsProperties.getProperty(nestedColumnId);
                    previousTypeSettingsProperties.setProperty(nestedColumnId, nestedColumnValue);
                    ++n2;
                }
            }
            LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)false, null);
            Object[] newPortletIds = new String[]{};
            for (String columnId : newLayoutTemplate.getColumns()) {
                String columnValue = newTypeSettingsProperties.getProperty(columnId);
                Object[] portletIds = StringUtil.split((String)columnValue);
                if (!previousColumns.contains(columnId)) {
                    newPortletIds = (String[])ArrayUtil.append((Object[])newPortletIds, (Object[])portletIds);
                    continue;
                }
                String[] previousPortletIds = StringUtil.split((String)previousTypeSettingsProperties.getProperty(columnId));
                portletIds = this.appendPortletIds(previousPortletIds, (String[])portletIds, portletsMergeMode);
                previousTypeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            }
            String columnId = (String)previousColumns.get(0);
            Object[] portletIds = StringUtil.split((String)previousTypeSettingsProperties.getProperty(columnId));
            this.appendPortletIds((String[])portletIds, (String[])newPortletIds, portletsMergeMode);
            previousTypeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            layout.setTypeSettings(previousTypeSettingsProperties.toString());
        }
        catch (IOException iOException) {
            layout.setTypeSettings(newTypeSettings);
        }
    }

    protected void populateElementLayoutMetadata(Element layoutElement, Layout layout, LayoutRevision layoutRevision) throws Exception {
        if (layoutRevision != null) {
            layoutElement.addAttribute("layout-revision-id", String.valueOf(layoutRevision.getLayoutRevisionId()));
            layoutElement.addAttribute("layout-branch-id", String.valueOf(layoutRevision.getLayoutBranchId()));
            LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
            layoutElement.addAttribute("layout-branch-name", String.valueOf(layoutBranch.getName()));
        }
        layoutElement.addAttribute("layout-uuid", layout.getUuid());
        layoutElement.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
        String layoutPrototypeUuid = layout.getLayoutPrototypeUuid();
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)layout.getCompanyId());
            layoutElement.addAttribute("layout-prototype-uuid", layoutPrototypeUuid);
            layoutElement.addAttribute("layout-prototype-name", layoutPrototype.getName(LocaleUtil.getDefault()));
        }
    }

    protected void updateTypeSettings(Layout importedLayout, Layout layout) throws PortalException, SystemException {
        long groupId = layout.getGroupId();
        try {
            LayoutTypePortlet importedLayoutType = (LayoutTypePortlet)importedLayout.getLayoutType();
            List importedPortletIds = importedLayoutType.getPortletIds();
            layout.setGroupId(importedLayout.getGroupId());
            LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
            importedPortletIds.removeAll(layoutType.getPortletIds());
            if (!importedPortletIds.isEmpty()) {
                PortletLocalServiceUtil.deletePortlets((long)importedLayout.getCompanyId(), (String[])importedPortletIds.toArray(new String[importedPortletIds.size()]), (long)importedLayout.getPlid());
            }
            importedLayout.setTypeSettings(layout.getTypeSettings());
        }
        finally {
            layout.setGroupId(groupId);
        }
    }
}

