/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARFileSizeException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.MissingReferenceException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.ExportImportHelper;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.MissingReference;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.action.EditFileEntryAction;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.sites.action.ActionUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ImportLayoutsAction
extends EditFileEntryAction {
    private static Log _log = LogFactoryUtil.getLog(ImportLayoutsAction.class);

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add_temp")) {
                this.addTempFileEntry(actionRequest, actionResponse);
                this.validateImportLayoutsFile(actionRequest, actionResponse);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempFileEntry(actionRequest, actionResponse);
            } else if (cmd.equals("import")) {
                this.importLayouts(actionRequest, actionResponse);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.handleUploadException(portletConfig, actionRequest, actionResponse, cmd, e2);
            }
            if (e2 instanceof LARFileException || e2 instanceof LARFileSizeException || e2 instanceof LARTypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof LayoutPrototypeException || e2 instanceof LocaleException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            _log.error((Object)e2, (Throwable)e2);
            SessionErrors.add((PortletRequest)actionRequest, (String)LayoutImportException.class.getName());
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.layouts_admin.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.import_layouts"));
    }

    @Override
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/import_layouts_resources.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void addTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        block7: {
            UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
            this.checkExceededSizeLimit((HttpServletRequest)uploadPortletRequest);
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this.deleteTempFileEntry(themeDisplay.getScopeGroupId());
            InputStream inputStream = null;
            try {
                try {
                    String sourceFileName = uploadPortletRequest.getFileName("file");
                    inputStream = uploadPortletRequest.getFileAsStream("file");
                    String contentType = uploadPortletRequest.getContentType("file");
                    LayoutServiceUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (String)sourceFileName, (String)ExportImportHelper.TEMP_FOLDER_NAME, (InputStream)inputStream, (String)contentType);
                }
                catch (Exception e2) {
                    UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                    if (uploadException == null || !(uploadException.getCause() instanceof FileUploadBase.IOFileUploadException)) {
                        if (uploadException != null && uploadException.isExceededSizeLimit()) {
                            throw new FileSizeException(uploadException.getCause());
                        }
                        throw e2;
                    }
                    StreamUtil.cleanUp((InputStream)inputStream);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                throw throwable;
            }
            StreamUtil.cleanUp((InputStream)inputStream);
        }
    }

    protected void checkExceededSizeLimit(HttpServletRequest request) throws PortalException {
        UploadException uploadException = (UploadException)request.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            if (uploadException.isExceededSizeLimit()) {
                throw new LARFileSizeException(uploadException.getCause());
            }
            throw new PortalException(uploadException.getCause());
        }
    }

    @Override
    protected void deleteTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
            LayoutServiceUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (String)fileName, (String)ExportImportHelper.TEMP_FOLDER_NAME);
            jsonObject.put("deleted", Boolean.TRUE.booleanValue());
        }
        catch (Exception exception) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
    }

    protected void deleteTempFileEntry(long groupId) throws PortalException, SystemException {
        String[] tempFileEntryNames;
        String[] stringArray = tempFileEntryNames = LayoutServiceUtil.getTempFileEntryNames((long)groupId, (String)ExportImportHelper.TEMP_FOLDER_NAME);
        int n = tempFileEntryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tempFileEntryName = stringArray[n2];
            LayoutServiceUtil.deleteTempFileEntry((long)groupId, (String)tempFileEntryName, (String)ExportImportHelper.TEMP_FOLDER_NAME);
            ++n2;
        }
    }

    @Override
    protected void handleUploadException(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse, String cmd, Exception e2) throws Exception {
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        response.setContentType("text/html");
        response.setStatus(200);
        String errorMessage = "";
        JSONArray errorMessageJSONArray = null;
        int errorType = 0;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (e2 instanceof DuplicateFileException || e2 instanceof FileExtensionException || e2 instanceof FileNameException || e2 instanceof FileSizeException || e2 instanceof LARFileException || e2 instanceof LARFileSizeException || e2 instanceof LARTypeException || e2 instanceof LayoutPrototypeException || e2 instanceof LocaleException || e2 instanceof MissingReferenceException) {
            if (e2 instanceof DuplicateFileException) {
                errorMessage = themeDisplay.translate("please-enter-a-unique-document-name");
                errorType = 490;
            } else if (e2 instanceof FileExtensionException) {
                errorMessage = themeDisplay.translate("document-names-must-end-with-one-of-the-following-extensions", (Object)StringUtil.merge((Object[])this.getAllowedFileExtensions(portletConfig, (PortletRequest)actionRequest, (PortletResponse)actionResponse)));
                errorType = 491;
            } else if (e2 instanceof FileNameException) {
                errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-name");
                errorType = 492;
            } else if (e2 instanceof FileSizeException || e2 instanceof LARFileSizeException) {
                long fileMaxSize = PrefsPropsUtil.getLong("dl.file.max.size");
                if (fileMaxSize == 0L) {
                    fileMaxSize = PrefsPropsUtil.getLong("com.liferay.portal.upload.UploadServletRequestImpl.max.size");
                }
                errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", (Object)(fileMaxSize /= 1024L));
                errorType = 493;
            } else if (e2 instanceof LARTypeException) {
                LARTypeException lte = (LARTypeException)e2;
                errorMessage = themeDisplay.translate("please-import-a-lar-file-of-the-correct-type-x-is-not-valid", (Object)lte.getMessage());
                errorType = 499;
            } else if (e2 instanceof LARFileException) {
                errorMessage = themeDisplay.translate("please-specify-a-lar-file-to-import");
                errorType = 499;
            } else if (e2 instanceof LayoutPrototypeException) {
                LayoutPrototypeException lpe = (LayoutPrototypeException)e2;
                StringBundler sb = new StringBundler(4);
                sb.append("the-lar-file-could-not-be-imported-because-it-");
                sb.append("requires-page-templates-or-site-templates-that-");
                sb.append("could-not-be-found.-please-import-the-following-");
                sb.append("templates-manually");
                errorMessage = themeDisplay.translate(sb.toString());
                errorMessageJSONArray = JSONFactoryUtil.createJSONArray();
                List missingLayoutPrototypes = lpe.getMissingLayoutPrototypes();
                for (Tuple missingLayoutPrototype : missingLayoutPrototypes) {
                    JSONObject errorMessageJSONObject = JSONFactoryUtil.createJSONObject();
                    String layoutPrototypeUuid = (String)missingLayoutPrototype.getObject(1);
                    errorMessageJSONObject.put("info", layoutPrototypeUuid);
                    String layoutPrototypeName = (String)missingLayoutPrototype.getObject(2);
                    errorMessageJSONObject.put("name", layoutPrototypeName);
                    String layoutPrototypeClassName = (String)missingLayoutPrototype.getObject(0);
                    errorMessageJSONObject.put("type", ResourceActionsUtil.getModelResource((Locale)themeDisplay.getLocale(), (String)layoutPrototypeClassName));
                    errorMessageJSONArray.put(errorMessageJSONObject);
                }
                errorType = 499;
            } else if (e2 instanceof LocaleException) {
                LocaleException le = (LocaleException)((Object)e2);
                errorMessage = themeDisplay.translate("the-available-languages-in-the-lar-file-x-do-not-match-the-portal's-available-languages-x", (Object[])new String[]{StringUtil.merge((Object[])le.getSourceAvailableLocales(), (String)", "), StringUtil.merge((Object[])le.getTargetAvailableLocales(), (String)", ")});
                errorType = 499;
            } else if (e2 instanceof MissingReferenceException) {
                MissingReferenceException mre = (MissingReferenceException)e2;
                errorMessage = themeDisplay.translate("there-are-missing-references-that-could-not-be-found-in-the-current-site.-please-import-another-lar-file-containing-the-following-elements");
                errorMessageJSONArray = JSONFactoryUtil.createJSONArray();
                Map missingReferences = mre.getMissingReferences();
                for (String missingReferenceDisplayName : missingReferences.keySet()) {
                    MissingReference missingReference = (MissingReference)missingReferences.get(missingReferenceDisplayName);
                    JSONObject errorMessageJSONObject = JSONFactoryUtil.createJSONObject();
                    Map referrers = missingReference.getReferrers();
                    if (referrers.size() == 1) {
                        Set referrerDisplayNames = referrers.entrySet();
                        Iterator iterator = referrerDisplayNames.iterator();
                        Map.Entry entry = iterator.next();
                        String referrerDisplayName = (String)entry.getKey();
                        String referrerClasName = (String)entry.getValue();
                        errorMessageJSONObject.put("info", themeDisplay.translate("referenced-by-a-x-x", (Object[])new String[]{ResourceActionsUtil.getModelResource((Locale)themeDisplay.getLocale(), (String)referrerClasName), referrerDisplayName}));
                    } else {
                        errorMessageJSONObject.put("info", themeDisplay.translate("referenced-by-x-elements", (Object)referrers.size()));
                    }
                    errorMessageJSONObject.put("name", missingReferenceDisplayName);
                    errorMessageJSONObject.put("type", ResourceActionsUtil.getModelResource((Locale)themeDisplay.getLocale(), (String)missingReference.getClassName()));
                    errorMessageJSONArray.put(errorMessageJSONObject);
                }
                errorType = 499;
            }
        } else {
            errorType = 499;
        }
        this.deleteTempFileEntry(themeDisplay.getScopeGroupId());
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("message", errorMessage);
        if (errorMessageJSONArray != null && errorMessageJSONArray.length() > 0) {
            jsonObject.put("messageListItems", errorMessageJSONArray);
        }
        jsonObject.put("status", errorType);
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
        ServletResponseUtil.write((HttpServletResponse)response, (String)String.valueOf(errorType));
    }

    protected void importLayouts(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        FileEntry fileEntry = ExportImportHelperUtil.getTempFileEntry((long)groupId, (long)themeDisplay.getUserId());
        File file = DLFileEntryLocalServiceUtil.getFile((long)themeDisplay.getUserId(), (long)fileEntry.getFileEntryId(), (String)fileEntry.getVersion(), (boolean)false);
        if (file == null || !file.exists()) {
            throw new LARFileException("Import file does not exist");
        }
        boolean successfulRename = false;
        File newFile = null;
        try {
            boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
            String newFileName = StringUtil.replace((String)file.getPath(), (String)file.getName(), (String)fileEntry.getTitle());
            newFile = new File(newFileName);
            successfulRename = file.renameTo(newFile);
            if (!successfulRename) {
                newFile = FileUtil.createTempFile((String)fileEntry.getExtension());
                FileUtil.copyFile((File)file, (File)newFile);
            }
            LayoutServiceUtil.importLayouts((long)groupId, (boolean)privateLayout, (Map)actionRequest.getParameterMap(), (File)newFile);
            this.deleteTempFileEntry(groupId);
            this.addSuccessMessage(actionRequest, actionResponse);
        }
        catch (Throwable throwable) {
            if (successfulRename) {
                successfulRename = newFile.renameTo(file);
                if (!successfulRename) {
                    FileUtil.copyFile((File)newFile, (File)file);
                    FileUtil.delete((File)newFile);
                }
            } else {
                FileUtil.delete(newFile);
            }
            throw throwable;
        }
        if (successfulRename) {
            successfulRename = newFile.renameTo(file);
            if (!successfulRename) {
                FileUtil.copyFile((File)newFile, (File)file);
                FileUtil.delete((File)newFile);
            }
        } else {
            FileUtil.delete((File)newFile);
        }
    }

    protected void validateImportLayoutsFile(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        FileEntry fileEntry = ExportImportHelperUtil.getTempFileEntry((long)groupId, (long)themeDisplay.getUserId());
        File file = DLFileEntryLocalServiceUtil.getFile((long)themeDisplay.getUserId(), (long)fileEntry.getFileEntryId(), (String)fileEntry.getVersion(), (boolean)false);
        if (file == null || !file.exists()) {
            throw new LARFileException("Import file does not exist");
        }
        boolean successfulRename = false;
        File newFile = null;
        try {
            boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
            String newFileName = StringUtil.replace((String)file.getPath(), (String)file.getName(), (String)fileEntry.getTitle());
            newFile = new File(newFileName);
            successfulRename = file.renameTo(newFile);
            if (!successfulRename) {
                newFile = FileUtil.createTempFile((String)fileEntry.getExtension());
                FileUtil.copyFile((File)file, (File)newFile);
            }
            LayoutServiceUtil.validateImportLayoutsFile((long)groupId, (boolean)privateLayout, (Map)actionRequest.getParameterMap(), (File)newFile);
        }
        catch (Throwable throwable) {
            if (successfulRename) {
                successfulRename = newFile.renameTo(file);
                if (!successfulRename) {
                    FileUtil.copyFile((File)newFile, (File)file);
                    FileUtil.delete((File)newFile);
                }
            } else {
                FileUtil.delete(newFile);
            }
            throw throwable;
        }
        if (successfulRename) {
            successfulRename = newFile.renameTo(file);
            if (!successfulRename) {
                FileUtil.copyFile((File)newFile, (File)file);
                FileUtil.delete((File)newFile);
            }
        } else {
            FileUtil.delete((File)newFile);
        }
    }
}

