/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.sites.action.ActionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportLayoutsAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(ExportLayoutsAction.class);

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        File file = null;
        try {
            try {
                long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
                boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
                long[] layoutIds = this.getLayoutIds(groupId, privateLayout, ParamUtil.getString((PortletRequest)actionRequest, (String)"layoutIds"));
                String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportFileName");
                DateRange dateRange = ExportImportHelperUtil.getDateRange((PortletRequest)actionRequest, (long)groupId, (boolean)privateLayout, (long)0L, null);
                Date startDate = dateRange.getStartDate();
                Date endDate = dateRange.getEndDate();
                if (Validator.isNotNull((String)cmd)) {
                    file = LayoutServiceUtil.exportLayoutsAsFile((long)groupId, (boolean)privateLayout, (long[])layoutIds, (Map)actionRequest.getParameterMap(), (Date)startDate, (Date)endDate);
                    HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)new FileInputStream(file), (String)"application/zip");
                    this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
                } else {
                    if (startDate != null) {
                        actionResponse.setRenderParameter("startDate", String.valueOf(startDate.getTime()));
                    }
                    if (endDate != null) {
                        actionResponse.setRenderParameter("endDate", String.valueOf(endDate.getTime()));
                    }
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                String pagesRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
                this.sendRedirect(actionRequest, actionResponse, pagesRedirect);
                FileUtil.delete(file);
            }
        }
        finally {
            FileUtil.delete(file);
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.layouts_admin.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.export_layouts"));
    }

    protected void addLayoutIds(List<Long> layoutIds, long groupId, boolean privateLayout, long layoutId) throws Exception {
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)layoutId);
        for (Layout layout : layouts) {
            layoutIds.add(layout.getLayoutId());
            this.addLayoutIds(layoutIds, layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        }
    }

    protected long[] getLayoutIds(long groupId, boolean privateLayout, String layoutIdsJSON) throws Exception {
        if (Validator.isNull((String)layoutIdsJSON)) {
            return new long[0];
        }
        ArrayList<Long> layoutIds = new ArrayList<Long>();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)layoutIdsJSON);
        int i2 = 0;
        while (i2 < jsonArray.length()) {
            JSONObject jsonObject = jsonArray.getJSONObject(i2);
            long layoutId = jsonObject.getLong("layoutId");
            if (layoutId > 0L) {
                layoutIds.add(layoutId);
            }
            if (jsonObject.getBoolean("includeChildren")) {
                this.addLayoutIds(layoutIds, groupId, privateLayout, layoutId);
            }
            ++i2;
        }
        return ArrayUtil.toArray((Long[])layoutIds.toArray(new Long[layoutIds.size()]));
    }
}

