/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServiceBeanMethodInvocationFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.lang.reflect.Method;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    private static Log _log = LogFactoryUtil.getLog(ConfigurationActionImpl.class);
    private Method _doProcessActionMethod;

    public ConfigurationActionImpl() {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            this._doProcessActionMethod = clazz.getDeclaredMethod("doProcessAction", PortletConfig.class, ActionRequest.class, ActionResponse.class);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ServiceBeanMethodInvocationFactoryUtil.proceed((Object)((Object)this), ConfigurationActionImpl.class, (Method)this._doProcessActionMethod, (Object[])new Object[]{portletConfig, actionRequest, actionResponse}, (String[])new String[]{"transactionAdvice"});
    }

    @Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    protected void doProcessAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String[] extensions = actionRequest.getParameterValues("extensions");
        this.setPreference((PortletRequest)actionRequest, "extensions", extensions);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletResource, (String)"");
        String articleId = this.getArticleId((PortletRequest)actionRequest);
        String originalArticleId = preferences.getValue("articleId", null);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource);
        PortletLayoutListener portletLayoutListener = portlet.getPortletLayoutListenerInstance();
        if (portletLayoutListener != null && Validator.isNotNull((String)originalArticleId) && !originalArticleId.equals(articleId)) {
            portletLayoutListener.onRemoveFromLayout(portletResource, layout.getPlid());
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
        if (SessionErrors.isEmpty((PortletRequest)actionRequest) && portletLayoutListener != null) {
            portletLayoutListener.onAddToLayout(portletResource, layout.getPlid());
        }
    }

    protected String getArticleId(PortletRequest portletRequest) {
        String articleId = this.getParameter(portletRequest, "articleId");
        return articleId.toUpperCase();
    }
}

