/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import com.liferay.portlet.journal.service.persistence.JournalFolderActionableDynamicQuery;
import java.util.ArrayList;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;

public class JournalFolderIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{JournalFolder.class.getName()};
    public static final String PORTLET_ID = "15";
    private static Log _log = LogFactoryUtil.getLog(JournalFolderIndexer.class);

    public JournalFolderIndexer() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)entryClassPK);
        return JournalFolderPermission.contains(permissionChecker, folder, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        JournalFolder folder = (JournalFolder)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, folder.getFolderId());
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)folder.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        JournalFolder trashedFolder;
        JournalFolder folder = (JournalFolder)obj;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing folder " + folder));
        }
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)folder);
        document.addText("description", folder.getDescription());
        document.addKeyword("folderId", folder.getParentFolderId());
        document.addText("title", folder.getName());
        if (!folder.isInTrash() && folder.isInTrashContainer() && (trashedFolder = folder.getTrashContainer()) != null) {
            this.addTrashFields(document, JournalFolder.class.getName(), trashedFolder.getFolderId(), null, null, "folder");
            document.addKeyword("rootEntryClassName", JournalFolder.class.getName());
            document.addKeyword("rootEntryClassPK", trashedFolder.getFolderId());
            document.addKeyword("status", 8);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + folder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        liferayPortletURL.setLifecycle("ACTION_PHASE");
        try {
            liferayPortletURL.setWindowState(LiferayWindowState.EXCLUSIVE);
        }
        catch (WindowStateException windowStateException) {}
        String folderId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/journal/view");
        portletURL.setParameter("folderId", folderId);
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        JournalFolder folder = (JournalFolder)obj;
        Document document = this.getDocument(folder);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)folder.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        this.doReindex(folder);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexFolders(long companyId) throws PortalException, SystemException {
        final ArrayList documents = new ArrayList();
        JournalFolderActionableDynamicQuery actionableDynamicQuery = new JournalFolderActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException {
                JournalFolder folder = (JournalFolder)object;
                Document document = JournalFolderIndexer.this.getDocument(folder);
                if (document != null) {
                    documents.add(document);
                }
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

