/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.FieldConstants;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMFieldsCounter;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.util.JournalConverter;
import com.liferay.util.PwdGenerator;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JournalConverterImpl
implements JournalConverter {
    private static Log _log = LogFactoryUtil.getLog(JournalConverterImpl.class);
    private Map<String, String> _ddmDataTypes = new HashMap<String, String>();
    private Map<String, String> _ddmMetadataAttributes;
    private Map<String, String> _ddmTypesToJournalTypes;
    private Map<String, String> _journalTypesToDDMTypes;

    public JournalConverterImpl() {
        this._ddmDataTypes.put("boolean", "boolean");
        this._ddmDataTypes.put("document_library", "document-library");
        this._ddmDataTypes.put("image", "image");
        this._ddmDataTypes.put("link_to_layout", "link-to-page");
        this._ddmDataTypes.put("list", "string");
        this._ddmDataTypes.put("multi-list", "string");
        this._ddmDataTypes.put("text", "string");
        this._ddmDataTypes.put("text_area", "html");
        this._ddmDataTypes.put("text_box", "string");
        this._ddmMetadataAttributes = new HashMap<String, String>();
        this._ddmMetadataAttributes.put("instructions", "tip");
        this._ddmMetadataAttributes.put("label", "label");
        this._ddmMetadataAttributes.put("predefinedValue", "predefinedValue");
        this._ddmTypesToJournalTypes = new HashMap<String, String>();
        this._ddmTypesToJournalTypes.put("checkbox", "boolean");
        this._ddmTypesToJournalTypes.put("ddm-documentlibrary", "document_library");
        this._ddmTypesToJournalTypes.put("ddm-link-to-page", "link_to_layout");
        this._ddmTypesToJournalTypes.put("ddm-text-html", "text_area");
        this._ddmTypesToJournalTypes.put("select", "list");
        this._ddmTypesToJournalTypes.put("text", "text");
        this._ddmTypesToJournalTypes.put("textarea", "text_box");
        this._ddmTypesToJournalTypes.put("wcm-image", "image");
        this._journalTypesToDDMTypes = new HashMap<String, String>();
        this._journalTypesToDDMTypes.put("boolean", "checkbox");
        this._journalTypesToDDMTypes.put("document_library", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("image", "wcm-image");
        this._journalTypesToDDMTypes.put("link_to_layout", "ddm-link-to-page");
        this._journalTypesToDDMTypes.put("list", "select");
        this._journalTypesToDDMTypes.put("multi-list", "select");
        this._journalTypesToDDMTypes.put("text", "text");
        this._journalTypesToDDMTypes.put("text_area", "ddm-text-html");
        this._journalTypesToDDMTypes.put("text_box", "textarea");
    }

    public String getContent(DDMStructure ddmStructure, Fields ddmFields) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        String availableLocales = this.getAvailableLocales(ddmFields);
        rootElement.addAttribute("available-locales", availableLocales);
        Locale defaultLocale = ddmFields.getDefaultLocale();
        rootElement.addAttribute("default-locale", LocaleUtil.toLanguageId((Locale)defaultLocale));
        DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
        for (String fieldName : ddmStructure.getRootFieldNames()) {
            int repetitions = this.countFieldRepetition(ddmFields, fieldName, null, -1);
            int i2 = 0;
            while (i2 < repetitions) {
                Element dynamicElementElement = rootElement.addElement("dynamic-element");
                dynamicElementElement.addAttribute("name", fieldName);
                dynamicElementElement.addAttribute("index", String.valueOf(i2));
                this.updateContentDynamicElement(dynamicElementElement, ddmStructure, ddmFields, ddmFieldsCounter);
                ++i2;
            }
        }
        return DDMXMLUtil.formatXML((String)document.asXML());
    }

    public Fields getDDMFields(DDMStructure ddmStructure, String content) throws Exception {
        Document document = SAXReaderUtil.read((String)content);
        Field fieldsDisplayField = new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)""));
        Fields ddmFields = new Fields();
        ddmFields.put(fieldsDisplayField);
        Element rootElement = document.getRootElement();
        String defaultLocale = rootElement.attributeValue("default-locale");
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.addDDMFields(dynamicElementElement, ddmStructure, ddmFields, defaultLocale);
        }
        return ddmFields;
    }

    public String getDDMXSD(String journalXSD) throws Exception {
        Document document = SAXReaderUtil.read((String)journalXSD);
        Element rootElement = document.getRootElement();
        Locale defaultLocale = LocaleUtil.getDefault();
        rootElement.addAttribute("available-locales", defaultLocale.toString());
        rootElement.addAttribute("default-locale", defaultLocale.toString());
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement);
        }
        return DDMXMLUtil.formatXML((Document)document);
    }

    public String getJournalXSD(String ddmXSD) throws Exception {
        Document document = SAXReaderUtil.read((String)ddmXSD);
        Element rootElement = document.getRootElement();
        String defaultLocale = rootElement.attributeValue("default-locale");
        this.removeAttribute(rootElement, "available-locales");
        this.removeAttribute(rootElement, "default-locale");
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateDDMXSDDynamicElement(dynamicElementElement, defaultLocale);
        }
        return DDMXMLUtil.formatXML((Document)document);
    }

    protected void addDDMFields(Element dynamicElementElement, DDMStructure ddmStructure, Fields ddmFields, String defaultLocale) throws Exception {
        String name = dynamicElementElement.attributeValue("name");
        if (!ddmStructure.hasField(name)) {
            return;
        }
        Field ddmField = this.getField(dynamicElementElement, ddmStructure, defaultLocale);
        String fieldName = ddmField.getName();
        Field existingDDMField = ddmFields.get(fieldName);
        if (existingDDMField != null) {
            for (Locale locale : ddmField.getAvailableLocales()) {
                existingDDMField.addValues(locale, ddmField.getValues(locale));
            }
        } else {
            ddmFields.put(ddmField);
        }
        this.updateFieldsDisplay(ddmFields, fieldName);
        List childrenDynamicElementElements = dynamicElementElement.elements("dynamic-element");
        for (Element childrenDynamicElementElement : childrenDynamicElementElements) {
            this.addDDMFields(childrenDynamicElementElement, ddmStructure, ddmFields, defaultLocale);
        }
    }

    protected void addMetadataEntry(Element metadataElement, String name, String value) {
        Element entryElement = metadataElement.addElement("entry");
        entryElement.addAttribute("name", name);
        entryElement.addCDATA(value);
    }

    protected void getJournalMetadataElement(Element metadataElement) {
        this.removeAttribute(metadataElement, "locale");
        Element dynamicElementElement = metadataElement.getParent();
        boolean required = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("required"));
        this.addMetadataEntry(metadataElement, "required", String.valueOf(required));
        Element tipElement = this.fetchMetadataEntry(metadataElement, "name", "tip");
        if (tipElement != null) {
            tipElement.addAttribute("name", "instructions");
            this.addMetadataEntry(metadataElement, "displayAsTooltip", "true");
        }
    }

    protected int countFieldRepetition(Fields ddmFields, String fieldName, String parentFieldName, int parentOffset) throws Exception {
        if (!ddmFields.contains(fieldName)) {
            return 0;
        }
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        String[] fieldsDisplayValues = DDMUtil.getFieldsDisplayValues((Field)fieldsDisplayField);
        int offset = -1;
        int repetitions = 0;
        int i2 = 0;
        while (i2 < fieldsDisplayValues.length) {
            String fieldDisplayName = fieldsDisplayValues[i2];
            if (offset > parentOffset) break;
            if (fieldDisplayName.equals(parentFieldName)) {
                ++offset;
            }
            if (fieldDisplayName.equals(fieldName) && offset == parentOffset) {
                ++repetitions;
            }
            ++i2;
        }
        return repetitions;
    }

    protected Element fetchMetadataEntry(Element parentElement, String attributeName, String attributeValue) {
        StringBundler sb = new StringBundler();
        sb.append("entry[@");
        sb.append(attributeName);
        sb.append("='");
        sb.append(attributeValue);
        sb.append("']");
        XPath xPathSelector = SAXReaderUtil.createXPath((String)sb.toString());
        return (Element)xPathSelector.selectSingleNode((Object)parentElement);
    }

    protected String getAvailableLocales(Fields ddmFields) {
        Set availableLocales = ddmFields.getAvailableLocales();
        Locale[] availableLocalesArray = new Locale[availableLocales.size()];
        availableLocalesArray = availableLocales.toArray(availableLocalesArray);
        Object[] languageIds = LocaleUtil.toLanguageIds((Locale[])availableLocalesArray);
        return StringUtil.merge((Object[])languageIds);
    }

    protected Serializable getDocumentLibraryValue(String url) {
        int x;
        block4: {
            try {
                x = url.indexOf("/documents/");
                if (x != -1) break block4;
                return null;
            }
            catch (Exception e2) {
                _log.warn((Object)"Error retrieving file entry", (Throwable)e2);
                return null;
            }
        }
        int y = url.indexOf("?");
        if (y == -1) {
            y = url.length();
        }
        url = url.substring(x, y);
        String[] parts = StringUtil.split((String)url, (char)'/');
        long groupId = GetterUtil.getLong((String)parts[2]);
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)parts[5], (long)groupId);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("groupId", fileEntry.getGroupId());
        jsonObject.put("uuid", fileEntry.getUuid());
        jsonObject.put("version", fileEntry.getVersion());
        return jsonObject.toString();
    }

    protected Field getField(Element dynamicElementElement, DDMStructure ddmStructure, String defaultLocale) throws Exception {
        Field ddmField = new Field();
        ddmField.setDDMStructureId(ddmStructure.getStructureId());
        ddmField.setDefaultLocale(LocaleUtil.fromLanguageId((String)defaultLocale));
        String name = dynamicElementElement.attributeValue("name");
        ddmField.setName(name);
        String dataType = ddmStructure.getFieldDataType(name);
        String type = ddmStructure.getFieldType(name);
        List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            Locale locale = LocaleUtil.fromLanguageId((String)dynamicContentElement.attributeValue("language-id"));
            Serializable serializable = this.getFieldValue(dataType, type, dynamicContentElement);
            ddmField.addValue(locale, serializable);
        }
        return ddmField;
    }

    protected Serializable getFieldValue(String dataType, String type, Element dynamicContentElement) throws Exception {
        Object serializable = null;
        if ("ddm-documentlibrary".equals(type)) {
            serializable = this.getDocumentLibraryValue(dynamicContentElement.getText());
        } else if ("ddm-link-to-page".equals(type)) {
            String[] values = StringUtil.split((String)dynamicContentElement.getText(), (char)'@');
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("layoutId", values[0]);
            if (values[1].equals("public")) {
                jsonObject.put("privateLayout", false);
            } else {
                jsonObject.put("privateLayout", true);
            }
            serializable = jsonObject.toString();
        } else if ("select".equals(type)) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            List optionElements = dynamicContentElement.elements("option");
            if (optionElements.size() > 0) {
                for (Element optionElement : optionElements) {
                    jsonArray.put(optionElement.getText());
                }
            } else {
                jsonArray.put(dynamicContentElement.getText());
            }
            serializable = jsonArray.toString();
        } else {
            serializable = FieldConstants.getSerializable((String)dataType, (String)dynamicContentElement.getText());
        }
        return serializable;
    }

    protected void removeAttribute(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return;
        }
        element.remove(attribute);
    }

    protected void updateContentDynamicElement(Element dynamicElementElement, DDMStructure ddmStructure, Field ddmField, DDMFieldsCounter ddmFieldsCounter) throws Exception {
        String fieldName = ddmField.getName();
        String fieldType = ddmStructure.getFieldType(fieldName);
        String indexType = ddmStructure.getFieldProperty(fieldName, "indexType");
        dynamicElementElement.addAttribute("type", this._ddmTypesToJournalTypes.get(fieldType));
        dynamicElementElement.addAttribute("index-type", indexType);
        for (Locale locale : ddmField.getAvailableLocales()) {
            Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
            dynamicContentElement.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)locale));
            int count = ddmFieldsCounter.get(fieldName);
            Serializable fieldValue = ddmField.getValue(locale, count);
            if (fieldValue instanceof Date) {
                Date valueDate = (Date)fieldValue;
                fieldValue = Long.valueOf(valueDate.getTime());
            }
            String valueString = String.valueOf(fieldValue);
            this.updateDynamicContentValue(dynamicContentElement, fieldType, valueString.trim());
        }
        ddmFieldsCounter.incrementKey(fieldName);
    }

    protected void updateContentDynamicElement(Element dynamicElementElement, DDMStructure ddmStructure, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws Exception {
        String fieldName = dynamicElementElement.attributeValue("name");
        for (String childFieldName : ddmStructure.getChildrenFieldNames(fieldName)) {
            int count = ddmFieldsCounter.get(fieldName);
            int repetitions = this.countFieldRepetition(ddmFields, childFieldName, fieldName, count);
            int i2 = 0;
            while (i2 < repetitions) {
                Element childDynamicElementElement = dynamicElementElement.addElement("dynamic-element");
                childDynamicElementElement.addAttribute("name", childFieldName);
                childDynamicElementElement.addAttribute("index", String.valueOf(i2));
                this.updateContentDynamicElement(childDynamicElementElement, ddmStructure, ddmFields, ddmFieldsCounter);
                ++i2;
            }
        }
        this.updateContentDynamicElement(dynamicElementElement, ddmStructure, ddmFields.get(fieldName), ddmFieldsCounter);
    }

    protected void updateDDMXSDDynamicElement(Element dynamicElementElement, String defaultLocale) {
        String[] removableAttributeNames;
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            String locale = metadataElement.attributeValue("locale");
            if (locale.equals(defaultLocale)) {
                this.getJournalMetadataElement(metadataElement);
                continue;
            }
            dynamicElementElement.remove(metadataElement);
        }
        Element parentElement = dynamicElementElement.getParent();
        String parentType = parentElement.attributeValue("type");
        if (Validator.equals((Object)parentType, (Object)"list") || Validator.equals((Object)parentType, (Object)"multi-list")) {
            String repeatable = parentElement.attributeValue("repeatable");
            String value = dynamicElementElement.attributeValue("value");
            dynamicElementElement.addAttribute("name", value);
            dynamicElementElement.addAttribute("repeatable", repeatable);
            dynamicElementElement.addAttribute("type", "value");
            this.removeAttribute(dynamicElementElement, "value");
            for (Element metadataElement : dynamicElementElement.elements("meta-data")) {
                dynamicElementElement.remove(metadataElement);
            }
            return;
        }
        String indexType = GetterUtil.getString((String)dynamicElementElement.attributeValue("indexType"));
        this.removeAttribute(dynamicElementElement, "indexType");
        dynamicElementElement.addAttribute("index-type", indexType);
        String type = dynamicElementElement.attributeValue("type");
        boolean multiple = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("multiple"));
        String newType = this._ddmTypesToJournalTypes.get(type);
        if (newType.equals("list") && multiple) {
            newType = "multi-list";
        }
        dynamicElementElement.addAttribute("type", newType);
        String[] stringArray = removableAttributeNames = new String[]{"dataType", "fieldNamespace", "multiple", "readOnly", "required", "showLabel", "width"};
        int n = removableAttributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String removableAttributeName = stringArray[n2];
            this.removeAttribute(dynamicElementElement, removableAttributeName);
            ++n2;
        }
        List childrenDynamicElementElements = dynamicElementElement.elements("dynamic-element");
        for (Element childrenDynamicElementElement : childrenDynamicElementElements) {
            this.updateDDMXSDDynamicElement(childrenDynamicElementElement, defaultLocale);
        }
    }

    protected void updateDynamicContentValue(Element dynamicContentElement, String fieldType, String fieldValue) throws Exception {
        if ("checkbox".equals(fieldType)) {
            if (fieldValue.equals(Boolean.FALSE.toString())) {
                fieldValue = "";
            }
            dynamicContentElement.addCDATA(fieldValue);
        } else if ("ddm-documentlibrary".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fieldValue);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            fieldValue = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)true);
            dynamicContentElement.addCDATA(fieldValue);
        } else if ("ddm-link-to-page".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fieldValue);
            String layoutId = jsonObject.getString("layoutId");
            boolean privateLayout = jsonObject.getBoolean("privateLayout");
            fieldValue = privateLayout ? layoutId.concat("@").concat("private") : layoutId.concat("@").concat("public");
            dynamicContentElement.addCDATA(fieldValue);
        } else if ("select".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)fieldValue);
            if (jsonArray.length() > 1) {
                int i2 = 0;
                while (i2 < jsonArray.length()) {
                    Element optionElement = dynamicContentElement.addElement("option");
                    optionElement.addCDATA(jsonArray.getString(i2));
                    ++i2;
                }
            } else {
                dynamicContentElement.addCDATA(jsonArray.getString(0));
            }
        } else {
            dynamicContentElement.addCDATA(fieldValue);
        }
    }

    protected void updateFieldsDisplay(Fields ddmFields, String fieldName) {
        String fieldsDisplayValue = fieldName.concat("_INSTANCE_").concat(PwdGenerator.getPassword());
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        Object[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())));
        fieldsDisplayValues = (String[])ArrayUtil.append((Object[])fieldsDisplayValues, (Object)fieldsDisplayValue);
        fieldsDisplayField.setValue((Serializable)((Object)StringUtil.merge((Object[])fieldsDisplayValues)));
    }

    protected void updateJournalXSDDynamicElement(Element element) {
        Locale defaultLocale = LocaleUtil.getDefault();
        String name = element.attributeValue("name");
        String type = element.attributeValue("type");
        Element metadataElement = element.element("meta-data");
        if (metadataElement == null) {
            metadataElement = element.addElement("meta-data");
        }
        if (type.equals("multi-list")) {
            element.addAttribute("multiple", "true");
        } else {
            if (type.equals("selection_break")) {
                Element parentElement = element.getParent();
                parentElement.remove(element);
                return;
            }
            Element parentElement = element.getParent();
            String parentType = parentElement.attributeValue("type");
            if (parentType != null && parentType.equals("select")) {
                metadataElement.addAttribute("locale", defaultLocale.toString());
                this.addMetadataEntry(metadataElement, "label", name);
                element.addAttribute("name", "option" + PwdGenerator.getPassword((int)4));
                element.addAttribute("type", "option");
                element.addAttribute("value", name);
                return;
            }
        }
        String indexType = "";
        Attribute indexTypeAttribute = element.attribute("index-type");
        if (indexTypeAttribute != null) {
            indexType = indexTypeAttribute.getValue();
            element.remove(indexTypeAttribute);
        }
        element.remove(element.attribute("type"));
        element.addAttribute("dataType", this._ddmDataTypes.get(type));
        element.addAttribute("indexType", indexType);
        String required = "false";
        Element requiredElement = this.fetchMetadataEntry(metadataElement, "name", "required");
        if (requiredElement != null) {
            required = requiredElement.getText();
        }
        element.addAttribute("required", required);
        element.addAttribute("showLabel", "true");
        String newType = this._journalTypesToDDMTypes.get(type);
        element.addAttribute("type", newType);
        if (newType.startsWith("ddm")) {
            element.addAttribute("fieldNamespace", "ddm");
        }
        metadataElement.addAttribute("locale", defaultLocale.toString());
        List entryElements = metadataElement.elements();
        if (entryElements.isEmpty()) {
            this.addMetadataEntry(metadataElement, "label", name);
        } else {
            for (Element entryElement : entryElements) {
                String oldEntryName = entryElement.attributeValue("name");
                String newEntryName = this._ddmMetadataAttributes.get(oldEntryName);
                if (newEntryName == null) {
                    metadataElement.remove(entryElement);
                    continue;
                }
                entryElement.addAttribute("name", newEntryName);
            }
        }
        if (newType.equals("ddm-date") || newType.equals("ddm-decimal") || newType.equals("ddm-integer") || newType.equals("ddm-link-to-page") || newType.equals("ddm-number") || newType.equals("ddm-text-html") || newType.equals("text") || newType.equals("textarea")) {
            element.addAttribute("width", "25");
        } else if (newType.equals("wcm-image")) {
            element.addAttribute("fieldNamespace", "wcm");
            element.addAttribute("readOnly", "false");
        }
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement);
        }
    }
}

