/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.asset.JournalFolderAssetRenderer;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import com.liferay.portlet.journal.trash.JournalBaseTrashHandler;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.trash.DuplicateEntryException;
import com.liferay.portlet.trash.model.TrashEntry;
import javax.portlet.PortletRequest;

public class JournalFolderTrashHandler
extends JournalBaseTrashHandler {
    public void checkDuplicateTrashEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException, SystemException {
        JournalFolder duplicateFolder;
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)trashEntry.getClassPK());
        String originalTitle = trashEntry.getTypeSettingsProperty("title");
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateFolder = JournalFolderLocalServiceUtil.fetchFolder((long)folder.getGroupId(), (long)folder.getParentFolderId(), (String)originalTitle)) != null) {
            DuplicateEntryException dee = new DuplicateEntryException();
            dee.setDuplicateEntryId(duplicateFolder.getFolderId());
            dee.setOldName(duplicateFolder.getName());
            dee.setTrashEntryId(trashEntry.getEntryId());
            throw dee;
        }
    }

    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        JournalFolderLocalServiceUtil.deleteFolder((long)classPK, (boolean)false);
    }

    public String getClassName() {
        return JournalFolder.class.getName();
    }

    public String getDeleteMessage() {
        return "found-in-deleted-folder-x";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        JournalFolder folder = this.getJournalFolder(classPK);
        long parentFolderId = folder.getParentFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public String getRestoreLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalUtil.getJournalControlPanelLink(portletRequest, folder.getParentFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalUtil.getAbsolutePath(portletRequest, folder.getParentFolderId());
    }

    public ContainerModel getTrashContainer(long classPK) throws PortalException, SystemException {
        JournalFolder folder = this.getJournalFolder(classPK);
        return folder.getTrashContainer();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return new JournalFolderAssetRenderer(folder);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            return JournalFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_FOLDER");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return folder.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        JournalFolder folder = this.getJournalFolder(classPK);
        return folder.isInTrashContainer();
    }

    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        JournalFolder folder = this.getJournalFolder(classPK);
        return !folder.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalFolderLocalServiceUtil.moveFolder((long)classPK, (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalFolderLocalServiceUtil.moveFolderFromTrash((long)userId, (long)classPK, (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        JournalFolderLocalServiceUtil.restoreFolderFromTrash((long)userId, (long)classPK);
    }

    public void updateTitle(long classPK, String name) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        folder.setName(name);
        JournalFolderLocalServiceUtil.updateJournalFolder((JournalFolder)folder);
    }

    @Override
    protected JournalFolder getJournalFolder(long classPK) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return folder;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalFolderPermission.contains(permissionChecker, folder, actionId);
    }
}

