/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.journal.DuplicateTemplateIdException;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.TemplateIdException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.model.JournalTemplateAdapter;
import com.liferay.portlet.journal.service.base.JournalTemplateLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JournalTemplateLocalServiceImpl
extends JournalTemplateLocalServiceBaseImpl {
    public JournalTemplate addJournalTemplate(JournalTemplate template) throws PortalException, SystemException {
        template.setNew(true);
        return this.updateTemplate(template);
    }

    public JournalTemplate addTemplate(long userId, long groupId, String templateId, boolean autoTemplateId, String structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException, SystemException {
        long classPK = 0L;
        if (Validator.isNotNull((String)structureId)) {
            JournalStructure structure = this.journalStructureLocalService.getStructure(groupId, structureId, true);
            classPK = structure.getPrimaryKey();
        }
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.addTemplate(userId, groupId, PortalUtil.getClassNameId(DDMStructure.class), classPK, templateId, nameMap, descriptionMap, "display", "create", langType, xsl, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
        return new JournalTemplateAdapter(ddmTemplate);
    }

    public void addTemplateResources(JournalTemplate template, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DDMTemplate ddmTemplate = this.getDDMTemplate(template);
        this.ddmTemplateLocalService.addTemplateResources(ddmTemplate, addGroupPermissions, addGuestPermissions);
    }

    public void addTemplateResources(JournalTemplate template, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DDMTemplate ddmTemplate = this.getDDMTemplate(template);
        this.ddmTemplateLocalService.addTemplateResources(ddmTemplate, groupPermissions, guestPermissions);
    }

    public void addTemplateResources(long groupId, String templateId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalTemplate template = this.doGetTemplate(groupId, templateId);
        this.addTemplateResources(template, addGroupPermissions, addGuestPermissions);
    }

    public void addTemplateResources(long groupId, String templateId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalTemplate template = this.doGetTemplate(groupId, templateId);
        this.addTemplateResources(template, groupPermissions, guestPermissions);
    }

    public void checkNewLine(long groupId, String templateId) throws PortalException, SystemException {
        JournalTemplate template = this.doGetTemplate(groupId, templateId);
        String xsl = template.getXsl();
        if (xsl != null && xsl.contains("\\n")) {
            xsl = StringUtil.replace((String)xsl, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            template.setXsl(xsl);
            this.updateTemplate(template);
        }
    }

    public JournalTemplate copyTemplate(long userId, long groupId, String oldTemplateId, String newTemplateId, boolean autoTemplateId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldTemplateId = oldTemplateId.trim().toUpperCase();
        newTemplateId = newTemplateId.trim().toUpperCase();
        Date now = new Date();
        JournalTemplate oldTemplate = this.doGetTemplate(groupId, oldTemplateId);
        if (autoTemplateId) {
            newTemplateId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validateTemplateId(newTemplateId);
            JournalTemplate newTemplate = this.fetchTemplate(groupId, newTemplateId);
            if (newTemplate != null) {
                throw new DuplicateTemplateIdException();
            }
        }
        long id = this.counterLocalService.increment();
        JournalTemplate newTemplate = this.createJournalTemplate(id);
        newTemplate.setGroupId(groupId);
        newTemplate.setCompanyId(user.getCompanyId());
        newTemplate.setUserId(user.getUserId());
        newTemplate.setUserName(user.getFullName());
        newTemplate.setCreateDate(now);
        newTemplate.setModifiedDate(now);
        newTemplate.setTemplateId(newTemplateId);
        newTemplate.setStructureId(oldTemplate.getStructureId());
        newTemplate.setNameMap(oldTemplate.getNameMap());
        newTemplate.setDescriptionMap(oldTemplate.getDescriptionMap());
        newTemplate.setXsl(oldTemplate.getXsl());
        newTemplate.setLangType(oldTemplate.getLangType());
        newTemplate.setCacheable(oldTemplate.isCacheable());
        newTemplate.setSmallImage(oldTemplate.isSmallImage());
        newTemplate.setSmallImageId(this.counterLocalService.increment());
        newTemplate.setSmallImageURL(oldTemplate.getSmallImageURL());
        newTemplate.setExpandoBridgeAttributes(oldTemplate);
        this.updateTemplate(newTemplate);
        if (oldTemplate.getSmallImage()) {
            Image image = this.imageLocalService.getImage(oldTemplate.getSmallImageId());
            byte[] smallImageBytes = image.getTextObj();
            this.imageLocalService.updateImage(newTemplate.getSmallImageId(), smallImageBytes);
        }
        return newTemplate;
    }

    public JournalTemplate createJournalTemplate(long id) {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.createDDMTemplate(id);
        return new JournalTemplateAdapter(ddmTemplate);
    }

    public void deleteTemplate(JournalTemplate template) throws PortalException, SystemException {
        DDMTemplate ddmTemplate = this.getDDMTemplate(template);
        this.ddmTemplateLocalService.deleteTemplate(ddmTemplate);
    }

    public void deleteTemplate(long groupId, String templateId) throws PortalException, SystemException {
        JournalTemplate template = this.doGetTemplate(groupId, templateId);
        this.deleteTemplate(template);
    }

    public void deleteTemplates(long groupId) throws PortalException, SystemException {
        List<JournalTemplate> templates = this.doGetTemplates(groupId, -1, -1);
        for (JournalTemplate template : templates) {
            this.deleteTemplate(template);
        }
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId) throws PortalException, SystemException {
        return this.getStructureTemplates(groupId, structureId, false);
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId, boolean includeGlobalTemplates) throws PortalException, SystemException {
        long[] groupIds = new long[]{groupId};
        if (includeGlobalTemplates) {
            groupIds = PortalUtil.getSiteAndCompanyGroupIds((long)groupId);
        }
        JournalStructure structure = this.journalStructureLocalService.getStructure(groupId, structureId, true);
        List ddmTemplates = this.ddmTemplateLocalService.getTemplatesByClassPK(groupIds, structure.getPrimaryKey());
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    public List<JournalTemplate> getStructureTemplates(long groupId, String structureId, int start, int end) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructureLocalService.getStructure(groupId, structureId, true);
        List ddmTemplates = this.ddmTemplateLocalService.getTemplatesByClassPK(groupId, structure.getPrimaryKey(), start, end);
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    public int getStructureTemplatesCount(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructure structure = this.journalStructureLocalService.getStructure(groupId, structureId, true);
        return this.ddmTemplateLocalService.getTemplatesByClassPKCount(groupId, structure.getPrimaryKey());
    }

    public JournalTemplate getTemplate(long groupId, String templateId) throws PortalException, SystemException {
        return this.getTemplate(groupId, templateId, false);
    }

    public JournalTemplate getTemplate(long groupId, String templateId, boolean includeGlobalTemplates) throws PortalException, SystemException {
        JournalTemplate template = this.fetchTemplate(groupId, templateId = GetterUtil.getString((String)templateId).toUpperCase());
        if (template != null) {
            return template;
        }
        if (!includeGlobalTemplates) {
            throw new NoSuchTemplateException("No JournalTemplate exists with the template ID " + templateId);
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        return this.doGetTemplate(companyGroup.getGroupId(), templateId);
    }

    public JournalTemplate getTemplateBySmallImageId(long smallImageId) throws PortalException, SystemException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplateBySmallImageId(smallImageId);
        return new JournalTemplateAdapter(ddmTemplate);
    }

    public List<JournalTemplate> getTemplates() throws SystemException {
        List ddmTemplates = this.ddmTemplateFinder.findByG_C_C_SC(null, PortalUtil.getClassNameId(DDMStructure.class), 0L, PortalUtil.getClassNameId(JournalArticle.class), -1, -1, null);
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    public List<JournalTemplate> getTemplates(long groupId) throws SystemException {
        return this.doGetTemplates(groupId);
    }

    public List<JournalTemplate> getTemplates(long groupId, int start, int end) throws SystemException {
        return this.doGetTemplates(groupId, start, end);
    }

    public int getTemplatesCount(long groupId) throws SystemException {
        return this.doGetTemplatesCount(groupId);
    }

    public boolean hasTemplate(long groupId, String templateId) throws SystemException {
        try {
            this.getTemplate(groupId, templateId);
            return true;
        }
        catch (PortalException portalException) {
            return false;
        }
    }

    public List<JournalTemplate> search(long companyId, long[] groupIds, String keywords, String structureId, String structureIdComparator, int start, int end, OrderByComparator obc) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(DDMStructure.class)};
        long[] classPKs = JournalUtil.getStructureClassPKs(groupIds, structureId);
        List ddmTemplates = this.ddmTemplateFinder.findByKeywords(companyId, groupIds, classNameIds, classPKs, keywords, null, null, start, end, obc);
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    public List<JournalTemplate> search(long companyId, long[] groupIds, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(DDMStructure.class)};
        long[] classPKs = JournalUtil.getStructureClassPKs(groupIds, structureId);
        List ddmTemplates = this.ddmTemplateFinder.findByC_G_C_C_N_D_T_M_L(companyId, groupIds, classNameIds, classPKs, name, description, null, null, null, andOperator, start, end, obc);
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, String structureId, String structureIdComparator) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(DDMStructure.class)};
        long[] classPKs = JournalUtil.getStructureClassPKs(groupIds, structureId);
        return this.ddmTemplateFinder.countByKeywords(companyId, groupIds, classNameIds, classPKs, keywords, null, null);
    }

    public int searchCount(long companyId, long[] groupIds, String templateId, String structureId, String structureIdComparator, String name, String description, boolean andOperator) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(DDMStructure.class)};
        long[] classPKs = JournalUtil.getStructureClassPKs(groupIds, structureId);
        return this.ddmTemplateFinder.countByC_G_C_C_N_D_T_M_L(companyId, groupIds, classNameIds, classPKs, name, description, null, null, null, andOperator);
    }

    public JournalTemplate updateJournalTemplate(JournalTemplate template) throws PortalException, SystemException {
        return this.updateTemplate(template);
    }

    public JournalTemplate updateTemplate(long groupId, String templateId, String structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsl, boolean formatXsl, String langType, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalTemplate template = this.doGetTemplate(groupId, templateId);
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.updateTemplate(template.getPrimaryKey(), nameMap, descriptionMap, "display", "create", langType, xsl, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
        if (Validator.isNull((String)template.getTemplateId()) && Validator.isNotNull((String)structureId)) {
            JournalStructure structure = this.journalStructureLocalService.getStructure(groupId, structureId, true);
            ddmTemplate.setClassPK(structure.getPrimaryKey());
            this.ddmTemplatePersistence.update((BaseModel)ddmTemplate);
        }
        return new JournalTemplateAdapter(ddmTemplate);
    }

    protected JournalTemplate doGetTemplate(long groupId, String templateId) throws PortalException, SystemException {
        DDMTemplate ddmTemplate = this.getDDMTemplate(groupId, templateId);
        return new JournalTemplateAdapter(ddmTemplate);
    }

    protected List<JournalTemplate> doGetTemplates(long groupId) throws SystemException {
        return this.doGetTemplates(groupId, -1, -1);
    }

    protected List<JournalTemplate> doGetTemplates(long groupId, int start, int end) throws SystemException {
        List ddmTemplates = this.ddmTemplateFinder.findByG_C_C_SC(groupId, PortalUtil.getClassNameId(DDMStructure.class), 0L, PortalUtil.getClassNameId(JournalArticle.class), start, end, null);
        return JournalUtil.toJournalTemplates(ddmTemplates);
    }

    protected int doGetTemplatesCount(long groupId) throws SystemException {
        return this.ddmTemplateFinder.countByG_C_C_SC(groupId, PortalUtil.getClassNameId(DDMStructure.class), 0L, PortalUtil.getClassNameId(JournalArticle.class));
    }

    protected DDMTemplate fetchDDMTemplate(long groupId, String templateId) throws SystemException {
        return this.ddmTemplateLocalService.fetchTemplate(groupId, PortalUtil.getClassNameId(DDMStructure.class), templateId);
    }

    protected JournalTemplate fetchTemplate(long groupId, String templateId) throws SystemException {
        DDMTemplate ddmTemplate = this.fetchDDMTemplate(groupId, templateId);
        if (ddmTemplate != null) {
            return new JournalTemplateAdapter(ddmTemplate);
        }
        return null;
    }

    protected DDMTemplate getDDMTemplate(JournalTemplate template) throws PortalException, SystemException {
        return this.getDDMTemplate(template.getGroupId(), template.getTemplateId());
    }

    protected DDMTemplate getDDMTemplate(long groupId, String templateId) throws PortalException, SystemException {
        try {
            return this.ddmTemplateLocalService.getTemplate(groupId, PortalUtil.getClassNameId(DDMStructure.class), templateId);
        }
        catch (PortalException pe) {
            throw new NoSuchTemplateException((Throwable)pe);
        }
    }

    protected String getUuid(JournalTemplate template) {
        String uuid = template.getUuid();
        if (Validator.isNotNull((String)uuid)) {
            return uuid;
        }
        return PortalUUIDUtil.generate();
    }

    protected JournalTemplate updateTemplate(JournalTemplate template) throws PortalException, SystemException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        String uuid = this.getUuid(template);
        serviceContext.setUuid(uuid);
        if (template.isNew()) {
            return this.addTemplate(template.getUserId(), template.getGroupId(), template.getTemplateId(), false, template.getStructureId(), template.getNameMap(), template.getDescriptionMap(), template.getXsl(), true, template.getLangType(), template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), template.getSmallImageFile(), serviceContext);
        }
        return this.updateTemplate(template.getGroupId(), template.getTemplateId(), template.getStructureId(), template.getNameMap(), template.getDescriptionMap(), template.getXsl(), true, template.getLangType(), template.isCacheable(), template.isSmallImage(), template.getSmallImageURL(), template.getSmallImageFile(), serviceContext);
    }

    protected void validateTemplateId(String templateId) throws PortalException {
        if (Validator.isNull((String)templateId) || Validator.isNumber((String)templateId) || templateId.indexOf(32) != -1) {
            throw new TemplateIdException();
        }
    }
}

