/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.dynamicdatamapping.StructureXsdException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.journal.DuplicateStructureIdException;
import com.liferay.portlet.journal.NoSuchStructureException;
import com.liferay.portlet.journal.StructureIdException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalStructureAdapter;
import com.liferay.portlet.journal.service.base.JournalStructureLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalConverterUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JournalStructureLocalServiceImpl
extends JournalStructureLocalServiceBaseImpl {
    public JournalStructure addJournalStructure(JournalStructure structure) throws PortalException, SystemException {
        structure.setNew(true);
        return this.updateStructure(structure);
    }

    public JournalStructure addStructure(long userId, long groupId, String structureId, boolean autoStructureId, String parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            xsd = JournalConverterUtil.getDDMXSD((String)xsd);
        }
        catch (Exception e2) {
            throw new StructureXsdException((Throwable)e2);
        }
        if (autoStructureId) {
            structureId = null;
        }
        DDMStructure ddmStructure = this.ddmStructureLocalService.addStructure(userId, groupId, parentStructureId, PortalUtil.getClassNameId(JournalArticle.class), structureId, nameMap, descriptionMap, xsd, PropsValues.JOURNAL_ARTICLE_STORAGE_TYPE, 0, serviceContext);
        return new JournalStructureAdapter(ddmStructure);
    }

    public void addStructureResources(JournalStructure structure, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DDMStructure dmmStructure = this.getDDMStructure(structure);
        this.ddmStructureLocalService.addStructureResources(dmmStructure, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(JournalStructure structure, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DDMStructure dmmStructure = this.getDDMStructure(structure);
        this.ddmStructureLocalService.addStructureResources(dmmStructure, groupPermissions, guestPermissions);
    }

    public void addStructureResources(long groupId, String structureId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        JournalStructure structure = this.doGetStructure(groupId, structureId);
        this.addStructureResources(structure, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(long groupId, String structureId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        JournalStructure structure = this.doGetStructure(groupId, structureId);
        this.addStructureResources(structure, groupPermissions, guestPermissions);
    }

    public void checkNewLine(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructure structure = this.doGetStructure(groupId, structureId);
        String xsd = structure.getXsd();
        if (xsd != null && xsd.contains("\\n")) {
            xsd = StringUtil.replace((String)xsd, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            structure.setXsd(xsd);
            this.updateStructure(structure);
        }
    }

    public JournalStructure copyStructure(long userId, long groupId, String oldStructureId, String newStructureId, boolean autoStructureId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldStructureId = oldStructureId.trim().toUpperCase();
        newStructureId = newStructureId.trim().toUpperCase();
        Date now = new Date();
        JournalStructure oldStructure = this.doGetStructure(groupId, oldStructureId);
        if (autoStructureId) {
            newStructureId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validateStructureId(newStructureId);
            JournalStructure newStructure = this.fetchStructure(groupId, newStructureId);
            if (newStructure != null) {
                throw new DuplicateStructureIdException();
            }
        }
        long id = this.counterLocalService.increment();
        JournalStructure newStructure = this.createJournalStructure(id);
        newStructure.setGroupId(groupId);
        newStructure.setCompanyId(user.getCompanyId());
        newStructure.setUserId(user.getUserId());
        newStructure.setUserName(user.getFullName());
        newStructure.setCreateDate(now);
        newStructure.setModifiedDate(now);
        newStructure.setStructureId(newStructureId);
        newStructure.setNameMap(oldStructure.getNameMap());
        newStructure.setDescriptionMap(oldStructure.getDescriptionMap());
        newStructure.setXsd(oldStructure.getXsd());
        newStructure.setExpandoBridgeAttributes(oldStructure);
        return this.updateStructure(newStructure);
    }

    public JournalStructure createJournalStructure(long id) throws SystemException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.createDDMStructure(id);
        return new JournalStructureAdapter(ddmStructure);
    }

    public void deleteStructure(JournalStructure structure) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.getDDMStructure(structure);
        this.ddmStructureLocalService.deleteDDMStructure(ddmStructure);
    }

    public void deleteStructure(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructure structure = this.doGetStructure(groupId, structureId);
        this.deleteStructure(structure);
    }

    public void deleteStructures(long groupId) throws PortalException, SystemException {
        List<JournalStructure> structures = this.doGetStructures(groupId, -1, -1);
        for (JournalStructure structure : structures) {
            this.deleteStructure(structure);
        }
    }

    public JournalStructure fetchStructure(long groupId, String structureId) throws SystemException {
        DDMStructure ddmStructure = this.fetchDDMStructure(groupId, structureId);
        if (ddmStructure != null) {
            return new JournalStructureAdapter(ddmStructure);
        }
        return null;
    }

    public List<JournalStructure> findAll() throws SystemException {
        List ddmStructures = this.ddmStructureLocalService.getClassStructures(PortalUtil.getClassNameId(JournalArticle.class));
        return JournalUtil.toJournalStructures(ddmStructures);
    }

    public JournalStructure getStructure(long groupId, String structureId) throws PortalException, SystemException {
        return this.getStructure(groupId, structureId, false);
    }

    public JournalStructure getStructure(long groupId, String structureId, boolean includeGlobalStructures) throws PortalException, SystemException {
        JournalStructure structure = this.fetchStructure(groupId, structureId = structureId.trim().toUpperCase());
        if (structure != null) {
            return structure;
        }
        if (!includeGlobalStructures) {
            throw new NoSuchStructureException("No JournalStructure exists with the structure ID " + structureId);
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
        return this.doGetStructure(companyGroup.getGroupId(), structureId);
    }

    public List<JournalStructure> getStructures() throws SystemException {
        return this.findAll();
    }

    public List<JournalStructure> getStructures(long groupId) throws SystemException {
        return this.doGetStructures(groupId);
    }

    public List<JournalStructure> getStructures(long groupId, int start, int end) throws SystemException {
        return this.doGetStructures(groupId, start, end);
    }

    public int getStructuresCount(long groupId) throws SystemException {
        return this.doGetStructuresCount(groupId);
    }

    public List<JournalStructure> search(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator obc) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(JournalArticle.class)};
        List ddmStructures = this.ddmStructureFinder.findByKeywords(companyId, groupIds, classNameIds, keywords, start, end, obc);
        return JournalUtil.toJournalStructures(ddmStructures);
    }

    public List<JournalStructure> search(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(JournalArticle.class)};
        List ddmStructures = this.ddmStructureFinder.findByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, null, 0, andOperator, start, end, obc);
        return JournalUtil.toJournalStructures(ddmStructures);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(JournalArticle.class)};
        return this.ddmStructureFinder.countByKeywords(companyId, groupIds, classNameIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(JournalArticle.class)};
        return this.ddmStructureFinder.countByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, null, 0, andOperator);
    }

    public JournalStructure updateJournalStructure(JournalStructure structure) throws PortalException, SystemException {
        return this.updateStructure(structure);
    }

    public JournalStructure updateStructure(long groupId, String structureId, String parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.getDDMStructure(groupId, structureId);
        long parentDDMStructureId = this.getParentDDMStructureId(groupId, parentStructureId);
        try {
            xsd = JournalConverterUtil.getDDMXSD((String)xsd);
        }
        catch (Exception e2) {
            throw new StructureXsdException((Throwable)e2);
        }
        ddmStructure = this.ddmStructureLocalService.updateStructure(ddmStructure.getStructureId(), parentDDMStructureId, nameMap, descriptionMap, xsd, serviceContext);
        return new JournalStructureAdapter(ddmStructure);
    }

    protected JournalStructure doGetStructure(long groupId, String structureId) throws PortalException, SystemException {
        DDMStructure ddmStructure = this.getDDMStructure(groupId, structureId);
        return new JournalStructureAdapter(ddmStructure);
    }

    protected List<JournalStructure> doGetStructures(long groupId) throws SystemException {
        return this.doGetStructures(groupId, -1, -1);
    }

    protected List<JournalStructure> doGetStructures(long groupId, int start, int end) throws SystemException {
        List ddmStructures = this.ddmStructureLocalService.getStructures(groupId, PortalUtil.getClassNameId(JournalArticle.class), start, end);
        return JournalUtil.toJournalStructures(ddmStructures);
    }

    protected int doGetStructuresCount(long groupId) throws SystemException {
        return this.ddmStructureLocalService.getStructuresCount(groupId, PortalUtil.getClassNameId(JournalArticle.class));
    }

    protected DDMStructure fetchDDMStructure(JournalStructure structure) throws SystemException {
        return this.fetchDDMStructure(structure.getGroupId(), structure.getStructureId());
    }

    protected DDMStructure fetchDDMStructure(long groupId, String structureId) throws SystemException {
        return this.ddmStructureLocalService.fetchStructure(groupId, PortalUtil.getClassNameId(JournalArticle.class), structureId);
    }

    protected DDMStructure getDDMStructure(JournalStructure structure) throws PortalException, SystemException {
        return this.getDDMStructure(structure.getGroupId(), structure.getStructureId());
    }

    protected DDMStructure getDDMStructure(long groupId, String structureId) throws PortalException, SystemException {
        try {
            return this.ddmStructureLocalService.getStructure(groupId, PortalUtil.getClassNameId(JournalArticle.class), structureId);
        }
        catch (PortalException pe) {
            throw new NoSuchStructureException((Throwable)pe);
        }
    }

    protected long getParentDDMStructureId(long groupId, String parentStructureId) throws SystemException {
        DDMStructure parentDDMStructure = this.fetchDDMStructure(groupId, parentStructureId);
        if (parentDDMStructure != null) {
            return parentDDMStructure.getStructureId();
        }
        return 0L;
    }

    protected String getUuid(JournalStructure structure) {
        String uuid = structure.getUuid();
        if (Validator.isNotNull((String)uuid)) {
            return uuid;
        }
        return PortalUUIDUtil.generate();
    }

    protected JournalStructure updateStructure(JournalStructure structure) throws PortalException, SystemException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        String uuid = this.getUuid(structure);
        serviceContext.setUuid(uuid);
        if (structure.isNew()) {
            return this.addStructure(structure.getUserId(), structure.getGroupId(), structure.getStructureId(), false, structure.getParentStructureId(), structure.getNameMap(), structure.getDescriptionMap(), structure.getXsd(), serviceContext);
        }
        return this.updateStructure(structure.getGroupId(), structure.getStructureId(), structure.getParentStructureId(), structure.getNameMap(), structure.getDescriptionMap(), structure.getXsd(), serviceContext);
    }

    protected void validateStructureId(String structureId) throws PortalException {
        if (Validator.isNull((String)structureId) || Validator.isNumber((String)structureId) || structureId.indexOf(32) != -1) {
            throw new StructureIdException();
        }
    }
}

