/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalStructureSoap;
import com.liferay.portlet.journal.service.JournalStructureServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class JournalStructureServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(JournalStructureServiceSoap.class);

    public static JournalStructureSoap addStructure(long groupId, String structureId, boolean autoStructureId, String parentStructureId, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String xsd, ServiceContext serviceContext) throws RemoteException {
        try {
            Map nameMap = LocalizationUtil.getLocalizationMap((String[])nameMapLanguageIds, (String[])nameMapValues);
            Map descriptionMap = LocalizationUtil.getLocalizationMap((String[])descriptionMapLanguageIds, (String[])descriptionMapValues);
            JournalStructure returnValue = JournalStructureServiceUtil.addStructure((long)groupId, (String)structureId, (boolean)autoStructureId, (String)parentStructureId, (Map)nameMap, (Map)descriptionMap, (String)xsd, (ServiceContext)serviceContext);
            return JournalStructureSoap.toSoapModel((JournalStructure)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static JournalStructureSoap copyStructure(long groupId, String oldStructureId, String newStructureId, boolean autoStructureId) throws RemoteException {
        try {
            JournalStructure returnValue = JournalStructureServiceUtil.copyStructure((long)groupId, (String)oldStructureId, (String)newStructureId, (boolean)autoStructureId);
            return JournalStructureSoap.toSoapModel((JournalStructure)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void deleteStructure(long groupId, String structureId) throws RemoteException {
        try {
            JournalStructureServiceUtil.deleteStructure((long)groupId, (String)structureId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static JournalStructureSoap getStructure(long groupId, String structureId) throws RemoteException {
        try {
            JournalStructure returnValue = JournalStructureServiceUtil.getStructure((long)groupId, (String)structureId);
            return JournalStructureSoap.toSoapModel((JournalStructure)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static JournalStructureSoap getStructure(long groupId, String structureId, boolean includeGlobalStructures) throws RemoteException {
        try {
            JournalStructure returnValue = JournalStructureServiceUtil.getStructure((long)groupId, (String)structureId, (boolean)includeGlobalStructures);
            return JournalStructureSoap.toSoapModel((JournalStructure)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static JournalStructureSoap[] getStructures(long groupId) throws RemoteException {
        try {
            List returnValue = JournalStructureServiceUtil.getStructures((long)groupId);
            return JournalStructureSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static JournalStructureSoap[] getStructures(long[] groupIds) throws RemoteException {
        try {
            List returnValue = JournalStructureServiceUtil.getStructures((long[])groupIds);
            return JournalStructureSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static JournalStructureSoap[] search(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = JournalStructureServiceUtil.search((long)companyId, (long[])groupIds, (String)keywords, (int)start, (int)end, (OrderByComparator)obc);
            return JournalStructureSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static JournalStructureSoap[] search(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = JournalStructureServiceUtil.search((long)companyId, (long[])groupIds, (String)structureId, (String)name, (String)description, (boolean)andOperator, (int)start, (int)end, (OrderByComparator)obc);
            return JournalStructureSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static int searchCount(long companyId, long[] groupIds, String keywords) throws RemoteException {
        try {
            int returnValue = JournalStructureServiceUtil.searchCount((long)companyId, (long[])groupIds, (String)keywords);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static int searchCount(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator) throws RemoteException {
        try {
            int returnValue = JournalStructureServiceUtil.searchCount((long)companyId, (long[])groupIds, (String)structureId, (String)name, (String)description, (boolean)andOperator);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static JournalStructureSoap updateStructure(long groupId, String structureId, String parentStructureId, String[] nameMapLanguageIds, String[] nameMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String xsd, ServiceContext serviceContext) throws RemoteException {
        try {
            Map nameMap = LocalizationUtil.getLocalizationMap((String[])nameMapLanguageIds, (String[])nameMapValues);
            Map descriptionMap = LocalizationUtil.getLocalizationMap((String[])descriptionMapLanguageIds, (String[])descriptionMapValues);
            JournalStructure returnValue = JournalStructureServiceUtil.updateStructure((long)groupId, (String)structureId, (String)parentStructureId, (Map)nameMap, (Map)descriptionMap, (String)xsd, (ServiceContext)serviceContext);
            return JournalStructureSoap.toSoapModel((JournalStructure)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }
}

