/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.model.impl;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.model.impl.JournalArticleBaseImpl;
import com.liferay.portlet.journal.model.impl.JournalFolderImpl;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.util.LocaleTransformerListener;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class JournalArticleImpl
extends JournalArticleBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(JournalArticleImpl.class);
    private String _smallImageType;

    public static String getContentByLocale(String content, boolean templateDriven, String languageId) {
        LocaleTransformerListener transformerListener = new LocaleTransformerListener();
        return transformerListener.onXml(content, languageId, null);
    }

    public String getArticleImageURL(ThemeDisplay themeDisplay) {
        if (!this.isSmallImage()) {
            return null;
        }
        if (Validator.isNotNull((String)this.getSmallImageURL())) {
            return this.getSmallImageURL();
        }
        return String.valueOf(themeDisplay.getPathImage()) + "/journal/article?img_id=" + this.getSmallImageId() + "&t=" + WebServerServletTokenUtil.getToken((long)this.getSmallImageId());
    }

    public JournalArticleResource getArticleResource() throws PortalException, SystemException {
        return JournalArticleResourceLocalServiceUtil.getArticleResource((long)this.getResourcePrimKey());
    }

    public String getArticleResourceUuid() throws PortalException, SystemException {
        JournalArticleResource articleResource = this.getArticleResource();
        return articleResource.getUuid();
    }

    public String[] getAvailableLocales() {
        String[] stringArray;
        TreeSet<String> availableLocales = new TreeSet<String>();
        Map<Locale, String> titleMap = this.getTitleMap();
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            Locale locale = entry.getKey();
            String value = entry.getValue();
            if (!Validator.isNotNull((String)value)) continue;
            availableLocales.add(locale.toString());
        }
        Map<Locale, String> descriptionMap = this.getDescriptionMap();
        for (Map.Entry entry : descriptionMap.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            String value = (String)entry.getValue();
            if (!Validator.isNotNull((String)value)) continue;
            availableLocales.add(locale.toString());
        }
        String[] stringArray2 = stringArray = LocalizationUtil.getAvailableLocales((String)this.getContent());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String availableLocale = stringArray2[n2];
            availableLocales.add(availableLocale);
            ++n2;
        }
        return availableLocales.toArray(new String[availableLocales.size()]);
    }

    public String getContentByLocale(String languageId) {
        return JournalArticleImpl.getContentByLocale(this.getContent(), this.isTemplateDriven(), languageId);
    }

    public String getDefaultLocale() {
        String xml = this.getContent();
        if (xml == null) {
            return "";
        }
        String defaultLanguageId = LocalizationUtil.getDefaultLocale((String)xml);
        if (this.isTemplateDriven() && Validator.isNull((String)defaultLanguageId)) {
            defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        }
        return defaultLanguageId;
    }

    public JournalFolder getFolder() {
        JournalFolderImpl folder = null;
        if (this.getFolderId() > 0L) {
            try {
                folder = JournalFolderLocalServiceUtil.getFolder((long)this.getFolderId());
            }
            catch (Exception e2) {
                folder = new JournalFolderImpl();
                _log.error((Throwable)e2);
            }
        } else {
            folder = new JournalFolderImpl();
        }
        return folder;
    }

    public String getSmallImageType() throws PortalException, SystemException {
        if (this._smallImageType == null && this.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.getImage((long)this.getSmallImageId());
            this._smallImageType = smallImage.getType();
        }
        return this._smallImageType;
    }

    @Override
    public Map<Locale, String> getTitleMap() {
        Locale defaultLocale = LocaleThreadLocal.getDefaultLocale();
        try {
            Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)this.getDefaultLocale());
            LocaleThreadLocal.setDefaultLocale((Locale)articleDefaultLocale);
            Map<Locale, String> map = super.getTitleMap();
            return map;
        }
        finally {
            LocaleThreadLocal.setDefaultLocale((Locale)defaultLocale);
        }
    }

    public JournalFolder getTrashContainer() {
        JournalFolder folder = this.getFolder();
        if (folder.isInTrash()) {
            return folder;
        }
        return folder.getTrashContainer();
    }

    public boolean isInTrashContainer() {
        return this.getTrashContainer() != null;
    }

    public boolean isTemplateDriven() {
        return !Validator.isNull((String)this.getStructureId());
    }

    @Override
    public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
    }

    public void setSmallImageType(String smallImageType) {
        this._smallImageType = smallImageType;
    }
}

