/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalFolderUtil;
import java.util.Map;

public class JournalFolderStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalFolder> {
    public static final String[] CLASS_NAMES = new String[]{JournalFolder.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(JournalFolder folder) {
        return folder.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder.getParentFolder());
        }
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder);
        portletDataContext.addClassedModel(folderElement, ExportImportPathUtil.getModelPath((StagedModel)folder), (ClassedModel)folder, "journal");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(JournalFolder.class);
        if (folder.getParentFolderId() != 0L) {
            String path = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)JournalFolder.class.getName(), (long)folder.getParentFolderId());
            JournalFolder parentFolder = (JournalFolder)portletDataContext.getZipEntryAsObject(path);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)parentFolder);
        }
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder, "journal");
        JournalFolder importedFolder = null;
        long groupId = portletDataContext.getScopeGroupId();
        if (portletDataContext.isDataStrategyMirror()) {
            JournalFolder existingFolder = JournalFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)groupId);
            if (existingFolder == null) {
                serviceContext.setUuid(folder.getUuid());
                importedFolder = JournalFolderLocalServiceUtil.addFolder((long)userId, (long)groupId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedFolder = JournalFolderLocalServiceUtil.updateFolder((long)userId, (long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedFolder = JournalFolderLocalServiceUtil.addFolder((long)userId, (long)groupId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, "journal");
    }
}

