/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.journal.FeedTargetLayoutFriendlyUrlException;
import com.liferay.portlet.journal.lar.JournalCreationStrategy;
import com.liferay.portlet.journal.lar.JournalCreationStrategyFactory;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.JournalFeedLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalFeedUtil;
import java.util.List;
import java.util.Map;

public class JournalFeedStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalFeed> {
    public static final String[] CLASS_NAMES = new String[]{JournalFeed.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(JournalFeedStagedModelDataHandler.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalFeed feed) throws Exception {
        Element feedElement = portletDataContext.getExportDataElement((ClassedModel)feed);
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)feed.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)feed.getStructureId(), (boolean)true);
        if (ddmStructure != null) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
            portletDataContext.addReferenceElement((StagedModel)feed, feedElement, (ClassedModel)ddmStructure, "strong", false);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM structure with key " + feed.getStructureId()));
        }
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)feed.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)feed.getTemplateId());
        if (ddmTemplate != null) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
            portletDataContext.addReferenceElement((StagedModel)feed, feedElement, (ClassedModel)ddmTemplate, "strong", false);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM template with key " + feed.getTemplateId()));
        }
        DDMTemplate rendererDDMTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)feed.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)feed.getRendererTemplateId());
        if (rendererDDMTemplate != null) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)rendererDDMTemplate);
            Element rendererDDMTemplateElement = portletDataContext.addReferenceElement((StagedModel)feed, feedElement, (ClassedModel)rendererDDMTemplate, "strong", false);
            rendererDDMTemplateElement.addAttribute("rendererDDMTemplate", "true");
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find DDM template with key " + feed.getRendererTemplateId()));
        }
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL().substring(1);
        String[] friendlyURLParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (char)'/');
        String oldGroupFriendlyURL = friendlyURLParts[2];
        if (newGroupFriendlyURL.equals(oldGroupFriendlyURL)) {
            String targetLayoutFriendlyUrl = StringUtil.replaceFirst((String)feed.getTargetLayoutFriendlyUrl(), (String)("/" + newGroupFriendlyURL + "/"), (String)"/@data_handler_group_friendly_url@/");
            feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        }
        portletDataContext.addClassedModel(feedElement, ExportImportPathUtil.getModelPath((StagedModel)feed), (ClassedModel)feed, "journal");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalFeed feed) throws Exception {
        block13: {
            StringBundler sb;
            long userId = portletDataContext.getUserId(feed.getUserUuid());
            JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
            long authorId = creationStrategy.getAuthorUserId(portletDataContext, feed);
            if (authorId != 0L) {
                userId = authorId;
            }
            Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
            String newGroupFriendlyURL = group.getFriendlyURL().substring(1);
            String[] friendlyURLParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (char)'/');
            String oldGroupFriendlyURL = friendlyURLParts[2];
            if (oldGroupFriendlyURL.equals("@data_handler_group_friendly_url@")) {
                feed.setTargetLayoutFriendlyUrl(StringUtil.replace((String)feed.getTargetLayoutFriendlyUrl(), (String)"@data_handler_group_friendly_url@", (String)newGroupFriendlyURL));
            }
            String feedId = feed.getFeedId();
            boolean autoFeedId = false;
            if (Validator.isNumber((String)feedId) || JournalFeedUtil.fetchByG_F((long)portletDataContext.getScopeGroupId(), (String)feedId) != null) {
                autoFeedId = true;
            }
            List ddmStructureElements = portletDataContext.getReferenceDataElements((StagedModel)feed, DDMStructure.class);
            String parentDDMStructureKey = "";
            if (!ddmStructureElements.isEmpty()) {
                Element ddmStructureElement = (Element)ddmStructureElements.get(0);
                String ddmStructurePath = ddmStructureElement.attributeValue("path");
                DDMStructure ddmStructure = (DDMStructure)portletDataContext.getZipEntryAsObject(ddmStructurePath);
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
                Map ddmStructureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
                parentDDMStructureKey = MapUtil.getString((Map)ddmStructureKeys, (String)ddmStructure.getStructureKey(), (String)ddmStructure.getStructureKey());
            }
            List ddmTemplateElements = portletDataContext.getReferenceDataElements((StagedModel)feed, DDMTemplate.class);
            String parentDDMTemplateKey = "";
            String parentRendererDDMTemplateKey = "";
            for (Element ddmTemplateElement : ddmTemplateElements) {
                String ddmTemplatePath = ddmTemplateElement.attributeValue("path");
                DDMTemplate ddmTemplate = (DDMTemplate)portletDataContext.getZipEntryAsObject(ddmTemplatePath);
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
                Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
                boolean rendererDDMTemplate = GetterUtil.getBoolean((String)ddmTemplateElement.attributeValue("rendererDDMTemplate"));
                String ddmTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)ddmTemplate.getTemplateKey(), (String)ddmTemplate.getTemplateKey());
                if (rendererDDMTemplate) {
                    parentDDMTemplateKey = ddmTemplateKey;
                    continue;
                }
                parentRendererDDMTemplateKey = ddmTemplateKey;
            }
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)feed, "journal");
            boolean addGroupPermissions = creationStrategy.addGroupPermissions(portletDataContext, feed);
            serviceContext.setAddGroupPermissions(addGroupPermissions);
            boolean addGuestPermissions = creationStrategy.addGuestPermissions(portletDataContext, feed);
            serviceContext.setAddGuestPermissions(addGuestPermissions);
            JournalFeed importedFeed = null;
            try {
                if (portletDataContext.isDataStrategyMirror()) {
                    JournalFeed existingFeed = JournalFeedUtil.fetchByUUID_G((String)feed.getUuid(), (long)portletDataContext.getScopeGroupId());
                    if (existingFeed == null) {
                        serviceContext.setUuid(feed.getUuid());
                        importedFeed = JournalFeedLocalServiceUtil.addFeed((long)userId, (long)portletDataContext.getScopeGroupId(), (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)parentRendererDDMTemplateKey, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedFormat(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                    } else {
                        importedFeed = JournalFeedLocalServiceUtil.updateFeed((long)existingFeed.getGroupId(), (String)existingFeed.getFeedId(), (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)parentRendererDDMTemplateKey, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedFormat(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                    }
                } else {
                    importedFeed = JournalFeedLocalServiceUtil.addFeed((long)userId, (long)portletDataContext.getScopeGroupId(), (String)feedId, (boolean)autoFeedId, (String)feed.getName(), (String)feed.getDescription(), (String)feed.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)parentRendererDDMTemplateKey, (int)feed.getDelta(), (String)feed.getOrderByCol(), (String)feed.getOrderByType(), (String)feed.getTargetLayoutFriendlyUrl(), (String)feed.getTargetPortletId(), (String)feed.getContentField(), (String)feed.getFeedFormat(), (double)feed.getFeedVersion(), (ServiceContext)serviceContext);
                }
                portletDataContext.importClassedModel((ClassedModel)feed, (ClassedModel)importedFeed, "journal");
                if (!feedId.equals(importedFeed.getFeedId()) && _log.isWarnEnabled()) {
                    sb = new StringBundler(5);
                    sb.append("A feed with the ID ");
                    sb.append(feedId);
                    sb.append(" already exists. The new generated ID is ");
                    sb.append(importedFeed.getFeedId());
                    sb.append(".");
                    _log.warn((Object)sb.toString());
                }
            }
            catch (FeedTargetLayoutFriendlyUrlException feedTargetLayoutFriendlyUrlException) {
                if (!_log.isWarnEnabled()) break block13;
                sb = new StringBundler(6);
                sb.append("A feed with the ID ");
                sb.append(feedId);
                sb.append(" cannot be imported because layout with friendly ");
                sb.append("URL ");
                sb.append(feed.getTargetLayoutFriendlyUrl());
                sb.append(" does not exist");
                _log.warn((Object)sb.toString());
            }
        }
    }
}

