/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandler;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.lar.JournalPortletDataHandler;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class JournalContentPortletDataHandler
extends JournalPortletDataHandler {
    private static Log _log = LogFactoryUtil.getLog(JournalContentPortletDataHandler.class);

    public JournalContentPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDataPortletPreferences(new String[]{"groupId", "articleId", "templateId"});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean("journal", "selected-web-content", true, true, null, JournalArticle.class.getName()), new PortletDataHandlerBoolean("journal", "embedded-assets")});
        DLPortletDataHandler dlPortletDataHandler = new DLPortletDataHandler();
        this.setExportMetadataControls((PortletDataHandlerControl[])ArrayUtil.append((Object[])this.getExportMetadataControls(), (Object[])dlPortletDataHandler.getExportMetadataControls()));
        this.setImportControls(new PortletDataHandlerControl[]{this.getExportControls()[0]});
        this.setPublishToLiveByDefault(true);
    }

    @Override
    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("groupId", "");
        portletPreferences.setValue("articleId", "");
        return portletPreferences;
    }

    @Override
    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.journal", portletDataContext.getScopeGroupId());
        String articleId = portletPreferences.getValue("articleId", null);
        if (articleId == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No article id found in preferences of portlet " + portletId));
            }
            return "";
        }
        long articleGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", ""));
        if (articleGroupId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No group id found in preferences of portlet " + portletId));
            }
            return "";
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        if (articleGroupId != portletDataContext.getScopeGroupId()) {
            portletDataContext.setScopeGroupId(articleGroupId);
        } else if (articleGroupId == portletDataContext.getSourceCompanyGroupId()) {
            portletDataContext.setScopeGroupId(portletDataContext.getCompanyGroupId());
        }
        JournalArticle article = null;
        try {
            article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (int)0);
        }
        catch (NoSuchArticleException noSuchArticleException) {}
        if (article == null) {
            try {
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (int)3);
            }
            catch (NoSuchArticleException noSuchArticleException) {}
        }
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (article == null) {
            portletDataContext.setScopeGroupId(previousScopeGroupId);
            return this.getExportDataRootElementString(rootElement);
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)article);
        String defaultTemplateId = article.getTemplateId();
        String preferenceTemplateId = portletPreferences.getValue("ddmTemplateKey", null);
        if (Validator.isNotNull((String)defaultTemplateId) && Validator.isNotNull((String)preferenceTemplateId) && !defaultTemplateId.equals(preferenceTemplateId)) {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)article.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)preferenceTemplateId, (boolean)true);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
            Element articleElement = portletDataContext.getExportDataElement((ClassedModel)article);
            portletDataContext.addReferenceElement((StagedModel)article, articleElement, (ClassedModel)ddmTemplate, "strong", false);
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return this.getExportDataRootElementString(rootElement);
    }

    @Override
    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        String articleId;
        portletDataContext.importPermissions("com.liferay.portlet.journal", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        long importGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", null));
        if (importGroupId == portletDataContext.getSourceGroupId()) {
            portletDataContext.setScopeGroupId(portletDataContext.getGroupId());
        }
        Element ddmStructuresElement = portletDataContext.getImportDataGroupElement(DDMStructure.class);
        List ddmStructureElements = ddmStructuresElement.elements();
        for (Element ddmStructureElement : ddmStructureElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmStructureElement);
        }
        Element ddmTemplatesElement = portletDataContext.getImportDataGroupElement(DDMTemplate.class);
        List ddmTemplateElements = ddmTemplatesElement.elements();
        for (Element ddmTemplateElement : ddmTemplateElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)ddmTemplateElement);
        }
        Element articlesElement = portletDataContext.getImportDataGroupElement(JournalArticle.class);
        List articleElements = articlesElement.elements();
        if (!articleElements.isEmpty()) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)((Element)articleElements.get(0)));
        }
        if (Validator.isNotNull((String)(articleId = portletPreferences.getValue("articleId", null)))) {
            Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
            articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
            portletPreferences.setValue("articleId", articleId);
            String importedArticleGroupId = String.valueOf(portletDataContext.getScopeGroupId());
            portletPreferences.setValue("groupId", importedArticleGroupId);
            Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getPlid());
            JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)articleId, (boolean)true);
        } else {
            portletPreferences.setValue("groupId", "");
            portletPreferences.setValue("articleId", "");
        }
        String ddmTemplateKey = portletPreferences.getValue("ddmTemplateKey", null);
        if (Validator.isNotNull((String)ddmTemplateKey)) {
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            ddmTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)ddmTemplateKey, (String)ddmTemplateKey);
            portletPreferences.setValue("ddmTemplateKey", ddmTemplateKey);
        } else {
            portletPreferences.setValue("ddmTemplateKey", "");
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return portletPreferences;
    }
}

