/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMTemplateUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.lar.JournalCreationStrategy;
import com.liferay.portlet.journal.lar.JournalCreationStrategyFactory;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleImage;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleImageUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleResourceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class JournalArticleStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalArticle> {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(JournalArticleStagedModelDataHandler.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(JournalArticle article) {
        return article.getTitleCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        if (article.getStatus() != 0 && article.getStatus() != 3) {
            return;
        }
        Element articleElement = portletDataContext.getExportDataElement((ClassedModel)article);
        articleElement.addAttribute("article-resource-uuid", article.getArticleResourceUuid());
        if (article.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)article.getFolder());
        }
        if (Validator.isNotNull((String)article.getStructureId())) {
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)article.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)article.getStructureId(), (boolean)true);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
            portletDataContext.addReferenceElement((StagedModel)article, articleElement, (ClassedModel)ddmStructure, "strong", false);
            long parentStructureId = ddmStructure.getParentStructureId();
            while (parentStructureId > 0L) {
                DDMStructure parentStructure = DDMStructureLocalServiceUtil.getStructure((long)parentStructureId);
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)parentStructure);
                parentStructureId = parentStructure.getParentStructureId();
            }
        }
        if (Validator.isNotNull((String)article.getTemplateId())) {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)article.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)article.getTemplateId(), (boolean)true);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
            portletDataContext.addReferenceElement((StagedModel)article, articleElement, (ClassedModel)ddmTemplate, "strong", false);
        }
        if (article.isSmallImage()) {
            Image smallImage = ImageUtil.fetchByPrimaryKey((long)article.getSmallImageId());
            if (Validator.isNotNull((String)article.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)article, (Element)articleElement, (String)article.getSmallImageURL().concat(" "), (boolean)true);
                article.setSmallImageURL(smallImageURL);
            } else if (smallImage != null) {
                String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)article, (String)(String.valueOf(smallImage.getImageId()) + "." + smallImage.getType()));
                articleElement.addAttribute("small-image-path", smallImagePath);
                article.setSmallImageType(smallImage.getType());
                portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
            }
        }
        List articleImages = JournalArticleImageUtil.findByG_A_V((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion());
        for (JournalArticleImage articleImage : articleImages) {
            this.exportArticleImage(portletDataContext, articleImage, article, articleElement);
        }
        article.setStatusByUserUuid(article.getStatusByUserUuid());
        String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)article, (Element)articleElement, (String)article.getContent(), (boolean)portletDataContext.getBooleanParameter("journal", "embedded-assets"));
        article.setContent(content);
        portletDataContext.addClassedModel(articleElement, ExportImportPathUtil.getModelPath((StagedModel)article), (ClassedModel)article, "journal");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        Map articleIds;
        String newArticleId;
        this.prepareLanguagesForImport(article);
        long userId = portletDataContext.getUserId(article.getUserUuid());
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(portletDataContext, article);
        if (authorId != 0L) {
            userId = authorId;
        }
        User user = UserLocalServiceUtil.getUser((long)userId);
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(JournalFolder.class);
        if (article.getFolderId() != 0L) {
            String folderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)JournalFolder.class.getName(), (long)article.getFolderId());
            JournalFolder folder = (JournalFolder)portletDataContext.getZipEntryAsObject(folderPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
        }
        long folderId = MapUtil.getLong((Map)folderIds, (long)article.getFolderId(), (long)article.getFolderId());
        String articleId = article.getArticleId();
        boolean autoArticleId = false;
        if (Validator.isNumber((String)articleId) || JournalArticleUtil.fetchByG_A_V((long)portletDataContext.getScopeGroupId(), (String)articleId, (double)1.0) != null) {
            autoArticleId = true;
        }
        if (Validator.isNotNull((String)(newArticleId = (String)(articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId")).get(articleId)))) {
            articleId = newArticleId;
            autoArticleId = false;
        }
        String content = article.getContent();
        Element articleElement = portletDataContext.getImportDataStagedModelElement((StagedModel)article);
        content = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)articleElement, (String)content, (boolean)true);
        article.setContent(content);
        String newContent = creationStrategy.getTransformedContent(portletDataContext, article);
        if (newContent != JournalCreationStrategy.ARTICLE_CONTENT_UNCHANGED) {
            article.setContent(newContent);
        }
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
        String parentDDMStructureKey = "";
        long ddmStructureId = 0L;
        List structureElements = portletDataContext.getReferenceDataElements((StagedModel)article, DDMStructure.class);
        if (!structureElements.isEmpty()) {
            Element structureElement = (Element)structureElements.get(0);
            String structurePath = structureElement.attributeValue("path");
            DDMStructure ddmStructure = (DDMStructure)portletDataContext.getZipEntryAsObject(structurePath);
            DDMStructure existingDDMStructure = DDMStructureUtil.fetchByUUID_G((String)ddmStructure.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingDDMStructure == null) {
                existingDDMStructure = DDMStructureUtil.fetchByUUID_G((String)ddmStructure.getUuid(), (long)companyGroup.getGroupId());
            }
            if (existingDDMStructure == null) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
                Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
                ddmStructureId = MapUtil.getLong((Map)ddmStructureIds, (long)ddmStructure.getStructureId(), (long)ddmStructure.getStructureId());
                existingDDMStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)ddmStructureId);
            }
            if (existingDDMStructure == null) {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler();
                    sb.append("Structure ");
                    sb.append(article.getStructureId());
                    sb.append(" is missing for article ");
                    sb.append(article.getArticleId());
                    sb.append(", skipping this article.");
                    _log.warn((Object)sb.toString());
                }
                return;
            }
            parentDDMStructureKey = existingDDMStructure.getStructureKey();
        }
        String parentDDMTemplateKey = "";
        List ddmTemplateElements = portletDataContext.getReferenceDataElements((StagedModel)article, DDMTemplate.class);
        if (!ddmTemplateElements.isEmpty()) {
            Element templateElement = (Element)ddmTemplateElements.get(0);
            String ddmTemplatePath = templateElement.attributeValue("path");
            DDMTemplate ddmTemplate = (DDMTemplate)portletDataContext.getZipEntryAsObject(ddmTemplatePath);
            DDMTemplate existingDDMTemplate = DDMTemplateUtil.fetchByUUID_G((String)ddmTemplate.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingDDMTemplate == null) {
                existingDDMTemplate = DDMTemplateUtil.fetchByUUID_G((String)ddmTemplate.getUuid(), (long)companyGroup.getGroupId());
            }
            if (existingDDMTemplate == null) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
                Map ddmTemplateIds = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class);
                long ddmTemplateId = MapUtil.getLong((Map)ddmTemplateIds, (long)ddmTemplate.getTemplateId(), (long)ddmTemplate.getTemplateId());
                existingDDMTemplate = DDMTemplateLocalServiceUtil.getDDMTemplate((long)ddmTemplateId);
            }
            if (existingDDMTemplate == null) {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler();
                    sb.append("Template ");
                    sb.append(article.getTemplateId());
                    sb.append(" is missing for article ");
                    sb.append(article.getArticleId());
                    sb.append(", skipping this article.");
                    _log.warn((Object)sb.toString());
                }
                return;
            }
            parentDDMTemplateKey = existingDDMTemplate.getTemplateKey();
        }
        File smallFile = null;
        if (article.isSmallImage()) {
            byte[] bytes;
            String smallImagePath = articleElement.attributeValue("small-image-path");
            if (Validator.isNotNull((String)article.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (Element)articleElement, (String)article.getSmallImageURL(), (boolean)true);
                article.setSmallImageURL(smallImageURL);
            } else if (Validator.isNotNull((String)smallImagePath) && (bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                smallFile = FileUtil.createTempFile((String)article.getSmallImageType());
                FileUtil.write((File)smallFile, (byte[])bytes);
            }
        }
        HashMap<String, byte[]> images = new HashMap<String, byte[]>();
        List imagesElements = portletDataContext.getReferenceDataElements((StagedModel)article, Image.class);
        for (Element imageElement : imagesElements) {
            String imagePath = imageElement.attributeValue("path");
            String fileName = imageElement.attributeValue("file-name");
            images.put(fileName, portletDataContext.getZipEntryAsByteArray(imagePath));
        }
        String articleURL = null;
        boolean addGroupPermissions = creationStrategy.addGroupPermissions(portletDataContext, article);
        boolean addGuestPermissions = creationStrategy.addGuestPermissions(portletDataContext, article);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)article, "journal");
        serviceContext.setAddGroupPermissions(addGroupPermissions);
        serviceContext.setAddGuestPermissions(addGuestPermissions);
        if (article.getStatus() != 0) {
            serviceContext.setWorkflowAction(2);
        }
        JournalArticle importedArticle = null;
        String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
        if (portletDataContext.isDataStrategyMirror()) {
            JournalArticleResource articleResource = JournalArticleResourceUtil.fetchByUUID_G((String)articleResourceUuid, (long)portletDataContext.getScopeGroupId());
            if (articleResource == null) {
                articleResource = JournalArticleResourceUtil.fetchByUUID_G((String)articleResourceUuid, (long)companyGroup.getGroupId());
            }
            serviceContext.setUuid(articleResourceUuid);
            serviceContext.setAttribute("urlTitle", (Serializable)((Object)article.getUrlTitle()));
            JournalArticle existingArticle = null;
            if (articleResource != null) {
                try {
                    existingArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)articleResource.getResourcePrimKey(), (int)-1, (boolean)false);
                }
                catch (NoSuchArticleException noSuchArticleException) {}
            }
            if (existingArticle == null) {
                existingArticle = JournalArticleUtil.fetchByG_A_V((long)portletDataContext.getScopeGroupId(), (String)newArticleId, (double)article.getVersion());
            }
            importedArticle = existingArticle == null ? JournalArticleLocalServiceUtil.addArticle((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (long)article.getClassNameId(), (long)ddmStructureId, (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)article.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext) : JournalArticleLocalServiceUtil.updateArticle((long)userId, (long)existingArticle.getGroupId(), (long)folderId, (String)existingArticle.getArticleId(), (double)article.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)article.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
        } else {
            importedArticle = JournalArticleLocalServiceUtil.addArticle((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (long)article.getClassNameId(), (long)ddmStructureId, (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)article.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
        }
        if (smallFile != null) {
            smallFile.delete();
        }
        portletDataContext.importClassedModel((ClassedModel)article, (ClassedModel)importedArticle, "journal");
        if (Validator.isNull((String)newArticleId)) {
            articleIds.put(article.getArticleId(), importedArticle.getArticleId());
        }
    }

    protected void exportArticleImage(PortletDataContext portletDataContext, JournalArticleImage articleImage, JournalArticle article, Element articleElement) throws SystemException {
        Image image = null;
        try {
            image = ImageUtil.findByPrimaryKey((long)articleImage.getArticleImageId());
            if (image.getTextObj() == null) {
                return;
            }
        }
        catch (NoSuchImageException noSuchImageException) {
            return;
        }
        String fileName = String.valueOf(image.getImageId()) + "." + image.getType();
        String articleImagePath = ExportImportPathUtil.getModelPath((StagedModel)article, (String)fileName);
        if (!portletDataContext.isPathNotProcessed(articleImagePath)) {
            return;
        }
        Element imageElement = portletDataContext.getExportDataElement((ClassedModel)image);
        imageElement.addAttribute("path", articleImagePath);
        if (Validator.isNotNull((String)fileName)) {
            imageElement.addAttribute("file-name", fileName);
        }
        portletDataContext.addZipEntry(articleImagePath, image.getTextObj());
        portletDataContext.addReferenceElement((StagedModel)article, articleElement, (ClassedModel)image, articleImagePath, false);
    }

    protected void prepareLanguagesForImport(JournalArticle article) throws PortalException {
        Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)article.getDefaultLocale());
        Locale[] articleAvailableLocales = LocaleUtil.fromLanguageIds((String[])article.getAvailableLocales());
        Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale((String)JournalArticle.class.getName(), (long)article.getPrimaryKey(), (Locale)articleDefaultLocale, (Locale[])articleAvailableLocales);
        article.prepareLocalizedFieldsForImport(defaultImportLocale);
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) {
        try {
            JournalArticle journalArticle = JournalArticleUtil.fetchByUUID_G((String)uuid, (long)groupId);
            return journalArticle != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

