/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMStructurePermission;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class JournalArticleAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "content";
    private static final boolean _LINKABLE = true;

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        JournalArticle article;
        block5: {
            article = null;
            try {
                article = JournalArticleLocalServiceUtil.getArticle((long)classPK);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                JournalArticleResource articleResource = JournalArticleResourceLocalServiceUtil.getArticleResource((long)classPK);
                boolean approvedArticleAvailable = true;
                if (type == 1) {
                    try {
                        article = JournalArticleLocalServiceUtil.getDisplayArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId());
                    }
                    catch (NoSuchArticleException noSuchArticleException2) {
                        approvedArticleAvailable = false;
                    }
                }
                if (type == 1 && approvedArticleAvailable) break block5;
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId(), (int)-1);
            }
        }
        JournalArticleAssetRenderer journalArticleAssetRenderer = new JournalArticleAssetRenderer(article);
        journalArticleAssetRenderer.setAssetRendererType(type);
        return journalArticleAssetRenderer;
    }

    public AssetRenderer getAssetRenderer(long groupId, String urlTitle) throws PortalException, SystemException {
        JournalArticle article = JournalArticleServiceUtil.getDisplayArticleByUrlTitle((long)groupId, (String)urlTitle);
        return new JournalArticleAssetRenderer(article);
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public List<Tuple> getClassTypeFieldNames(long classTypeId, Locale locale, int start, int end) throws Exception {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)classTypeId);
        List fieldNames = this.getDDMStructureFieldNames(ddmStructure, locale);
        if (start != -1 || end != -1) {
            fieldNames = ListUtil.subList((List)fieldNames, (int)start, (int)end);
        }
        return fieldNames;
    }

    public int getClassTypeFieldNamesCount(long classTypeId, Locale locale) throws Exception {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)classTypeId);
        List fieldNames = this.getDDMStructureFieldNames(ddmStructure, locale);
        return fieldNames.size();
    }

    public Map<Long, String> getClassTypes(long[] groupIds, Locale locale) throws Exception {
        HashMap<Long, String> classTypes = new HashMap<Long, String>();
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            List ddmStructures = DDMStructureLocalServiceUtil.getStructures((long)groupId, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()));
            for (DDMStructure ddmStructure : ddmStructures) {
                classTypes.put(ddmStructure.getStructureId(), ddmStructure.getName(locale));
            }
            ++n2;
        }
        return classTypes;
    }

    public String getType() {
        return TYPE;
    }

    public String getTypeName(Locale locale, boolean hasSubtypes) {
        if (hasSubtypes) {
            return LanguageUtil.get((Locale)locale, (String)"basic-web-content");
        }
        return super.getTypeName(locale, hasSubtypes);
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!JournalPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_ARTICLE")) {
            return null;
        }
        long classTypeId = GetterUtil.getLong((Object)liferayPortletRequest.getAttribute("ASSET_RENDERER_FACTORY_CLASS_TYPE_ID"));
        if (classTypeId > 0L && !DDMStructurePermission.contains(themeDisplay.getPermissionChecker(), classTypeId, "VIEW")) {
            return null;
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)"15", (long)this.getControlPanelPlid(themeDisplay), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        return portletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return JournalArticlePermission.contains(permissionChecker, classPK, actionId);
    }

    public boolean isLinkable() {
        return true;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

