/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.iframe.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.iframe.util.IFrameUtil;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ViewAction
extends PortletAction {
    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        String src = this.transformSrc(renderRequest, renderResponse);
        if (Validator.isNull((String)src) || src.equals("http://") || src.equals("https://")) {
            return mapping.findForward("/portal/portlet_not_setup");
        }
        renderRequest.setAttribute("IFRAME_SRC", (Object)src);
        return mapping.findForward("portlet.iframe.view");
    }

    protected String getPassword(RenderRequest renderRequest, RenderResponse renderResponse) throws PortalException, SystemException {
        PortletPreferences preferences = renderRequest.getPreferences();
        String password = preferences.getValue("basicPassword", "");
        return IFrameUtil.getPassword((PortletRequest)renderRequest, password);
    }

    protected String getSrc(RenderRequest renderRequest, RenderResponse renderResponse) {
        PortletPreferences preferences = renderRequest.getPreferences();
        String src = preferences.getValue("src", "");
        src = ParamUtil.getString((PortletRequest)renderRequest, (String)"src", (String)src);
        return src;
    }

    protected String getUserName(RenderRequest renderRequest, RenderResponse renderResponse) throws PortalException, SystemException {
        PortletPreferences preferences = renderRequest.getPreferences();
        String userName = preferences.getValue("basicUserName", "");
        return IFrameUtil.getUserName((PortletRequest)renderRequest, userName);
    }

    protected String transformSrc(RenderRequest renderRequest, RenderResponse renderResponse) throws PortalException, SystemException {
        PortletPreferences preferences = renderRequest.getPreferences();
        String src = this.getSrc(renderRequest, renderResponse);
        boolean auth = GetterUtil.getBoolean((String)preferences.getValue("auth", ""));
        if (!auth) {
            return src;
        }
        String authType = preferences.getValue("authType", "");
        if (authType.equals("basic")) {
            String userName = this.getUserName(renderRequest, renderResponse);
            String password = this.getPassword(renderRequest, renderResponse);
            int pos = src.indexOf("://");
            String protocol = src.substring(0, pos + 3);
            String url = src.substring(pos + 3);
            src = String.valueOf(protocol) + userName + ":" + password + "@" + url;
        } else {
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String portletId = PortalUtil.getPortletId((PortletRequest)renderRequest);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
            src = String.valueOf(themeDisplay.getPathMain()) + "/" + portlet.getStrutsPath() + "/proxy?p_l_id=" + themeDisplay.getPlid() + "&p_p_id=" + portletId;
        }
        return src;
    }
}

