/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.service.base.ExpandoValueServiceBaseImpl;
import com.liferay.portlet.expando.service.permission.ExpandoColumnPermissionUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class ExpandoValueServiceImpl
extends ExpandoValueServiceBaseImpl {
    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Object data) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        ExpandoColumnPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)column, (String)"UPDATE");
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, String data) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        ExpandoColumnPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)column, (String)"UPDATE");
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, data);
    }

    public void addValues(long companyId, String className, String tableName, long classPK, Map<String, Serializable> attributeValues) throws PortalException, SystemException {
        for (Map.Entry<String, Serializable> entry : attributeValues.entrySet()) {
            this.addValue(companyId, className, tableName, entry.getKey(), classPK, entry.getValue());
        }
    }

    public Map<String, Serializable> getData(long companyId, String className, String tableName, Collection<String> columnNames, long classPK) throws PortalException, SystemException {
        Map attributeValues = this.expandoValueLocalService.getData(companyId, className, tableName, columnNames, classPK);
        for (String columnName : columnNames) {
            ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
            if (ExpandoColumnPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)column, (String)"VIEW")) continue;
            attributeValues.remove(columnName);
        }
        return attributeValues;
    }

    public Serializable getData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (ExpandoColumnPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)column, (String)"VIEW")) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK);
        }
        return null;
    }

    public JSONObject getJSONData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (ExpandoColumnPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (ExpandoColumn)column, (String)"VIEW")) {
            String data = this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, "");
            if (Validator.isNotNull((String)data)) {
                if (!data.startsWith("{")) {
                    data = "{data:".concat(data).concat("}");
                }
                return JSONFactoryUtil.createJSONObject((String)data);
            }
            return null;
        }
        return null;
    }
}

