/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.ColumnNameException;
import com.liferay.portlet.expando.ColumnTypeException;
import com.liferay.portlet.expando.DuplicateColumnNameException;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.model.impl.ExpandoValueImpl;
import com.liferay.portlet.expando.service.base.ExpandoColumnLocalServiceBaseImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ExpandoColumnLocalServiceImpl
extends ExpandoColumnLocalServiceBaseImpl {
    public ExpandoColumn addColumn(long tableId, String name, int type) throws PortalException, SystemException {
        return this.addColumn(tableId, name, type, null);
    }

    public ExpandoColumn addColumn(long tableId, String name, int type, Object defaultData) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        ExpandoValue value = this.validate(0L, tableId, name, type, defaultData);
        long columnId = this.counterLocalService.increment();
        ExpandoColumn column = this.expandoColumnPersistence.create(columnId);
        column.setCompanyId(table.getCompanyId());
        column.setTableId(tableId);
        column.setName(name);
        column.setType(type);
        column.setDefaultData(value.getData());
        this.expandoColumnPersistence.update((BaseModel)column);
        this.resourceLocalService.addResources(table.getCompanyId(), 0L, 0L, ExpandoColumn.class.getName(), column.getColumnId(), false, false, false);
        return column;
    }

    public void deleteColumn(ExpandoColumn column) throws SystemException {
        this.expandoColumnPersistence.remove((BaseModel)column);
        this.expandoValueLocalService.deleteColumnValues(column.getColumnId());
    }

    public void deleteColumn(long columnId) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnPersistence.findByPrimaryKey(columnId);
        this.deleteColumn(column);
    }

    public void deleteColumn(long companyId, long classNameId, String tableName, String name) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, classNameId, tableName);
        this.deleteColumn(table.getTableId(), name);
    }

    public void deleteColumn(long tableId, String name) throws SystemException {
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(tableId, name);
        if (column != null) {
            this.expandoColumnPersistence.remove((BaseModel)column);
        }
    }

    public void deleteColumn(long companyId, String className, String tableName, String name) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteColumn(companyId, classNameId, tableName, name);
    }

    public void deleteColumns(long tableId) throws SystemException {
        List columns = this.expandoColumnPersistence.findByTableId(tableId);
        for (ExpandoColumn column : columns) {
            this.deleteColumn(column);
        }
    }

    public void deleteColumns(long companyId, long classNameId, String tableName) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, classNameId, tableName);
        this.deleteColumns(table.getTableId());
    }

    public void deleteColumns(long companyId, String className, String tableName) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteColumns(companyId, classNameId, tableName);
    }

    public ExpandoColumn getColumn(long columnId) throws PortalException, SystemException {
        return this.expandoColumnPersistence.findByPrimaryKey(columnId);
    }

    public ExpandoColumn getColumn(long companyId, long classNameId, String tableName, String name) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        return this.expandoColumnPersistence.fetchByT_N(table.getTableId(), name);
    }

    public ExpandoColumn getColumn(long tableId, String name) throws SystemException {
        return this.expandoColumnPersistence.fetchByT_N(tableId, name);
    }

    public ExpandoColumn getColumn(long companyId, String className, String tableName, String name) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumn(companyId, classNameId, tableName, name);
    }

    public List<ExpandoColumn> getColumns(long tableId) throws SystemException {
        return this.expandoColumnPersistence.findByTableId(tableId);
    }

    public List<ExpandoColumn> getColumns(long tableId, Collection<String> names) throws SystemException {
        return this.expandoColumnPersistence.findByT_N(tableId, names.toArray(new String[names.size()]));
    }

    public List<ExpandoColumn> getColumns(long companyId, long classNameId, String tableName) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoColumnPersistence.findByTableId(table.getTableId());
    }

    public List<ExpandoColumn> getColumns(long companyId, long classNameId, String tableName, Collection<String> names) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoColumnPersistence.findByT_N(table.getTableId(), names.toArray(new String[names.size()]));
    }

    public List<ExpandoColumn> getColumns(long companyId, String className, String tableName) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumns(companyId, classNameId, tableName);
    }

    public List<ExpandoColumn> getColumns(long companyId, String className, String tableName, Collection<String> columnNames) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumns(companyId, classNameId, tableName, columnNames);
    }

    public int getColumnsCount(long tableId) throws SystemException {
        return this.expandoColumnPersistence.countByTableId(tableId);
    }

    public int getColumnsCount(long companyId, long classNameId, String tableName) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoColumnPersistence.countByTableId(table.getTableId());
    }

    public int getColumnsCount(long companyId, String className, String tableName) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumnsCount(companyId, classNameId, tableName);
    }

    public ExpandoColumn getDefaultTableColumn(long companyId, long classNameId, String name) throws SystemException {
        return this.getColumn(companyId, classNameId, "CUSTOM_FIELDS", name);
    }

    public ExpandoColumn getDefaultTableColumn(long companyId, String className, String name) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumn(companyId, classNameId, "CUSTOM_FIELDS", name);
    }

    public List<ExpandoColumn> getDefaultTableColumns(long companyId, long classNameId) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, "CUSTOM_FIELDS");
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoColumnPersistence.findByTableId(table.getTableId());
    }

    public List<ExpandoColumn> getDefaultTableColumns(long companyId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumns(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public int getDefaultTableColumnsCount(long companyId, long classNameId) throws SystemException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, "CUSTOM_FIELDS");
        if (table == null) {
            return 0;
        }
        return this.expandoColumnPersistence.countByTableId(table.getTableId());
    }

    public int getDefaultTableColumnsCount(long companyId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumnsCount(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoColumn updateColumn(long columnId, String name, int type) throws PortalException, SystemException {
        return this.expandoColumnLocalService.updateColumn(columnId, name, type, null);
    }

    public ExpandoColumn updateColumn(long columnId, String name, int type, Object defaultData) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnPersistence.findByPrimaryKey(columnId);
        ExpandoValue value = this.validate(columnId, column.getTableId(), name, type, defaultData);
        column.setName(name);
        column.setType(type);
        column.setDefaultData(value.getData());
        this.expandoColumnPersistence.update((BaseModel)column);
        return column;
    }

    public ExpandoColumn updateTypeSettings(long columnId, String typeSettings) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnPersistence.findByPrimaryKey(columnId);
        column.setTypeSettings(typeSettings);
        this.expandoColumnPersistence.update((BaseModel)column);
        return column;
    }

    protected ExpandoValue validate(long columnId, long tableId, String name, int type, Object defaultData) throws PortalException, SystemException {
        if (Validator.isNull((String)name)) {
            throw new ColumnNameException();
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(tableId, name);
        if (column != null && column.getColumnId() != columnId) {
            throw new DuplicateColumnNameException();
        }
        if (type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 6 && type != 7 && type != 8 && type != 9 && type != 10 && type != 11 && type != 12 && type != 17 && type != 18 && type != 13 && type != 14 && type != 15 && type != 16 && type != 19 && type != 20) {
            throw new ColumnTypeException();
        }
        ExpandoValueImpl value = new ExpandoValueImpl();
        if (defaultData == null) {
            return value;
        }
        value.setColumnId(columnId);
        if (type == 1) {
            value.setBoolean((Boolean)defaultData);
        } else if (type == 2) {
            value.setBooleanArray((boolean[])defaultData);
        } else if (type == 3) {
            value.setDate((Date)defaultData);
        } else if (type == 4) {
            value.setDateArray((Date[])defaultData);
        } else if (type == 5) {
            value.setDouble((Double)defaultData);
        } else if (type == 6) {
            value.setDoubleArray((double[])defaultData);
        } else if (type == 7) {
            value.setFloat(((Float)defaultData).floatValue());
        } else if (type == 8) {
            value.setFloatArray((float[])defaultData);
        } else if (type == 9) {
            value.setInteger((Integer)defaultData);
        } else if (type == 10) {
            value.setIntegerArray((int[])defaultData);
        } else if (type == 11) {
            value.setLong((Long)defaultData);
        } else if (type == 12) {
            value.setLongArray((long[])defaultData);
        } else if (type == 17) {
            value.setNumber((Number)defaultData);
        } else if (type == 18) {
            value.setNumberArray((Number[])defaultData);
        } else if (type == 13) {
            value.setShort((Short)defaultData);
        } else if (type == 14) {
            value.setShortArray((short[])defaultData);
        } else if (type == 15) {
            value.setString((String)defaultData);
        } else if (type == 16) {
            value.setStringArray((String[])defaultData);
        } else if (type == 19) {
            value.setStringArrayMap((Map)defaultData, LocaleUtil.getDefault());
        } else if (type == 20) {
            value.setStringMap((Map)defaultData, LocaleUtil.getDefault());
        }
        return value;
    }
}

