/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.ColumnNameException;
import com.liferay.portlet.expando.ColumnTypeException;
import com.liferay.portlet.expando.DuplicateColumnNameException;
import com.liferay.portlet.expando.NoSuchColumnException;
import com.liferay.portlet.expando.ValueDataException;
import com.liferay.portlet.expando.action.ActionUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.service.ExpandoColumnServiceUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditExpandoAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add")) {
                this.addExpando(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteExpando(actionRequest);
            } else if (cmd.equals("update")) {
                this.updateExpando(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchColumnException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.expando.error");
            }
            if (e2 instanceof ColumnNameException || e2 instanceof ColumnTypeException || e2 instanceof DuplicateColumnNameException || e2 instanceof ValueDataException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getColumn((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchColumnException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.expando.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.expando.edit_expando"));
    }

    protected void addExpando(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String modelResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResource");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String preset = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)themeDisplay.getCompanyId(), (String)modelResource, (long)resourcePrimKey);
        if (preset.startsWith("Preset")) {
            this.addPresetExpando(expandoBridge, preset, name);
        } else {
            int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
            expandoBridge.addAttribute(name, type);
            this.updateProperties(actionRequest, expandoBridge, name);
        }
    }

    protected int addPresetExpando(ExpandoBridge expandoBridge, String preset, String name) throws Exception {
        int type = 0;
        UnicodeProperties properties = expandoBridge.getAttributeProperties(name);
        if (preset.equals("PresetSelectionIntegerArray()")) {
            type = 10;
            properties.setProperty("display-type", "selection-list");
        } else if (preset.equals("PresetSelectionDoubleArray()")) {
            type = 6;
            properties.setProperty("display-type", "selection-list");
        } else if (preset.equals("PresetSelectionStringArray()")) {
            type = 16;
            properties.setProperty("display-type", "selection-list");
        } else if (preset.equals("PresetTextBox()")) {
            type = 15;
            properties.setProperty("height", "105");
            properties.setProperty("width", "450");
        } else if (preset.equals("PresetTextBoxIndexed()")) {
            type = 15;
            properties.setProperty("height", "105");
            properties.setProperty("width", "450");
            properties.setProperty("index-type", String.valueOf(1));
        } else if (preset.equals("PresetTextFieldSecret()")) {
            type = 15;
            properties.setProperty("secret", Boolean.TRUE.toString());
        } else {
            type = 15;
            properties.setProperty("index-type", String.valueOf(1));
        }
        expandoBridge.addAttribute(name, type);
        expandoBridge.setAttributeProperties(name, properties);
        return type;
    }

    protected void deleteExpando(ActionRequest actionRequest) throws Exception {
        long columnId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"columnId");
        ExpandoColumnServiceUtil.deleteColumn((long)columnId);
    }

    protected Serializable getValue(PortletRequest portletRequest, String name, int type) throws PortalException, SystemException {
        String delimiter = ",";
        Object value = null;
        if (type == 1) {
            value = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)name);
        } else if (type != 2) {
            if (type == 3) {
                User user = PortalUtil.getUser((PortletRequest)portletRequest);
                int valueDateMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Month"));
                int valueDateDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Day"));
                int valueDateYear = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Year"));
                int valueDateHour = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Hour"));
                int valueDateMinute = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "Minute"));
                int valueDateAmPm = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(name) + "AmPm"));
                if (valueDateAmPm == 1) {
                    valueDateHour += 12;
                }
                value = PortalUtil.getDate((int)valueDateMonth, (int)valueDateDay, (int)valueDateYear, (int)valueDateHour, (int)valueDateMinute, (TimeZone)user.getTimeZone(), ValueDataException.class);
            } else if (type != 4) {
                if (type == 5) {
                    value = ParamUtil.getDouble((PortletRequest)portletRequest, (String)name);
                } else if (type == 6) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getDoubleValues((String[])values);
                } else if (type == 7) {
                    value = Float.valueOf(ParamUtil.getFloat((PortletRequest)portletRequest, (String)name));
                } else if (type == 8) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getFloatValues((String[])values);
                } else if (type == 9) {
                    value = ParamUtil.getInteger((PortletRequest)portletRequest, (String)name);
                } else if (type == 10) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getIntegerValues((String[])values);
                } else if (type == 11) {
                    value = ParamUtil.getLong((PortletRequest)portletRequest, (String)name);
                } else if (type == 12) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getLongValues((String[])values);
                } else if (type == 17) {
                    value = ParamUtil.getNumber((PortletRequest)portletRequest, (String)name);
                } else if (type == 18) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getNumberValues((String[])values);
                } else if (type == 13) {
                    value = ParamUtil.getShort((PortletRequest)portletRequest, (String)name);
                } else if (type == 14) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getShortValues((String[])values);
                } else if (type == 16) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    value = StringUtil.split((String)paramValue, (String)delimiter);
                } else {
                    value = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                }
            }
        }
        return value;
    }

    protected void updateExpando(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String modelResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResource");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        Serializable defaultValue = this.getValue((PortletRequest)actionRequest, "defaultValue", type);
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)themeDisplay.getCompanyId(), (String)modelResource, (long)resourcePrimKey);
        expandoBridge.setAttributeDefault(name, defaultValue);
        this.updateProperties(actionRequest, expandoBridge, name);
    }

    protected void updateProperties(ActionRequest actionRequest, ExpandoBridge expandoBridge, String name) throws Exception {
        Enumeration enu = actionRequest.getParameterNames();
        UnicodeProperties properties = expandoBridge.getAttributeProperties(name);
        ArrayList<String> propertyNames = new ArrayList<String>();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (!param.contains("PropertyName--")) continue;
            String propertyName = ParamUtil.getString((PortletRequest)actionRequest, (String)param);
            propertyNames.add(propertyName);
        }
        for (String propertyName : propertyNames) {
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)("Property--" + propertyName + "--"));
            properties.setProperty(propertyName, value);
        }
        expandoBridge.setAttributeProperties(name, properties);
    }
}

